/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.List;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.TestUtils;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.mode.TestModeBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestNamespaceMode
extends TestModeBase {
    @Override
    protected Mode getMode() {
        return Mode.NAMESPACE;
    }

    @Override
    protected void assertRecords(List<Record> records) {
        TestUtils.assertRecordsInNamespaceMode(records);
    }

    @Override
    protected void assertDrillDown(Record currentRecord, DrillDownInfo drillDownInfo) {
        Assert.assertThat((Object)drillDownInfo.getNextMode(), (Matcher)CoreMatchers.is((Object)Mode.TABLE));
        Assert.assertThat((Object)drillDownInfo.getInitialFilters().size(), (Matcher)CoreMatchers.is((Object)1));
        switch (currentRecord.get((Object)Field.NAMESPACE).asString()) {
            case "default": {
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"NAMESPACE==default"));
                break;
            }
            case "namespace": {
                Assert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"NAMESPACE==namespace"));
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }
}

