/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.field;

import org.apache.hadoop.hbase.hbtop.field.FieldValue;
import org.apache.hadoop.hbase.hbtop.field.FieldValueType;
import org.apache.hadoop.hbase.hbtop.field.Size;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFieldValue {
    @Test
    public void testParseAndAsSomethingMethod() {
        FieldValue stringFieldValue = new FieldValue((Object)"aaa", FieldValueType.STRING);
        Assert.assertThat((Object)stringFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"aaa"));
        try {
            new FieldValue((Object)1, FieldValueType.STRING);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FieldValue integerFieldValue = new FieldValue((Object)100, FieldValueType.INTEGER);
        Assert.assertThat((Object)integerFieldValue.asInt(), (Matcher)CoreMatchers.is((Object)100));
        integerFieldValue = new FieldValue((Object)"100", FieldValueType.INTEGER);
        Assert.assertThat((Object)integerFieldValue.asInt(), (Matcher)CoreMatchers.is((Object)100));
        try {
            new FieldValue((Object)"aaa", FieldValueType.INTEGER);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FieldValue longFieldValue = new FieldValue((Object)100L, FieldValueType.LONG);
        Assert.assertThat((Object)longFieldValue.asLong(), (Matcher)CoreMatchers.is((Object)100L));
        longFieldValue = new FieldValue((Object)"100", FieldValueType.LONG);
        Assert.assertThat((Object)longFieldValue.asLong(), (Matcher)CoreMatchers.is((Object)100L));
        try {
            new FieldValue((Object)"aaa", FieldValueType.LONG);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new FieldValue((Object)100, FieldValueType.LONG);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FieldValue floatFieldValue = new FieldValue((Object)Float.valueOf(1.0f), FieldValueType.FLOAT);
        Assert.assertThat((Object)Float.valueOf(floatFieldValue.asFloat()), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        floatFieldValue = new FieldValue((Object)"1", FieldValueType.FLOAT);
        Assert.assertThat((Object)Float.valueOf(floatFieldValue.asFloat()), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        try {
            new FieldValue((Object)"aaa", FieldValueType.FLOAT);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new FieldValue((Object)1, FieldValueType.FLOAT);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FieldValue sizeFieldValue = new FieldValue((Object)new Size(100.0, Size.Unit.MEGABYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"100.0MB"));
        Assert.assertThat((Object)sizeFieldValue.asSize(), (Matcher)CoreMatchers.is((Object)new Size(100.0, Size.Unit.MEGABYTE)));
        sizeFieldValue = new FieldValue((Object)"100MB", FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"100.0MB"));
        Assert.assertThat((Object)sizeFieldValue.asSize(), (Matcher)CoreMatchers.is((Object)new Size(100.0, Size.Unit.MEGABYTE)));
        try {
            new FieldValue((Object)"100", FieldValueType.SIZE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new FieldValue((Object)100, FieldValueType.SIZE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FieldValue percentFieldValue = new FieldValue((Object)Float.valueOf(100.0f), FieldValueType.PERCENT);
        Assert.assertThat((Object)percentFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"100.00%"));
        Assert.assertThat((Object)Float.valueOf(percentFieldValue.asFloat()), (Matcher)CoreMatchers.is((Object)Float.valueOf(100.0f)));
        percentFieldValue = new FieldValue((Object)"100%", FieldValueType.PERCENT);
        Assert.assertThat((Object)percentFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"100.00%"));
        Assert.assertThat((Object)Float.valueOf(percentFieldValue.asFloat()), (Matcher)CoreMatchers.is((Object)Float.valueOf(100.0f)));
        percentFieldValue = new FieldValue((Object)"100", FieldValueType.PERCENT);
        Assert.assertThat((Object)percentFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"100.00%"));
        Assert.assertThat((Object)Float.valueOf(percentFieldValue.asFloat()), (Matcher)CoreMatchers.is((Object)Float.valueOf(100.0f)));
        try {
            new FieldValue((Object)100, FieldValueType.PERCENT);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCompareTo() {
        FieldValue stringAFieldValue = new FieldValue((Object)"a", FieldValueType.STRING);
        FieldValue stringAFieldValue2 = new FieldValue((Object)"a", FieldValueType.STRING);
        FieldValue stringBFieldValue = new FieldValue((Object)"b", FieldValueType.STRING);
        FieldValue stringCapitalAFieldValue = new FieldValue((Object)"A", FieldValueType.STRING);
        Assert.assertThat((Object)stringAFieldValue.compareTo(stringAFieldValue2), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)stringBFieldValue.compareTo(stringAFieldValue), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)stringAFieldValue.compareTo(stringBFieldValue), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)stringAFieldValue.compareTo(stringCapitalAFieldValue), (Matcher)CoreMatchers.is((Object)32));
        FieldValue integer1FieldValue = new FieldValue((Object)1, FieldValueType.INTEGER);
        FieldValue integer1FieldValue2 = new FieldValue((Object)1, FieldValueType.INTEGER);
        FieldValue integer2FieldValue = new FieldValue((Object)2, FieldValueType.INTEGER);
        Assert.assertThat((Object)integer1FieldValue.compareTo(integer1FieldValue2), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)integer2FieldValue.compareTo(integer1FieldValue), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)integer1FieldValue.compareTo(integer2FieldValue), (Matcher)CoreMatchers.is((Object)-1));
        FieldValue long1FieldValue = new FieldValue((Object)1L, FieldValueType.LONG);
        FieldValue long1FieldValue2 = new FieldValue((Object)1L, FieldValueType.LONG);
        FieldValue long2FieldValue = new FieldValue((Object)2L, FieldValueType.LONG);
        Assert.assertThat((Object)long1FieldValue.compareTo(long1FieldValue2), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)long2FieldValue.compareTo(long1FieldValue), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)long1FieldValue.compareTo(long2FieldValue), (Matcher)CoreMatchers.is((Object)-1));
        FieldValue float1FieldValue = new FieldValue((Object)Float.valueOf(1.0f), FieldValueType.FLOAT);
        FieldValue float1FieldValue2 = new FieldValue((Object)Float.valueOf(1.0f), FieldValueType.FLOAT);
        FieldValue float2FieldValue = new FieldValue((Object)Float.valueOf(2.0f), FieldValueType.FLOAT);
        Assert.assertThat((Object)float1FieldValue.compareTo(float1FieldValue2), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)float2FieldValue.compareTo(float1FieldValue), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)float1FieldValue.compareTo(float2FieldValue), (Matcher)CoreMatchers.is((Object)-1));
        FieldValue size100MBFieldValue = new FieldValue((Object)new Size(100.0, Size.Unit.MEGABYTE), FieldValueType.SIZE);
        FieldValue size100MBFieldValue2 = new FieldValue((Object)new Size(100.0, Size.Unit.MEGABYTE), FieldValueType.SIZE);
        FieldValue size200MBFieldValue = new FieldValue((Object)new Size(200.0, Size.Unit.MEGABYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)size100MBFieldValue.compareTo(size100MBFieldValue2), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)size200MBFieldValue.compareTo(size100MBFieldValue), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)size100MBFieldValue.compareTo(size200MBFieldValue), (Matcher)CoreMatchers.is((Object)-1));
        FieldValue percent50FieldValue = new FieldValue((Object)Float.valueOf(50.0f), FieldValueType.PERCENT);
        FieldValue percent50FieldValue2 = new FieldValue((Object)Float.valueOf(50.0f), FieldValueType.PERCENT);
        FieldValue percent100FieldValue = new FieldValue((Object)Float.valueOf(100.0f), FieldValueType.PERCENT);
        Assert.assertThat((Object)percent50FieldValue.compareTo(percent50FieldValue2), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)percent100FieldValue.compareTo(percent50FieldValue), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)percent50FieldValue.compareTo(percent100FieldValue), (Matcher)CoreMatchers.is((Object)-1));
    }

    @Test
    public void testPlus() {
        FieldValue stringFieldValue = new FieldValue((Object)"a", FieldValueType.STRING);
        FieldValue stringFieldValue2 = new FieldValue((Object)"b", FieldValueType.STRING);
        Assert.assertThat((Object)stringFieldValue.plus(stringFieldValue2).asString(), (Matcher)CoreMatchers.is((Object)"ab"));
        FieldValue integerFieldValue = new FieldValue((Object)1, FieldValueType.INTEGER);
        FieldValue integerFieldValue2 = new FieldValue((Object)2, FieldValueType.INTEGER);
        Assert.assertThat((Object)integerFieldValue.plus(integerFieldValue2).asInt(), (Matcher)CoreMatchers.is((Object)3));
        FieldValue longFieldValue = new FieldValue((Object)1L, FieldValueType.LONG);
        FieldValue longFieldValue2 = new FieldValue((Object)2L, FieldValueType.LONG);
        Assert.assertThat((Object)longFieldValue.plus(longFieldValue2).asLong(), (Matcher)CoreMatchers.is((Object)3L));
        FieldValue floatFieldValue = new FieldValue((Object)Float.valueOf(1.2f), FieldValueType.FLOAT);
        FieldValue floatFieldValue2 = new FieldValue((Object)Float.valueOf(2.2f), FieldValueType.FLOAT);
        Assert.assertThat((Object)Float.valueOf(floatFieldValue.plus(floatFieldValue2).asFloat()), (Matcher)CoreMatchers.is((Object)Float.valueOf(3.4f)));
        FieldValue sizeFieldValue = new FieldValue((Object)new Size(100.0, Size.Unit.MEGABYTE), FieldValueType.SIZE);
        FieldValue sizeFieldValue2 = new FieldValue((Object)new Size(200.0, Size.Unit.MEGABYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.plus(sizeFieldValue2).asString(), (Matcher)CoreMatchers.is((Object)"300.0MB"));
        Assert.assertThat((Object)sizeFieldValue.plus(sizeFieldValue2).asSize(), (Matcher)CoreMatchers.is((Object)new Size(300.0, Size.Unit.MEGABYTE)));
        FieldValue percentFieldValue = new FieldValue((Object)Float.valueOf(30.0f), FieldValueType.PERCENT);
        FieldValue percentFieldValue2 = new FieldValue((Object)Float.valueOf(60.0f), FieldValueType.PERCENT);
        Assert.assertThat((Object)percentFieldValue.plus(percentFieldValue2).asString(), (Matcher)CoreMatchers.is((Object)"90.00%"));
        Assert.assertThat((Object)Float.valueOf(percentFieldValue.plus(percentFieldValue2).asFloat()), (Matcher)CoreMatchers.is((Object)Float.valueOf(90.0f)));
    }

    @Test
    public void testCompareToIgnoreCase() {
        FieldValue stringAFieldValue = new FieldValue((Object)"a", FieldValueType.STRING);
        FieldValue stringCapitalAFieldValue = new FieldValue((Object)"A", FieldValueType.STRING);
        FieldValue stringCapitalBFieldValue = new FieldValue((Object)"B", FieldValueType.STRING);
        Assert.assertThat((Object)stringAFieldValue.compareToIgnoreCase(stringCapitalAFieldValue), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)stringCapitalBFieldValue.compareToIgnoreCase(stringAFieldValue), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)stringAFieldValue.compareToIgnoreCase(stringCapitalBFieldValue), (Matcher)CoreMatchers.is((Object)-1));
    }

    @Test
    public void testOptimizeSize() {
        FieldValue sizeFieldValue = new FieldValue((Object)new Size(1.0, Size.Unit.BYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"1.0B"));
        sizeFieldValue = new FieldValue((Object)new Size(1024.0, Size.Unit.BYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"1.0KB"));
        sizeFieldValue = new FieldValue((Object)new Size(2048.0, Size.Unit.BYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"2.0KB"));
        sizeFieldValue = new FieldValue((Object)new Size(2048.0, Size.Unit.KILOBYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"2.0MB"));
        sizeFieldValue = new FieldValue((Object)new Size(1048576.0, Size.Unit.KILOBYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"1.0GB"));
        sizeFieldValue = new FieldValue((Object)new Size(2097152.0, Size.Unit.MEGABYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"2.0TB"));
        sizeFieldValue = new FieldValue((Object)new Size(2048.0, Size.Unit.TERABYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"2.0PB"));
        sizeFieldValue = new FieldValue((Object)new Size(1048576.0, Size.Unit.TERABYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"1024.0PB"));
        sizeFieldValue = new FieldValue((Object)new Size(1.0, Size.Unit.PETABYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"1.0PB"));
        sizeFieldValue = new FieldValue((Object)new Size(1024.0, Size.Unit.PETABYTE), FieldValueType.SIZE);
        Assert.assertThat((Object)sizeFieldValue.asString(), (Matcher)CoreMatchers.is((Object)"1024.0PB"));
    }
}

