/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.MultiTableOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.GenericOptionsParser;

public class IndexBuilder {
    public static final byte[] INDEX_COLUMN = Bytes.toBytes((String)"INDEX");
    public static final byte[] INDEX_QUALIFIER = Bytes.toBytes((String)"ROW");

    public static Job configureJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        String columnFamily = args[1];
        System.out.println("****" + tableName);
        conf.set("hbase.mapreduce.scan", TableMapReduceUtil.convertScanToString((Scan)new Scan()));
        conf.set("hbase.mapreduce.inputtable", tableName);
        conf.set("index.tablename", tableName);
        conf.set("index.familyname", columnFamily);
        String[] fields = new String[args.length - 2];
        System.arraycopy(args, 2, fields, 0, fields.length);
        conf.setStrings("index.fields", fields);
        Job job = new Job(conf, tableName);
        job.setJarByClass(IndexBuilder.class);
        job.setMapperClass(Map.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(TableInputFormat.class);
        job.setOutputFormatClass(MultiTableOutputFormat.class);
        return job;
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 3) {
            System.err.println("Only " + otherArgs.length + " arguments supplied, required: 3");
            System.err.println("Usage: IndexBuilder <TABLE_NAME> <COLUMN_FAMILY> <ATTR> [<ATTR> ...]");
            System.exit(-1);
        }
        System.exit((job = IndexBuilder.configureJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    public static class Map
    extends Mapper<ImmutableBytesWritable, Result, ImmutableBytesWritable, Put> {
        private byte[] family;
        private TreeMap<byte[], ImmutableBytesWritable> indexes;

        protected void map(ImmutableBytesWritable rowKey, Result result, Mapper.Context context) throws IOException, InterruptedException {
            for (Map.Entry<byte[], ImmutableBytesWritable> index : this.indexes.entrySet()) {
                byte[] qualifier = index.getKey();
                ImmutableBytesWritable tableName = index.getValue();
                byte[] value = result.getValue(this.family, qualifier);
                if (value == null) continue;
                Put put = new Put(value);
                put.add(INDEX_COLUMN, INDEX_QUALIFIER, rowKey.get());
                context.write((Object)tableName, (Object)put);
            }
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration configuration = context.getConfiguration();
            String tableName = configuration.get("index.tablename");
            String[] fields = configuration.getStrings("index.fields");
            String familyName = configuration.get("index.familyname");
            this.family = Bytes.toBytes((String)familyName);
            this.indexes = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (String field : fields) {
                this.indexes.put(Bytes.toBytes((String)field), new ImmutableBytesWritable(Bytes.toBytes((String)(tableName + "-" + field))));
            }
        }
    }
}

