/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.types.PBCell;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedByteRange;
import org.junit.Assert;
import org.junit.Test;

public class TestPBCell {
    private static final PBCell CODEC = new PBCell();

    @Test
    public void testRoundTrip() {
        KeyValue cell = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"val"));
        CellProtos.Cell c = ProtobufUtil.toCell((Cell)cell);
        SimplePositionedByteRange pbr = new SimplePositionedByteRange(c.getSerializedSize());
        pbr.setPosition(0);
        int encodedLength = CODEC.encode((PositionedByteRange)pbr, c);
        pbr.setPosition(0);
        CellProtos.Cell decoded = CODEC.decode((PositionedByteRange)pbr);
        Assert.assertEquals((long)encodedLength, (long)pbr.getPosition());
        Assert.assertTrue((boolean)CellComparator.equals((Cell)cell, (Cell)ProtobufUtil.toCell((CellProtos.Cell)decoded)));
    }
}

