/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.AbstractQueue;
import java.util.Iterator;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class BoundedArrayQueue<E>
extends AbstractQueue<E> {
    private Object[] items;
    private int takeIndex;
    private int putIndex;
    private int count;

    public BoundedArrayQueue(int maxElements) {
        this.items = new Object[maxElements];
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e) {
        if (this.count == this.items.length) {
            return false;
        }
        this.items[this.putIndex] = e;
        if (++this.putIndex == this.items.length) {
            this.putIndex = 0;
        }
        ++this.count;
        return true;
    }

    @Override
    public E poll() {
        return this.count == 0 ? null : (E)this.dequeue();
    }

    private E dequeue() {
        Object x = this.items[this.takeIndex];
        this.items[this.takeIndex] = null;
        if (++this.takeIndex == this.items.length) {
            this.takeIndex = 0;
        }
        --this.count;
        return (E)x;
    }

    @Override
    public E peek() {
        return (E)this.items[this.takeIndex];
    }
}

