/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.mapr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class Test98HBase
extends Configured
implements Tool {
    private static final byte[] CF1 = Bytes.toBytes((String)"cf1");
    private static final byte[] CF2 = Bytes.toBytes((String)"cf2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] argv) throws IOException {
        if (argv.length < 1) {
            System.out.println("Test the table operations with HBase 0.98 style. Usage:\n\t hbase org.apache.hadoop.hbase.client.Test98HBase tableName");
            return -1;
        }
        String tableName = argv[0];
        Configuration config = HBaseConfiguration.create();
        String defaultDb = config.get("mapr.hbase.default.db", "unsetDB");
        System.out.println("mapr.hbase.default.db=" + defaultDb);
        HTable table = null;
        HTableInterface table2 = null;
        HBaseAdmin admin = null;
        Admin admin2 = null;
        try {
            admin = new HBaseAdmin(config);
            if (admin.tableExists(tableName)) {
                admin.disableTable(tableName);
                admin.deleteTable(tableName);
            }
            HTableDescriptor tableDesc = new HTableDescriptor(tableName);
            HColumnDescriptor hcd1 = new HColumnDescriptor(CF1);
            HColumnDescriptor hcd2 = new HColumnDescriptor(CF2);
            tableDesc.addFamily(hcd1);
            tableDesc.addFamily(hcd2);
            admin.createTable(tableDesc);
            table = new HTable(config, tableName);
            Put p = new Put(Bytes.toBytes((String)"row1"));
            p.addColumn(CF1, Bytes.toBytes((String)"col1"), Bytes.toBytes((String)"val11"));
            p.addColumn(CF2, Bytes.toBytes((String)"col2"), Bytes.toBytes((String)"val12"));
            table.put(p);
            Put p2 = new Put(Bytes.toBytes((String)"row2"));
            p2.addColumn(CF1, Bytes.toBytes((String)"col2"), Bytes.toBytes((String)"val21"));
            p2.addColumn(CF2, Bytes.toBytes((String)"col1"), Bytes.toBytes((String)"val22"));
            table.put(p2);
            Scan scan = new Scan();
            System.out.println("-----After put-----");
            ResultScanner scanner1 = table.getScanner(scan);
            Result result = scanner1.next();
            while (result != null) {
                for (KeyValue keyValue : result.list()) {
                    System.out.println("Qualifier : " + keyValue.getKeyString() + " : Value : " + Bytes.toString((byte[])keyValue.getValue()));
                }
                result = scanner1.next();
            }
            Delete del = new Delete(Bytes.toBytes((String)"row1"));
            del.addColumn(CF1, Bytes.toBytes((String)"col1"));
            table.delete(del);
            Delete del2 = new Delete(Bytes.toBytes((String)"row2"));
            del2.addFamily(CF2);
            table.delete(del2);
            System.out.println("-----After delete-----");
            ResultScanner scanner2 = table.getScanner(scan);
            Result result2 = scanner2.next();
            while (result2 != null) {
                for (KeyValue keyValue : result2.list()) {
                    System.out.println("Qualifier : " + keyValue.getKeyString() + " : Value : " + Bytes.toString((byte[])keyValue.getValue()));
                }
                result2 = scanner2.next();
            }
            System.out.println("-----create another admin through the connection should NOT work-----");
            try {
                admin2 = admin.getConnection().getAdmin();
            }
            catch (NeedUnmanagedConnectionException e) {
                System.out.println("-----NeedUnmanagedConnectionException is thrown as expected-----");
            }
            System.out.println("-----create another admin through the connection should NOT work-----");
            try {
                table2 = admin.getConnection().getTable(tableName);
            }
            catch (NeedUnmanagedConnectionException e) {
                System.out.println("-----NeedUnmanagedConnectionException is thrown as expected-----");
            }
        }
        finally {
            if (table != null) {
                table.close();
            }
            if (admin != null) {
                admin.close();
            }
            if (admin2 != null) {
                admin2.close();
            }
            if (table2 != null) {
                table2.close();
            }
        }
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int ret = ToolRunner.run((Tool)new Test98HBase(), (String[])argv);
        System.exit(ret);
    }
}

