/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.yammer.metrics.util.RatioGauge;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestMetricsConnection {
    private static final ExecutorService BATCH_POOL = Executors.newFixedThreadPool(2);
    private static MetricsConnection METRICS;
    private static final AtomicBoolean closed;
    private static final Runnable RUNNER;

    @BeforeClass
    public static void beforeClass() {
        ConnectionManager.HConnectionImplementation mocked = (ConnectionManager.HConnectionImplementation)Mockito.mock(ConnectionManager.HConnectionImplementation.class);
        Mockito.when((Object)mocked.toString()).thenReturn((Object)"mocked-connection");
        Mockito.when((Object)mocked.getCurrentBatchPool()).thenReturn((Object)BATCH_POOL);
        BATCH_POOL.submit(RUNNER);
        METRICS = new MetricsConnection(mocked);
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        METRICS.shutdown();
        BATCH_POOL.shutdownNow();
        BATCH_POOL.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
    }

    @Test
    public void testStaticMetrics() throws IOException {
        byte[] foo = Bytes.toBytes((String)"foo");
        HBaseProtos.RegionSpecifier region = HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.EMPTY).setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).build();
        int loop = 5;
        for (int i = 0; i < 5; ++i) {
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Get"), (Message)ClientProtos.GetRequest.getDefaultInstance(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Scan"), (Message)ClientProtos.ScanRequest.getDefaultInstance(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Multi"), (Message)ClientProtos.MultiRequest.getDefaultInstance(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.APPEND, (Mutation)new Append(foo))).setRegion(region).build(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)new Delete(foo))).setRegion(region).build(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.INCREMENT, (Mutation)new Increment(foo))).setRegion(region).build(), MetricsConnection.newCallStats());
            METRICS.updateRpc(ClientProtos.ClientService.getDescriptor().findMethodByName("Mutate"), (Message)ClientProtos.MutateRequest.newBuilder().setMutation(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)new Put(foo))).setRegion(region).build(), MetricsConnection.newCallStats());
        }
        for (MetricsConnection.CallTracker t : new MetricsConnection.CallTracker[]{TestMetricsConnection.METRICS.getTracker, TestMetricsConnection.METRICS.scanTracker, TestMetricsConnection.METRICS.multiTracker, TestMetricsConnection.METRICS.appendTracker, TestMetricsConnection.METRICS.deleteTracker, TestMetricsConnection.METRICS.incrementTracker, TestMetricsConnection.METRICS.putTracker}) {
            Assert.assertEquals((String)("Failed to invoke callTimer on " + t), (long)5L, (long)t.callTimer.count());
            Assert.assertEquals((String)("Failed to invoke reqHist on " + t), (long)5L, (long)t.reqHist.count());
            Assert.assertEquals((String)("Failed to invoke respHist on " + t), (long)5L, (long)t.respHist.count());
        }
        RatioGauge executorMetrics = (RatioGauge)METRICS.getMetricsRegistry().allMetrics().get(METRICS.getExecutorPoolName());
        RatioGauge metaMetrics = (RatioGauge)METRICS.getMetricsRegistry().allMetrics().get(METRICS.getMetaPoolName());
        Assert.assertEquals((double)0.5, (double)executorMetrics.value(), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)metaMetrics.value(), (double)0.0);
    }

    static {
        closed = new AtomicBoolean(false);
        RUNNER = new Runnable(){

            @Override
            public void run() {
                try {
                    while (!closed.get() && !Thread.interrupted()) {
                        TimeUnit.MILLISECONDS.sleep(10L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }
}

