/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.service.ServiceClientTest;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.api.records.ServiceStatus;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.conf.RestApiConstants;
import org.apache.hadoop.yarn.service.webapp.ApiServer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestApiServer {
    private ApiServer apiServer;
    private HttpServletRequest request;
    private ServiceClientTest mockServerClient;

    @BeforeEach
    public void setup() throws Exception {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)System.getProperty("user.name"));
        this.mockServerClient = new ServiceClientTest();
        Configuration conf = new Configuration();
        conf.set("yarn.api-service.service.client.class", ServiceClientTest.class.getName());
        this.apiServer = new ApiServer(conf);
        this.apiServer.setServiceClient((ServiceClient)this.mockServerClient);
    }

    @AfterEach
    public void teardown() {
        this.mockServerClient.forceStop();
    }

    @Test
    void testPathAnnotation() {
        Assertions.assertNotNull((Object)this.apiServer.getClass().getAnnotation(Path.class));
        Assertions.assertTrue((boolean)this.apiServer.getClass().isAnnotationPresent(Path.class), (String)"The controller has the annotation Path");
        Path path = this.apiServer.getClass().getAnnotation(Path.class);
        Assertions.assertEquals((Object)"/v1", (Object)path.value(), (String)"The path has /v1 annotation");
    }

    @Test
    void testGetVersion() {
        Response actual = this.apiServer.getVersion();
        Assertions.assertEquals((int)Response.ok().build().getStatus(), (int)actual.getStatus(), (String)"Version number is");
    }

    @Test
    void testBadCreateService() {
        Service service = new Service();
        Response actual = this.apiServer.createService(this.request, service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"Create service is ");
    }

    @Test
    void testGoodCreateService() throws Exception {
        String json = "{\"auths\": {\"https://index.docker.io/v1/\": {\"auth\": \"foobarbaz\"},\"registry.example.com\": {\"auth\": \"bazbarfoo\"}}}";
        File dockerTmpDir = new File("target", "docker-tmp");
        FileUtils.deleteQuietly((File)dockerTmpDir);
        dockerTmpDir.mkdirs();
        String dockerConfig = dockerTmpDir + "/config.json";
        BufferedWriter bw = new BufferedWriter(new FileWriter(dockerConfig));
        bw.write(json);
        bw.close();
        Service service = ServiceClientTest.buildGoodService();
        Response actual = this.apiServer.createService(this.request, service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (int)actual.getStatus(), (String)"Create service is ");
    }

    @Test
    void testInternalServerErrorDockerClientConfigMissingCreateService() {
        Service service = new Service();
        service.setName("jenkins");
        service.setVersion("v1");
        service.setDockerClientConfig("/does/not/exist/config.json");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(1L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.createService(this.request, service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"Create service is ");
    }

    @Test
    void testBadGetService() {
        String serviceName = "nonexistent-jenkins";
        Response actual = this.apiServer.getService(this.request, "nonexistent-jenkins");
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.NOT_FOUND).build().getStatus(), (int)actual.getStatus(), (String)"Get service is ");
        ServiceStatus serviceStatus = (ServiceStatus)actual.getEntity();
        Assertions.assertEquals((Integer)RestApiConstants.ERROR_CODE_APP_NAME_INVALID, (Integer)serviceStatus.getCode(), (String)"Response code don't match");
        Assertions.assertEquals((Object)"Service nonexistent-jenkins not found", (Object)serviceStatus.getDiagnostics(), (String)"Response diagnostics don't match");
    }

    @Test
    void testBadGetService2() {
        Response actual = this.apiServer.getService(this.request, null);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.NOT_FOUND).build().getStatus(), (int)actual.getStatus(), (String)"Get service is ");
        ServiceStatus serviceStatus = (ServiceStatus)actual.getEntity();
        Assertions.assertEquals((Integer)RestApiConstants.ERROR_CODE_APP_NAME_INVALID, (Integer)serviceStatus.getCode(), (String)"Response code don't match");
        Assertions.assertEquals((Object)"Service name cannot be null.", (Object)serviceStatus.getDiagnostics(), (String)"Response diagnostics don't match");
    }

    @Test
    void testGoodGetService() {
        Response actual = this.apiServer.getService(this.request, "jenkins");
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (int)actual.getStatus(), (String)"Get service is ");
    }

    @Test
    void testBadDeleteService() {
        Response actual = this.apiServer.deleteService(this.request, "no-jenkins");
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"Delete service is ");
    }

    @Test
    void testBadDeleteService2() {
        Response actual = this.apiServer.deleteService(this.request, null);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"Delete service is ");
    }

    @Test
    void testBadDeleteService3() {
        Response actual = this.apiServer.deleteService(this.request, "jenkins-doesn't-exist");
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"Delete service is ");
    }

    @Test
    void testBadDeleteService4() {
        Response actual = this.apiServer.deleteService(this.request, "jenkins-error-cleaning-registry");
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build().getStatus(), (int)actual.getStatus(), (String)"Delete service is ");
    }

    @Test
    void testGoodDeleteService() {
        Response actual = this.apiServer.deleteService(this.request, "jenkins");
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (int)actual.getStatus(), (String)"Delete service is ");
    }

    @Test
    void testDeleteStoppedService() {
        Response actual = this.apiServer.deleteService(this.request, "jenkins-already-stopped");
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (int)actual.getStatus(), (String)"Delete service is ");
    }

    @Test
    void testDecreaseContainerAndStop() {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(0L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.updateService(this.request, "jenkins", service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (int)actual.getStatus(), (String)"update service is ");
    }

    @Test
    void testBadDecreaseContainerAndStop() {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("no-jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("no-jenkins");
        c.setNumberOfContainers(Long.valueOf(-1L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        System.out.println("before stop");
        Response actual = this.apiServer.updateService(this.request, "no-jenkins", service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"flex service is ");
    }

    @Test
    void testIncreaseContainersAndStart() {
        Service service = new Service();
        service.setState(ServiceState.STARTED);
        service.setName("jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(2L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.updateService(this.request, "jenkins", service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (int)actual.getStatus(), (String)"flex service is ");
    }

    @Test
    void testBadStartServices() {
        Service service = new Service();
        service.setState(ServiceState.STARTED);
        service.setName("no-jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(2L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.updateService(this.request, "no-jenkins", service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"start service is ");
    }

    @Test
    void testGoodStartServices() {
        Service service = new Service();
        service.setState(ServiceState.STARTED);
        service.setName("jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("jenkins");
        c.setNumberOfContainers(Long.valueOf(2L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        Response actual = this.apiServer.updateService(this.request, "jenkins", service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (int)actual.getStatus(), (String)"start service is ");
    }

    @Test
    void testBadStopServices() {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("no-jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("no-jenkins");
        c.setNumberOfContainers(Long.valueOf(-1L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        System.out.println("before stop");
        Response actual = this.apiServer.updateService(this.request, "no-jenkins", service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"stop service is ");
    }

    @Test
    void testGoodStopServices() {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("jenkins");
        System.out.println("before stop");
        Response actual = this.apiServer.updateService(this.request, "jenkins", service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.OK).build().getStatus(), (int)actual.getStatus(), (String)"stop service is ");
    }

    @Test
    void testBadSecondStopServices() throws Exception {
        Service service = new Service();
        service.setState(ServiceState.STOPPED);
        service.setName("jenkins-second-stop");
        System.out.println("before second stop");
        Response actual = this.apiServer.updateService(this.request, "jenkins-second-stop", service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"stop service should have thrown 400 Bad Request: ");
        ServiceStatus serviceStatus = (ServiceStatus)actual.getEntity();
        Assertions.assertEquals((Object)"Service jenkins-second-stop is already stopped", (Object)serviceStatus.getDiagnostics(), (String)"Stop service should have failed with service already stopped");
    }

    @Test
    void testUpdateService() {
        Service service = new Service();
        service.setState(ServiceState.STARTED);
        service.setName("no-jenkins");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("jenkins:latest");
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("2048");
        ArrayList<Component> components = new ArrayList<Component>();
        Component c = new Component();
        c.setName("no-jenkins");
        c.setNumberOfContainers(Long.valueOf(-1L));
        c.setArtifact(artifact);
        c.setLaunchCommand("");
        c.setResource(resource);
        components.add(c);
        service.setComponents(components);
        System.out.println("before stop");
        Response actual = this.apiServer.updateService(this.request, "no-jenkins", service);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"update service is ");
    }

    @Test
    void testUpdateComponent() {
        Response actual = this.apiServer.updateComponent(this.request, "jenkins", "jenkins-master", null);
        ServiceStatus serviceStatus = (ServiceStatus)actual.getEntity();
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"Update component should have failed with 400 bad request");
        Assertions.assertEquals((Object)"No component data provided", (Object)serviceStatus.getDiagnostics(), (String)"Update component should have failed with no data error");
        Component comp = new Component();
        actual = this.apiServer.updateComponent(this.request, "jenkins", "jenkins-master", comp);
        serviceStatus = (ServiceStatus)actual.getEntity();
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"Update component should have failed with 400 bad request");
        Assertions.assertEquals((Object)"No container count provided", (Object)serviceStatus.getDiagnostics(), (String)"Update component should have failed with no count error");
        comp.setNumberOfContainers(Long.valueOf(-1L));
        actual = this.apiServer.updateComponent(this.request, "jenkins", "jenkins-master", comp);
        serviceStatus = (ServiceStatus)actual.getEntity();
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"Update component should have failed with 400 bad request");
        Assertions.assertEquals((Object)"Invalid number of containers specified -1", (Object)serviceStatus.getDiagnostics(), (String)"Update component should have failed with no count error");
        comp.setName("jenkins-slave");
        comp.setNumberOfContainers(Long.valueOf(1L));
        actual = this.apiServer.updateComponent(this.request, "jenkins", "jenkins-master", comp);
        serviceStatus = (ServiceStatus)actual.getEntity();
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.BAD_REQUEST).build().getStatus(), (int)actual.getStatus(), (String)"Update component should have failed with 400 bad request");
        Assertions.assertEquals((Object)"Component name in the request object (jenkins-slave) does not match that in the URI path (jenkins-master)", (Object)serviceStatus.getDiagnostics(), (String)"Update component should have failed with component name mismatch error");
    }

    @Test
    void testInitiateUpgrade() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        goodService.setVersion("v2");
        goodService.setState(ServiceState.UPGRADING);
        Response actual = this.apiServer.updateService(this.request, goodService.getName(), goodService);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (int)actual.getStatus(), (String)"Initiate upgrade is ");
    }

    @Test
    void testUpgradeSingleInstance() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        Component comp = (Component)goodService.getComponents().iterator().next();
        Container container = (Container)comp.getContainers().iterator().next();
        container.setState(ContainerState.UPGRADING);
        Service serviceStatus = this.mockServerClient.getGoodServiceStatus();
        serviceStatus.setState(ServiceState.UPGRADING);
        Container liveContainer = (Container)((Component)serviceStatus.getComponents().iterator().next()).getContainers().iterator().next();
        liveContainer.setState(ContainerState.NEEDS_UPGRADE);
        this.mockServerClient.setExpectedInstances(Sets.newHashSet((Object[])new String[]{liveContainer.getComponentInstanceName()}));
        Response actual = this.apiServer.updateComponentInstance(this.request, goodService.getName(), comp.getName(), container.getComponentInstanceName(), container);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (int)actual.getStatus(), (String)"Instance upgrade is ");
    }

    @Test
    void testUpgradeMultipleInstances() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        Component comp = (Component)goodService.getComponents().iterator().next();
        comp.getContainers().forEach(container -> container.setState(ContainerState.UPGRADING));
        Service serviceStatus = this.mockServerClient.getGoodServiceStatus();
        serviceStatus.setState(ServiceState.UPGRADING);
        HashSet<String> expectedInstances = new HashSet<String>();
        ((Component)serviceStatus.getComponents().iterator().next()).getContainers().forEach(container -> {
            container.setState(ContainerState.NEEDS_UPGRADE);
            expectedInstances.add(container.getComponentInstanceName());
        });
        this.mockServerClient.setExpectedInstances(expectedInstances);
        Response actual = this.apiServer.updateComponentInstances(this.request, goodService.getName(), comp.getContainers());
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (int)actual.getStatus(), (String)"Instance upgrade is ");
    }

    @Test
    void testUpgradeComponent() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        Component comp = (Component)goodService.getComponents().iterator().next();
        comp.setState(ComponentState.UPGRADING);
        Service serviceStatus = this.mockServerClient.getGoodServiceStatus();
        serviceStatus.setState(ServiceState.UPGRADING);
        Component liveComp = serviceStatus.getComponent(comp.getName());
        liveComp.setState(ComponentState.NEEDS_UPGRADE);
        HashSet<String> expectedInstances = new HashSet<String>();
        liveComp.getContainers().forEach(container -> {
            expectedInstances.add(container.getComponentInstanceName());
            container.setState(ContainerState.NEEDS_UPGRADE);
        });
        this.mockServerClient.setExpectedInstances(expectedInstances);
        Response actual = this.apiServer.updateComponent(this.request, goodService.getName(), comp.getName(), comp);
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (int)actual.getStatus(), (String)"Component upgrade is ");
    }

    @Test
    void testUpgradeMultipleComps() {
        Service goodService = ServiceClientTest.buildLiveGoodService();
        goodService.getComponents().forEach(comp -> comp.setState(ComponentState.UPGRADING));
        Service serviceStatus = this.mockServerClient.getGoodServiceStatus();
        serviceStatus.setState(ServiceState.UPGRADING);
        HashSet<String> expectedInstances = new HashSet<String>();
        serviceStatus.getComponents().forEach(liveComp -> {
            liveComp.setState(ComponentState.NEEDS_UPGRADE);
            liveComp.getContainers().forEach(liveContainer -> {
                expectedInstances.add(liveContainer.getComponentInstanceName());
                liveContainer.setState(ContainerState.NEEDS_UPGRADE);
            });
        });
        this.mockServerClient.setExpectedInstances(expectedInstances);
        Response actual = this.apiServer.updateComponents(this.request, goodService.getName(), goodService.getComponents());
        Assertions.assertEquals((int)Response.status((Response.Status)Response.Status.ACCEPTED).build().getStatus(), (int)actual.getStatus(), (String)"Component upgrade is ");
    }
}

