/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.webproxy.ProxyCA;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestProxyCA {
    @Test
    void testInit() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assertions.assertNull((Object)proxyCA.getCaCert());
        Assertions.assertNull((Object)proxyCA.getCaKeyPair());
        Assertions.assertNull((Object)proxyCA.getX509KeyManager());
        Assertions.assertNull((Object)proxyCA.getHostnameVerifier());
        proxyCA.init();
        Assertions.assertNotNull((Object)proxyCA.getCaCert());
        Assertions.assertNotNull((Object)proxyCA.getCaKeyPair());
        Assertions.assertNotNull((Object)proxyCA.getX509KeyManager());
        Assertions.assertNotNull((Object)proxyCA.getHostnameVerifier());
    }

    @Test
    void testInit2Null() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assertions.assertNull((Object)proxyCA.getCaCert());
        Assertions.assertNull((Object)proxyCA.getCaKeyPair());
        Assertions.assertNull((Object)proxyCA.getX509KeyManager());
        Assertions.assertNull((Object)proxyCA.getHostnameVerifier());
        proxyCA.init(null, null);
        Assertions.assertNotNull((Object)proxyCA.getCaCert());
        Assertions.assertNotNull((Object)proxyCA.getCaKeyPair());
        Assertions.assertNotNull((Object)proxyCA.getX509KeyManager());
        Assertions.assertNotNull((Object)proxyCA.getHostnameVerifier());
    }

    @Test
    void testInit2Mismatch() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assertions.assertNull((Object)proxyCA.getCaCert());
        Assertions.assertNull((Object)proxyCA.getCaKeyPair());
        Assertions.assertNull((Object)proxyCA.getX509KeyManager());
        Assertions.assertNull((Object)proxyCA.getHostnameVerifier());
        CertKeyPair pair1 = this.createCertAndKeyPair();
        CertKeyPair pair2 = this.createCertAndKeyPair();
        Assertions.assertNotEquals((Object)pair1.getCert(), (Object)pair2.getCert());
        Assertions.assertNotEquals((Object)pair1.getKeyPair().getPrivate(), (Object)pair2.getKeyPair().getPrivate());
        Assertions.assertNotEquals((Object)pair1.getKeyPair().getPublic(), (Object)pair2.getKeyPair().getPublic());
        proxyCA.init(pair1.getCert(), pair2.getKeyPair().getPrivate());
        Assertions.assertNotNull((Object)proxyCA.getCaCert());
        Assertions.assertNotNull((Object)proxyCA.getCaKeyPair());
        Assertions.assertNotNull((Object)proxyCA.getX509KeyManager());
        Assertions.assertNotNull((Object)proxyCA.getHostnameVerifier());
        Assertions.assertNotEquals((Object)proxyCA.getCaCert(), (Object)pair1.getCert());
        Assertions.assertNotEquals((Object)proxyCA.getCaKeyPair().getPrivate(), (Object)pair2.getKeyPair().getPrivate());
        Assertions.assertNotEquals((Object)proxyCA.getCaKeyPair().getPublic(), (Object)pair2.getKeyPair().getPublic());
    }

    @Test
    void testInit2Invalid() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assertions.assertNull((Object)proxyCA.getCaCert());
        Assertions.assertNull((Object)proxyCA.getCaKeyPair());
        Assertions.assertNull((Object)proxyCA.getX509KeyManager());
        Assertions.assertNull((Object)proxyCA.getHostnameVerifier());
        X509Certificate certificate = (X509Certificate)Mockito.mock(X509Certificate.class);
        PrivateKey privateKey = (PrivateKey)Mockito.mock(PrivateKey.class);
        try {
            proxyCA.init(certificate, privateKey);
            Assertions.fail((String)"Expected InvalidKeyException");
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
    }

    @Test
    void testInit2() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        Assertions.assertNull((Object)proxyCA.getCaCert());
        Assertions.assertNull((Object)proxyCA.getCaKeyPair());
        Assertions.assertNull((Object)proxyCA.getX509KeyManager());
        Assertions.assertNull((Object)proxyCA.getHostnameVerifier());
        CertKeyPair pair = this.createCertAndKeyPair();
        proxyCA.init(pair.getCert(), pair.getKeyPair().getPrivate());
        Assertions.assertEquals((Object)pair.getCert(), (Object)proxyCA.getCaCert());
        Assertions.assertEquals((Object)pair.getKeyPair().getPrivate(), (Object)proxyCA.getCaKeyPair().getPrivate());
        Assertions.assertEquals((Object)pair.getKeyPair().getPublic(), (Object)proxyCA.getCaKeyPair().getPublic());
        Assertions.assertNotNull((Object)proxyCA.getX509KeyManager());
        Assertions.assertNotNull((Object)proxyCA.getHostnameVerifier());
    }

    @Test
    void testCreateChildKeyStore() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        byte[] keystoreBytes = proxyCA.createChildKeyStore(appId, "password");
        KeyStore keyStore = KeyStoreTestUtil.bytesToKeyStore((byte[])keystoreBytes, (String)"password");
        Assertions.assertEquals((int)1, (int)keyStore.size());
        Certificate[] certChain = keyStore.getCertificateChain("server");
        Assertions.assertEquals((int)2, (int)certChain.length);
        X509Certificate caCert = (X509Certificate)certChain[1];
        X509Certificate cert = (X509Certificate)certChain[0];
        Assertions.assertEquals((Object)caCert.getSubjectX500Principal().toString(), (Object)cert.getIssuerDN().toString());
        Assertions.assertEquals((Object)new X500Principal("CN=" + appId), (Object)cert.getSubjectX500Principal());
        Assertions.assertFalse((boolean)cert.getSubjectX500Principal().toString().contains(","), (String)("Found multiple fields in X500 Principal, when there should have only been one: " + cert.getSubjectX500Principal()));
        Assertions.assertEquals((Object)"SHA512withRSA", (Object)cert.getSigAlgName());
        Assertions.assertEquals((Object)cert.getNotBefore(), (Object)cert.getNotAfter());
        Assertions.assertTrue((boolean)cert.getNotAfter().before(new Date()), (String)("Expected certificate to be expired but was not: " + cert.getNotAfter()));
        Assertions.assertEquals((Object)new X500Principal("CN=" + appId).toString(), (Object)cert.getSubjectDN().toString());
        Key privateKey = keyStore.getKey("server", "password".toCharArray());
        Assertions.assertEquals((Object)"RSA", (Object)privateKey.getAlgorithm());
        Assertions.assertEquals((int)-1, (int)cert.getBasicConstraints());
        PublicKey caPublicKey = caCert.getPublicKey();
        cert.verify(caPublicKey);
        this.checkCACert(caCert);
        Assertions.assertEquals((Object)proxyCA.getCaCert(), (Object)caCert);
        caCert.verify(caPublicKey);
        PrivateKey caPrivateKey = proxyCA.getX509KeyManager().getPrivateKey(null);
        this.checkPrivatePublicKeys(caPrivateKey, caPublicKey);
        Assertions.assertEquals((Object)proxyCA.getCaKeyPair().getPublic(), (Object)caPublicKey);
        Assertions.assertEquals((Object)proxyCA.getCaKeyPair().getPrivate(), (Object)caPrivateKey);
    }

    @Test
    void testGetChildTrustStore() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        byte[] truststoreBytes = proxyCA.getChildTrustStore("password");
        KeyStore truststore = KeyStoreTestUtil.bytesToKeyStore((byte[])truststoreBytes, (String)"password");
        Assertions.assertEquals((int)1, (int)truststore.size());
        X509Certificate caCert = (X509Certificate)truststore.getCertificate("client");
        this.checkCACert(caCert);
        Assertions.assertEquals((Object)proxyCA.getCaCert(), (Object)caCert);
        PublicKey caPublicKey = caCert.getPublicKey();
        caCert.verify(caPublicKey);
        PrivateKey caPrivateKey = proxyCA.getX509KeyManager().getPrivateKey(null);
        this.checkPrivatePublicKeys(caPrivateKey, caPublicKey);
        Assertions.assertEquals((Object)proxyCA.getCaKeyPair().getPublic(), (Object)caPublicKey);
        Assertions.assertEquals((Object)proxyCA.getCaKeyPair().getPrivate(), (Object)caPrivateKey);
    }

    @Test
    void testGenerateKeyStorePassword() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HashSet<String> passwords = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            String password = proxyCA.generateKeyStorePassword();
            Assertions.assertEquals((int)16, (int)password.length());
            for (char c : password.toCharArray()) {
                Assertions.assertFalse((c < ' ' ? 1 : 0) != 0, (String)("Found character '" + c + "' in password '" + password + "' which is outside of the expected range"));
                Assertions.assertFalse((c > 'z' ? 1 : 0) != 0, (String)("Found character '" + c + "' in password '" + password + "' which is outside of the expected range"));
            }
            Assertions.assertFalse((boolean)passwords.contains(password), (String)("Password " + password + " was generated twice, which is _extremely_ unlikely and shouldn't practically happen: " + passwords));
            passwords.add(password);
        }
    }

    @Test
    void testCreateTrustManagerDefaultTrustManager() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        Mockito.when((Object)defaultTrustManager.getAcceptedIssuers()).thenReturn((Object)new X509Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")});
        Assertions.assertArrayEquals((Object[])defaultTrustManager.getAcceptedIssuers(), (Object[])trustManager.getAcceptedIssuers());
        trustManager.checkClientTrusted(null, null);
    }

    @Test
    void testCreateTrustManagerYarnCert() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        X509Certificate[] certChain = this.castCertificateArrayToX509CertificateArray(KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(appId, "password"), (String)"password").getCertificateChain("server"));
        trustManager.checkServerTrusted(certChain, "RSA");
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
    }

    @Test
    void testCreateTrustManagerWrongApp() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationId appId2 = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)2);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        X509Certificate[] certChain = this.castCertificateArrayToX509CertificateArray(KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(appId2, "password"), (String)"password").getCertificateChain("server"));
        try {
            trustManager.checkServerTrusted(certChain, "RSA");
            Assertions.fail((String)"Should have thrown a CertificateException, but did not");
        }
        catch (CertificateException ce) {
            Assertions.assertEquals((Object)("Expected to find Subject X500 Principal with CN=" + appId + " but found CN=" + appId2), (Object)ce.getMessage());
        }
    }

    @Test
    void testCreateTrustManagerWrongRM() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        ProxyCA proxyCA2 = new ProxyCA();
        proxyCA2.init();
        X509Certificate[] certChain = this.castCertificateArrayToX509CertificateArray(KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA2.createChildKeyStore(appId, "password"), (String)"password").getCertificateChain("server"));
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
        trustManager.checkServerTrusted(certChain, "RSA");
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certChain, "RSA");
    }

    @Test
    void testCreateTrustManagerRealCert() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        X509Certificate[] certChain = new X509Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")};
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
        trustManager.checkServerTrusted(certChain, "RSA");
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certChain, "RSA");
        certChain = new X509Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA"), KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")};
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
        trustManager.checkServerTrusted(certChain, "RSA");
        ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certChain, "RSA");
    }

    @Test
    void testCreateTrustManagerExceptions() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509TrustManager defaultTrustManager = (X509TrustManager)Mockito.mock(X509TrustManager.class);
        proxyCA.setDefaultTrustManager(defaultTrustManager);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        X509TrustManager trustManager = proxyCA.createTrustManager(appId);
        for (Exception e : new Exception[]{new CertificateException(), new NoSuchAlgorithmException(), new InvalidKeyException(), new SignatureException(), new NoSuchProviderException()}) {
            X509Certificate cert;
            X509Certificate[] certChain = this.castCertificateArrayToX509CertificateArray(KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(appId, "password"), (String)"password").getCertificateChain("server"));
            certChain[0] = cert = (X509Certificate)Mockito.spy((Object)certChain[0]);
            ((X509Certificate)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)certChain[0])).verify((PublicKey)Mockito.any());
            ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)0))).checkServerTrusted(certChain, "RSA");
            trustManager.checkServerTrusted(certChain, "RSA");
            ((X509TrustManager)Mockito.verify((Object)defaultTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certChain, "RSA");
        }
    }

    @Test
    void testCreateKeyManager() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        X509KeyManager keyManager = proxyCA.getX509KeyManager();
        Assertions.assertArrayEquals((Object[])new String[]{"client"}, (Object[])keyManager.getClientAliases(null, null));
        Assertions.assertEquals((Object)"client", (Object)keyManager.chooseClientAlias(null, null, null));
        Assertions.assertNull((Object)keyManager.getServerAliases(null, null));
        Assertions.assertNull((Object)keyManager.chooseServerAlias(null, null, null));
        byte[] truststoreBytes = proxyCA.getChildTrustStore("password");
        KeyStore truststore = KeyStoreTestUtil.bytesToKeyStore((byte[])truststoreBytes, (String)"password");
        Assertions.assertEquals((int)1, (int)truststore.size());
        X509Certificate caCert = (X509Certificate)truststore.getCertificate("client");
        Assertions.assertArrayEquals((Object[])new X509Certificate[]{caCert}, (Object[])keyManager.getCertificateChain(null));
        Assertions.assertEquals((Object)proxyCA.getCaCert(), (Object)caCert);
        PrivateKey caPrivateKey = keyManager.getPrivateKey(null);
        PublicKey caPublicKey = caCert.getPublicKey();
        this.checkPrivatePublicKeys(caPrivateKey, caPublicKey);
        Assertions.assertEquals((Object)proxyCA.getCaKeyPair().getPublic(), (Object)caPublicKey);
        Assertions.assertEquals((Object)proxyCA.getCaKeyPair().getPrivate(), (Object)caPrivateKey);
    }

    @Test
    void testCreateHostnameVerifier() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)sslSession.getPeerCertificates()).thenReturn((Object)KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), "password"), (String)"password").getCertificateChain("server"));
        Assertions.assertTrue((boolean)verifier.verify("foo", sslSession));
    }

    @Test
    void testCreateHostnameVerifierSSLPeerUnverifiedException() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)sslSession.getPeerCertificates()).thenThrow(new Throwable[]{new SSLPeerUnverifiedException("")});
        Assertions.assertFalse((boolean)verifier.verify("foo", sslSession));
    }

    @Test
    void testCreateHostnameVerifierWrongRM() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        ProxyCA proxyCA2 = new ProxyCA();
        proxyCA2.init();
        Mockito.when((Object)sslSession.getPeerCertificates()).thenReturn((Object)KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA2.createChildKeyStore(ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), "password"), (String)"password").getCertificateChain("server"));
        Assertions.assertFalse((boolean)verifier.verify("foo", sslSession));
    }

    @Test
    void testCreateHostnameVerifierExceptions() throws Exception {
        final ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        for (final Exception e : new Exception[]{new CertificateException(), new NoSuchAlgorithmException(), new InvalidKeyException(), new SignatureException(), new NoSuchProviderException()}) {
            SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
            Mockito.when((Object)sslSession.getPeerCertificates()).thenAnswer((Answer)new Answer<Certificate[]>(){

                public Certificate[] answer(InvocationOnMock invocation) throws Throwable {
                    Certificate cert;
                    Certificate[] certChain = KeyStoreTestUtil.bytesToKeyStore((byte[])proxyCA.createChildKeyStore(ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), "password"), (String)"password").getCertificateChain("server");
                    certChain[0] = cert = (Certificate)Mockito.spy((Object)certChain[0]);
                    ((Certificate)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)cert)).verify((PublicKey)Mockito.any());
                    return certChain;
                }
            });
            Assertions.assertFalse((boolean)verifier.verify("foo", sslSession));
        }
    }

    @Test
    void testCreateHostnameVerifierRealCert() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)sslSession.getPeerCertificates()).thenAnswer((Answer)new Answer<Certificate[]>(){

            public Certificate[] answer(InvocationOnMock invocation) throws Throwable {
                Certificate[] certChain = new Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")};
                return certChain;
            }
        });
        Assertions.assertTrue((boolean)verifier.verify("foo.com", sslSession));
    }

    @Test
    void testCreateHostnameVerifierRealCertBad() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        HostnameVerifier verifier = proxyCA.getHostnameVerifier();
        SSLSession sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        Mockito.when((Object)sslSession.getPeerCertificates()).thenAnswer((Answer)new Answer<Certificate[]>(){

            public Certificate[] answer(InvocationOnMock invocation) throws Throwable {
                Certificate[] certChain = new Certificate[]{KeyStoreTestUtil.generateCertificate((String)"CN=foo.com", (KeyPair)KeyStoreTestUtil.generateKeyPair((String)"RSA"), (int)30, (String)"SHA256WithRSA")};
                return certChain;
            }
        });
        Assertions.assertFalse((boolean)verifier.verify("bar.com", sslSession));
    }

    private void checkCACert(X509Certificate caCert) {
        Assertions.assertEquals((Object)caCert.getSubjectX500Principal().toString(), (Object)caCert.getIssuerDN().toString());
        Assertions.assertEquals((Object)caCert.getSubjectX500Principal().toString(), (Object)caCert.getSubjectDN().toString());
        Assertions.assertTrue((boolean)caCert.getSubjectX500Principal().toString().startsWith("OU=YARN-"), (String)("Expected CA certificate X500 Principal to start with 'OU=YARN-', but did not: " + caCert.getSubjectX500Principal()));
        Assertions.assertFalse((boolean)caCert.getSubjectX500Principal().toString().contains(","), (String)("Found multiple fields in X500 Principal, when there should have only been one: " + caCert.getSubjectX500Principal()));
        Assertions.assertEquals((Object)"SHA512withRSA", (Object)caCert.getSigAlgName());
        Assertions.assertEquals((Object)new GregorianCalendar(2037, 11, 31).getTime(), (Object)caCert.getNotAfter());
        Assertions.assertTrue((boolean)caCert.getNotBefore().before(new Date()), (String)("Expected certificate to have started but was not: " + caCert.getNotBefore()));
        Assertions.assertEquals((int)0, (int)caCert.getBasicConstraints());
    }

    private void checkPrivatePublicKeys(PrivateKey privateKey, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] data = new byte[2000];
        new Random().nextBytes(data);
        Signature signer = Signature.getInstance("SHA512withRSA");
        signer.initSign(privateKey);
        signer.update(data);
        byte[] sig = signer.sign();
        signer = Signature.getInstance("SHA512withRSA");
        signer.initVerify(publicKey);
        signer.update(data);
        Assertions.assertTrue((boolean)signer.verify(sig));
    }

    private X509Certificate[] castCertificateArrayToX509CertificateArray(Certificate[] certs) {
        return (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
    }

    private CertKeyPair createCertAndKeyPair() throws Exception {
        ProxyCA proxyCA = new ProxyCA();
        proxyCA.init();
        return new CertKeyPair(proxyCA.getCaCert(), proxyCA.getCaKeyPair());
    }

    private static class CertKeyPair {
        private X509Certificate cert;
        private KeyPair keyPair;

        public CertKeyPair(X509Certificate cert, KeyPair keyPair) {
            this.cert = cert;
            this.keyPair = keyPair;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }
    }
}

