/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollectorWithAgg;
import org.apache.hadoop.yarn.server.timelineservice.collector.NodeTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestNMTimelineCollectorManager {
    private NodeTimelineCollectorManager collectorManager;

    @BeforeEach
    public void setup() throws Exception {
        this.collectorManager = this.createCollectorManager();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        conf.set("yarn.timeline-service.collector.bind-port-ranges", "30000-30100");
        this.collectorManager.init((Configuration)conf);
        this.collectorManager.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.collectorManager != null) {
            this.collectorManager.stop();
        }
    }

    @Test
    void testStartingWriterFlusher() throws Exception {
        Assertions.assertTrue((boolean)this.collectorManager.writerFlusherRunning());
    }

    @Test
    void testStartWebApp() throws Exception {
        Assertions.assertNotNull((Object)this.collectorManager.getRestServerBindAddress());
        String address = this.collectorManager.getRestServerBindAddress();
        String[] parts = address.split(":");
        Assertions.assertEquals((int)2, (int)parts.length);
        Assertions.assertNotNull((Object)parts[0]);
        Assertions.assertTrue((Integer.valueOf(parts[1]) >= 30000 && Integer.valueOf(parts[1]) <= 30100 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60000L)
    void testMultithreadedAdd() throws Exception {
        int numApps = 5;
        ArrayList<Object> tasks = new ArrayList<Object>();
        for (int i = 0; i < 5; ++i) {
            final ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AppLevelTimelineCollectorWithAgg collector = new AppLevelTimelineCollectorWithAgg(appId, "user");
                    return TestNMTimelineCollectorManager.this.collectorManager.putIfAbsent(appId, (TimelineCollector)collector) == collector;
                }
            };
            tasks.add(task);
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            List futures = executor.invokeAll(tasks);
            for (Future future : futures) {
                Assertions.assertTrue((boolean)((Boolean)future.get()));
            }
        }
        finally {
            executor.shutdownNow();
        }
        for (int i = 0; i < 5; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            Assertions.assertTrue((boolean)this.collectorManager.containsTimelineCollector(appId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testMultithreadedAddAndRemove() throws Exception {
        int numApps = 5;
        ArrayList<Object> tasks = new ArrayList<Object>();
        for (int i = 0; i < 5; ++i) {
            final ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AppLevelTimelineCollectorWithAgg collector = new AppLevelTimelineCollectorWithAgg(appId, "user");
                    boolean successPut = TestNMTimelineCollectorManager.this.collectorManager.putIfAbsent(appId, (TimelineCollector)collector) == collector;
                    return successPut && TestNMTimelineCollectorManager.this.collectorManager.remove(appId);
                }
            };
            tasks.add(task);
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            List futures = executor.invokeAll(tasks);
            for (Future future : futures) {
                Assertions.assertTrue((boolean)((Boolean)future.get()));
            }
        }
        finally {
            executor.shutdownNow();
        }
        for (int i = 0; i < 5; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            Assertions.assertFalse((boolean)this.collectorManager.containsTimelineCollector(appId));
        }
    }

    private NodeTimelineCollectorManager createCollectorManager() {
        NodeTimelineCollectorManager cm = (NodeTimelineCollectorManager)Mockito.spy((Object)new NodeTimelineCollectorManager());
        CollectorNodemanagerProtocol nmCollectorService = (CollectorNodemanagerProtocol)Mockito.mock(CollectorNodemanagerProtocol.class);
        GetTimelineCollectorContextResponse response = GetTimelineCollectorContextResponse.newInstance(null, null, null, (long)0L);
        try {
            Mockito.when((Object)nmCollectorService.getTimelineCollectorContext((GetTimelineCollectorContextRequest)ArgumentMatchers.any(GetTimelineCollectorContextRequest.class))).thenReturn((Object)response);
        }
        catch (IOException | YarnException e) {
            Assertions.fail();
        }
        ((NodeTimelineCollectorManager)Mockito.doReturn((Object)nmCollectorService).when((Object)cm)).getNMCollectorService();
        return cm;
    }
}

