/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.LinkedHashSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilterInitializer;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStatusServlet;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderManager;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderWebServices;
import org.apache.hadoop.yarn.server.timelineservice.reader.security.TimelineReaderAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.server.timelineservice.reader.security.TimelineReaderWhitelistAuthorizationFilterInitializer;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.util.timeline.TimelineServerUtils;
import org.apache.hadoop.yarn.server.webapp.LogWebService;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineReaderServer
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineReaderServer.class);
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    static final String TIMELINE_READER_MANAGER_ATTR = "timeline.reader.manager";
    private HttpServer2 readerWebServer;
    private TimelineReaderManager timelineReaderManager;
    private String webAppURLWithoutScheme;
    private HttpServer2 statusServer;

    public TimelineReaderServer() {
        super(TimelineReaderServer.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (!YarnConfiguration.timelineServiceV2Enabled((Configuration)conf)) {
            throw new YarnException("timeline service v.2 is not enabled");
        }
        this.webAppURLWithoutScheme = WebAppUtils.getTimelineReaderWebAppURLWithoutScheme((Configuration)conf);
        InetSocketAddress bindAddr = NetUtils.createSocketAddr((String)this.webAppURLWithoutScheme);
        try {
            SecurityUtil.login((Configuration)conf, (String)"yarn.timeline-service.keytab", (String)"yarn.timeline-service.principal", (String)bindAddr.getHostName());
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to login from keytab", (Throwable)e);
        }
        TimelineReader timelineReaderStore = this.createTimelineReaderStore(conf);
        timelineReaderStore.init(conf);
        this.addService(timelineReaderStore);
        this.timelineReaderManager = this.createTimelineReaderManager(timelineReaderStore);
        this.addService((Service)this.timelineReaderManager);
        super.serviceInit(conf);
    }

    private TimelineReader createTimelineReaderStore(Configuration conf) {
        String timelineReaderClassName = conf.get("yarn.timeline-service.reader.class", "org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl");
        LOG.info("Using store: " + timelineReaderClassName);
        try {
            Class<?> timelineReaderClazz = Class.forName(timelineReaderClassName);
            if (TimelineReader.class.isAssignableFrom(timelineReaderClazz)) {
                return (TimelineReader)ReflectionUtils.newInstance(timelineReaderClazz, (Configuration)conf);
            }
            throw new YarnRuntimeException("Class: " + timelineReaderClassName + " not instance of " + TimelineReader.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate TimelineReader: " + timelineReaderClassName, (Throwable)e);
        }
    }

    private TimelineReaderManager createTimelineReaderManager(TimelineReader timelineReaderStore) {
        return new TimelineReaderManager(timelineReaderStore);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.startTimelineReaderWebApp();
        this.startStatusServer(new Configuration());
    }

    private void join() {
        if (this.readerWebServer != null) {
            try {
                this.readerWebServer.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void serviceStop() throws Exception {
        if (this.readerWebServer != null) {
            this.readerWebServer.stop();
        }
        if (this.statusServer != null) {
            this.statusServer.stop();
        }
        super.serviceStop();
    }

    protected void addFilters(Configuration conf) {
        boolean enableCorsFilter = conf.getBoolean("yarn.timeline-service.http-cross-origin.enabled", false);
        if (enableCorsFilter) {
            conf.setBoolean("hadoop.http.cross-origin.enabled", true);
        }
        String initializers = conf.get("hadoop.http.filter.initializers", "");
        LinkedHashSet<String> defaultInitializers = new LinkedHashSet<String>();
        if (!initializers.contains(ProxyUserAuthenticationFilterInitializer.class.getName())) {
            if (!initializers.contains(TimelineReaderAuthenticationFilterInitializer.class.getName())) {
                defaultInitializers.add(TimelineReaderAuthenticationFilterInitializer.class.getName());
            }
        } else {
            defaultInitializers.add(ProxyUserAuthenticationFilterInitializer.class.getName());
        }
        defaultInitializers.add(TimelineReaderWhitelistAuthorizationFilterInitializer.class.getName());
        TimelineServerUtils.setTimelineFilters((Configuration)conf, (String)initializers, defaultInitializers);
    }

    private void startTimelineReaderWebApp() {
        Configuration conf = this.getConfig();
        this.addFilters(conf);
        String hostProperty = "yarn.timeline-service.reader.bind-host";
        String host = conf.getTrimmed(hostProperty);
        if (host == null || host.isEmpty()) {
            hostProperty = "yarn.timeline-service.bind-host";
        }
        String bindAddress = WebAppUtils.getWebAppBindURL((Configuration)conf, (String)hostProperty, (String)this.webAppURLWithoutScheme);
        LOG.info("Instantiating TimelineReaderWebApp at " + bindAddress);
        try {
            String httpScheme = WebAppUtils.getHttpSchemePrefix((Configuration)conf);
            HttpServer2.Builder builder = new HttpServer2.Builder().setName("timeline").setConf(conf).addEndpoint(URI.create(httpScheme + bindAddress));
            if (httpScheme.equals("https://")) {
                WebAppUtils.loadSslConfiguration((HttpServer2.Builder)builder, (Configuration)conf);
            }
            this.readerWebServer = builder.build();
            this.readerWebServer.addJerseyResourcePackage(TimelineReaderWebServices.class.getPackage().getName() + ";" + GenericExceptionHandler.class.getPackage().getName() + ";" + YarnJacksonJaxbJsonProvider.class.getPackage().getName() + ";" + LogWebService.class.getPackage().getName(), "/*");
            this.readerWebServer.setAttribute(TIMELINE_READER_MANAGER_ATTR, (Object)this.timelineReaderManager);
            this.readerWebServer.start();
        }
        catch (Exception e) {
            String msg = "TimelineReaderWebApp failed to start.";
            LOG.error(msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
    }

    protected void startStatusServer(Configuration conf) throws Exception {
        if (this.getConfig().getBoolean("yarn.timeline-service.status.server.enabled", YarnConfiguration.DEFAULT_TIMELINE_SERVICE_STATUS_SERVER_ENABLED)) {
            String httpScheme = "http://";
            String bindAddress = conf.get("yarn.timeline-service.status.server.address", "localhost:18190");
            HttpServer2.Builder builder = new HttpServer2.Builder();
            this.statusServer = builder.setName("applicationhistory-status").setConf(conf).addEndpoint(URI.create(httpScheme + bindAddress)).build();
            this.statusServer.addServlet("service_status", "/status", ApplicationHistoryStatusServlet.class);
            this.statusServer.start();
        }
    }

    @VisibleForTesting
    public int getWebServerPort() {
        return this.readerWebServer.getConnectorAddress(0).getPort();
    }

    static TimelineReaderServer startTimelineReaderServer(String[] args, Configuration conf) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(TimelineReaderServer.class, (String[])args, (Logger)LOG);
        TimelineReaderServer timelineReaderServer = null;
        try {
            timelineReaderServer = new TimelineReaderServer();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)timelineReaderServer), 30);
            timelineReaderServer.init(conf);
            timelineReaderServer.start();
        }
        catch (Throwable t) {
            LOG.error("Error starting TimelineReaderWebServer", t);
            ExitUtil.terminate((int)-1, (String)"Error starting TimelineReaderWebServer");
        }
        return timelineReaderServer;
    }

    public static void main(String[] args) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.versions", 2.0f);
        TimelineReaderServer server = TimelineReaderServer.startTimelineReaderServer(args, (Configuration)conf);
        server.join();
    }
}

