/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineServerUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.NumericValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimestampGenerator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationCompactionDimension;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowScannerOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlowScanner
implements RegionScanner,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FlowScanner.class);
    private static final String FLOW_APP_ID = "application_00000000000_0000";
    private final Region region;
    private final InternalScanner flowRunScanner;
    private final int batchSize;
    private final long appFinalValueRetentionThreshold;
    private RegionScanner regionScanner;
    private boolean hasMore;
    private byte[] currentRow;
    private List<Cell> availableCells = new ArrayList<Cell>();
    private int currentIndex;
    private FlowScannerOperation action = FlowScannerOperation.READ;

    FlowScanner(RegionCoprocessorEnvironment env, InternalScanner internalScanner, FlowScannerOperation action) {
        this(env, null, internalScanner, action);
    }

    FlowScanner(RegionCoprocessorEnvironment env, Scan incomingScan, InternalScanner internalScanner, FlowScannerOperation action) {
        this.batchSize = incomingScan == null ? -1 : incomingScan.getBatch();
        this.flowRunScanner = internalScanner;
        if (internalScanner instanceof RegionScanner) {
            this.regionScanner = (RegionScanner)internalScanner;
        }
        this.action = action;
        if (env == null) {
            this.appFinalValueRetentionThreshold = 259200000L;
            this.region = null;
        } else {
            this.region = env.getRegion();
            Configuration hbaseConf = env.getConfiguration();
            this.appFinalValueRetentionThreshold = hbaseConf.getLong("yarn.timeline-service.hbase.coprocessor.app-final-value-retention-milliseconds", 259200000L);
        }
        LOG.debug(" batch size={}", (Object)this.batchSize);
    }

    public HRegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    public boolean nextRaw(List<Cell> cells) throws IOException {
        return this.nextRaw(cells, ScannerContext.newBuilder().build());
    }

    public boolean nextRaw(List<Cell> cells, ScannerContext scannerContext) throws IOException {
        return this.nextInternal(cells, scannerContext);
    }

    public boolean next(List<Cell> cells) throws IOException {
        return this.next(cells, ScannerContext.newBuilder().build());
    }

    public boolean next(List<Cell> cells, ScannerContext scannerContext) throws IOException {
        return this.nextInternal(cells, scannerContext);
    }

    private static ValueConverter getValueConverter(byte[] colQualifierBytes) {
        for (FlowRunColumnPrefix flowRunColumnPrefix : FlowRunColumnPrefix.values()) {
            byte[] colPrefixBytes = flowRunColumnPrefix.getColumnPrefixBytes("");
            if (Bytes.compareTo((byte[])colPrefixBytes, (int)0, (int)colPrefixBytes.length, (byte[])colQualifierBytes, (int)0, (int)colPrefixBytes.length) != 0) continue;
            return flowRunColumnPrefix.getValueConverter();
        }
        for (Enum enum_ : FlowRunColumn.values()) {
            if (Bytes.compareTo((byte[])((FlowRunColumn)enum_).getColumnQualifierBytes(), (byte[])colQualifierBytes) != 0) continue;
            return ((FlowRunColumn)enum_).getValueConverter();
        }
        return GenericConverter.getInstance();
    }

    private boolean nextInternal(List<Cell> cells, ScannerContext scannerContext) throws IOException {
        Cell cell = null;
        this.startNext();
        Bytes.ByteArrayComparator comp = new Bytes.ByteArrayComparator();
        byte[] previousColumnQualifier = Separator.EMPTY_BYTES;
        AggregationOperation currentAggOp = null;
        TreeSet<Cell> currentColumnCells = new TreeSet<Cell>((Comparator<Cell>)KeyValue.COMPARATOR);
        HashSet<String> alreadySeenAggDim = new HashSet<String>();
        int addedCnt = 0;
        long currentTimestamp = System.currentTimeMillis();
        ValueConverter converter = null;
        int limit = this.batchSize;
        while ((limit <= 0 || addedCnt < limit) && (cell = this.peekAtNextCell(scannerContext)) != null) {
            byte[] currentColumnQualifier = CellUtil.cloneQualifier((Cell)cell);
            if (previousColumnQualifier == null) {
                previousColumnQualifier = currentColumnQualifier;
            }
            converter = FlowScanner.getValueConverter(currentColumnQualifier);
            if (comp.compare(previousColumnQualifier, currentColumnQualifier) != 0) {
                addedCnt += this.emitCells(cells, currentColumnCells, currentAggOp, converter, currentTimestamp);
                this.resetState(currentColumnCells, alreadySeenAggDim);
                previousColumnQualifier = currentColumnQualifier;
                currentAggOp = this.getCurrentAggOp(cell);
                converter = FlowScanner.getValueConverter(currentColumnQualifier);
            }
            this.collectCells(currentColumnCells, currentAggOp, cell, alreadySeenAggDim, converter, scannerContext);
            this.nextCell(scannerContext);
        }
        if (!(currentColumnCells.isEmpty() || limit > 0 && addedCnt >= limit)) {
            addedCnt += this.emitCells(cells, currentColumnCells, currentAggOp, converter, currentTimestamp);
            if (LOG.isDebugEnabled()) {
                if (addedCnt > 0) {
                    LOG.debug("emitted cells. " + addedCnt + " for " + (Object)((Object)this.action) + " rowKey=" + FlowRunRowKey.parseRowKey(CellUtil.cloneRow((Cell)cells.get(0))));
                } else {
                    LOG.debug("emitted no cells for " + (Object)((Object)this.action));
                }
            }
        }
        return this.hasMore();
    }

    private AggregationOperation getCurrentAggOp(Cell cell) {
        List<Tag> tags = HBaseTimelineServerUtils.convertCellAsTagList(cell);
        return HBaseTimelineServerUtils.getAggregationOperationFromTagsList(tags);
    }

    private void resetState(SortedSet<Cell> currentColumnCells, Set<String> alreadySeenAggDim) {
        currentColumnCells.clear();
        alreadySeenAggDim.clear();
    }

    private void collectCells(SortedSet<Cell> currentColumnCells, AggregationOperation currentAggOp, Cell cell, Set<String> alreadySeenAggDim, ValueConverter converter, ScannerContext scannerContext) throws IOException {
        if (currentAggOp == null) {
            currentColumnCells.add(cell);
            return;
        }
        switch (currentAggOp) {
            case GLOBAL_MIN: {
                Cell newMinCell;
                if (currentColumnCells.size() == 0) {
                    currentColumnCells.add(cell);
                    break;
                }
                Cell currentMinCell = currentColumnCells.first();
                if (currentMinCell.equals(newMinCell = this.compareCellValues(currentMinCell, cell, currentAggOp, (NumericValueConverter)converter))) break;
                currentColumnCells.remove(currentMinCell);
                currentColumnCells.add(newMinCell);
                break;
            }
            case GLOBAL_MAX: {
                Cell newMaxCell;
                if (currentColumnCells.size() == 0) {
                    currentColumnCells.add(cell);
                    break;
                }
                Cell currentMaxCell = currentColumnCells.first();
                if (currentMaxCell.equals(newMaxCell = this.compareCellValues(currentMaxCell, cell, currentAggOp, (NumericValueConverter)converter))) break;
                currentColumnCells.remove(currentMaxCell);
                currentColumnCells.add(newMaxCell);
                break;
            }
            case SUM: 
            case SUM_FINAL: {
                List<Tag> tags;
                String aggDim;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("In collect cells  FlowSannerOperation=" + (Object)((Object)this.action) + " currentAggOp=" + (Object)((Object)currentAggOp) + " cell qualifier=" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell)) + " cell value= " + converter.decodeValue(CellUtil.cloneValue((Cell)cell)) + " timestamp=" + cell.getTimestamp());
                }
                if (alreadySeenAggDim.contains(aggDim = HBaseTimelineServerUtils.getAggregationCompactionDimension(tags = HBaseTimelineServerUtils.convertCellAsTagList(cell)))) break;
                currentColumnCells.add(cell);
                alreadySeenAggDim.add(aggDim);
                break;
            }
        }
    }

    private int emitCells(List<Cell> cells, SortedSet<Cell> currentColumnCells, AggregationOperation currentAggOp, ValueConverter converter, long currentTimestamp) throws IOException {
        if (currentColumnCells == null || currentColumnCells.size() == 0) {
            return 0;
        }
        if (currentAggOp == null) {
            cells.addAll(currentColumnCells);
            return currentColumnCells.size();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("In emitCells " + (Object)((Object)this.action) + " currentColumnCells size= " + currentColumnCells.size() + " currentAggOp" + (Object)((Object)currentAggOp));
        }
        switch (currentAggOp) {
            case GLOBAL_MIN: 
            case GLOBAL_MAX: {
                cells.addAll(currentColumnCells);
                return currentColumnCells.size();
            }
            case SUM: 
            case SUM_FINAL: {
                switch (this.action) {
                    case FLUSH: 
                    case MINOR_COMPACTION: {
                        cells.addAll(currentColumnCells);
                        return currentColumnCells.size();
                    }
                    case READ: {
                        Cell sumCell = this.processSummation(currentColumnCells, (NumericValueConverter)converter);
                        cells.add(sumCell);
                        return 1;
                    }
                    case MAJOR_COMPACTION: {
                        List<Cell> finalCells = this.processSummationMajorCompaction(currentColumnCells, (NumericValueConverter)converter, currentTimestamp);
                        cells.addAll(finalCells);
                        return finalCells.size();
                    }
                }
                cells.addAll(currentColumnCells);
                return currentColumnCells.size();
            }
        }
        cells.addAll(currentColumnCells);
        return currentColumnCells.size();
    }

    private Cell processSummation(SortedSet<Cell> currentColumnCells, NumericValueConverter converter) throws IOException {
        Number sum = 0;
        Number currentValue = 0;
        long ts = 0L;
        long mostCurrentTimestamp = 0L;
        Cell mostRecentCell = null;
        for (Cell cell : currentColumnCells) {
            currentValue = (Number)converter.decodeValue(CellUtil.cloneValue((Cell)cell));
            ts = cell.getTimestamp();
            if (mostCurrentTimestamp < ts) {
                mostCurrentTimestamp = ts;
                mostRecentCell = cell;
            }
            sum = converter.add(sum, currentValue, new Number[0]);
        }
        byte[] sumBytes = converter.encodeValue(sum);
        Cell sumCell = HBaseTimelineServerUtils.createNewCell(mostRecentCell, sumBytes);
        return sumCell;
    }

    @VisibleForTesting
    List<Cell> processSummationMajorCompaction(SortedSet<Cell> currentColumnCells, NumericValueConverter converter, long currentTimestamp) throws IOException {
        Number sum = 0;
        Number currentValue = 0;
        long ts = 0L;
        boolean summationDone = false;
        ArrayList<Cell> finalCells = new ArrayList<Cell>();
        if (currentColumnCells == null) {
            return finalCells;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("In processSummationMajorCompaction, will drop cells older than " + currentTimestamp + " CurrentColumnCells size=" + currentColumnCells.size());
        }
        for (Cell cell : currentColumnCells) {
            AggregationOperation cellAggOp = this.getCurrentAggOp(cell);
            List<Tag> tags = HBaseTimelineServerUtils.convertCellAsTagList(cell);
            String appId = HBaseTimelineServerUtils.getAggregationCompactionDimension(tags);
            if (appId == FLOW_APP_ID) {
                sum = converter.add(sum, currentValue, new Number[0]);
                summationDone = true;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("reading flow app id sum=" + sum);
                continue;
            }
            currentValue = (Number)converter.decodeValue(CellUtil.cloneValue((Cell)cell));
            ts = TimestampGenerator.getTruncatedTimestamp(cell.getTimestamp());
            if (cellAggOp == AggregationOperation.SUM_FINAL && ts + this.appFinalValueRetentionThreshold < currentTimestamp) {
                sum = converter.add(sum, currentValue, new Number[0]);
                summationDone = true;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("MAJOR COMPACTION loop sum= " + sum + " discarding now:  qualifier=" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell)) + " value=" + converter.decodeValue(CellUtil.cloneValue((Cell)cell)) + " timestamp=" + cell.getTimestamp() + " " + (Object)((Object)this.action));
                continue;
            }
            finalCells.add(cell);
        }
        if (summationDone) {
            Cell anyCell = currentColumnCells.first();
            ArrayList<Tag> tags = new ArrayList<Tag>();
            Tag t = HBaseTimelineServerUtils.createTag(AggregationOperation.SUM_FINAL.getTagType(), Bytes.toBytes((String)FLOW_APP_ID));
            tags.add(t);
            t = HBaseTimelineServerUtils.createTag(AggregationCompactionDimension.APPLICATION_ID.getTagType(), Bytes.toBytes((String)FLOW_APP_ID));
            tags.add(t);
            byte[] tagByteArray = HBaseTimelineServerUtils.convertTagListToByteArray(tags);
            Cell sumCell = HBaseTimelineServerUtils.createNewCell(CellUtil.cloneRow((Cell)anyCell), CellUtil.cloneFamily((Cell)anyCell), CellUtil.cloneQualifier((Cell)anyCell), TimestampGenerator.getSupplementedTimestamp(System.currentTimeMillis(), FLOW_APP_ID), converter.encodeValue(sum), tagByteArray);
            finalCells.add(sumCell);
            if (LOG.isTraceEnabled()) {
                LOG.trace("MAJOR COMPACTION final sum= " + sum + " for " + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)sumCell)) + " " + (Object)((Object)this.action));
            }
            LOG.info("After major compaction for qualifier=" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)sumCell)) + " with currentColumnCells.size=" + currentColumnCells.size() + " returning finalCells.size=" + finalCells.size() + " with sum=" + sum.longValue() + " with cell timestamp " + sumCell.getTimestamp());
        } else {
            String qualifier = "";
            LOG.info("After major compaction for qualifier=" + qualifier + " with currentColumnCells.size=" + currentColumnCells.size() + " returning finalCells.size=" + finalCells.size() + " with zero sum=" + sum.longValue());
        }
        return finalCells;
    }

    private Cell compareCellValues(Cell previouslyChosenCell, Cell currentCell, AggregationOperation currentAggOp, NumericValueConverter converter) throws IOException {
        if (previouslyChosenCell == null) {
            return currentCell;
        }
        try {
            Number previouslyChosenCellValue = (Number)converter.decodeValue(CellUtil.cloneValue((Cell)previouslyChosenCell));
            Number currentCellValue = (Number)converter.decodeValue(CellUtil.cloneValue((Cell)currentCell));
            switch (currentAggOp) {
                case GLOBAL_MIN: {
                    if (converter.compare(currentCellValue, previouslyChosenCellValue) < 0) {
                        return currentCell;
                    }
                    return previouslyChosenCell;
                }
                case GLOBAL_MAX: {
                    if (converter.compare(currentCellValue, previouslyChosenCellValue) > 0) {
                        return currentCell;
                    }
                    return previouslyChosenCell;
                }
            }
            return currentCell;
        }
        catch (IllegalArgumentException iae) {
            LOG.error("caught iae during conversion to long ", (Throwable)iae);
            return currentCell;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.flowRunScanner != null) {
            this.flowRunScanner.close();
        } else {
            LOG.warn("scanner close called but scanner is null");
        }
    }

    public void startNext() {
        this.currentRow = null;
    }

    public boolean hasMore() {
        return this.currentIndex < this.availableCells.size() ? true : this.hasMore;
    }

    public Cell nextCell(ScannerContext scannerContext) throws IOException {
        Cell cell = this.peekAtNextCell(scannerContext);
        if (cell != null) {
            ++this.currentIndex;
        }
        return cell;
    }

    public Cell peekAtNextCell(ScannerContext scannerContext) throws IOException {
        if (this.currentIndex >= this.availableCells.size()) {
            this.availableCells.clear();
            this.currentIndex = 0;
            this.hasMore = this.flowRunScanner.next(this.availableCells, scannerContext);
        }
        Cell cell = null;
        if (this.currentIndex < this.availableCells.size()) {
            cell = this.availableCells.get(this.currentIndex);
            if (this.currentRow == null) {
                this.currentRow = CellUtil.cloneRow((Cell)cell);
            } else if (!CellUtil.matchingRow((Cell)cell, (byte[])this.currentRow)) {
                return null;
            }
        }
        return cell;
    }

    public long getMaxResultSize() {
        if (this.regionScanner == null) {
            throw new IllegalStateException("RegionScanner.isFilterDone() called when the flow scanner's scanner is not a RegionScanner");
        }
        return this.regionScanner.getMaxResultSize();
    }

    public long getMvccReadPoint() {
        if (this.regionScanner == null) {
            throw new IllegalStateException("RegionScanner.isFilterDone() called when the flow scanner's internal scanner is not a RegionScanner");
        }
        return this.regionScanner.getMvccReadPoint();
    }

    public boolean isFilterDone() throws IOException {
        if (this.regionScanner == null) {
            throw new IllegalStateException("RegionScanner.isFilterDone() called when the flow scanner's internal scanner is not a RegionScanner");
        }
        return this.regionScanner.isFilterDone();
    }

    public boolean reseek(byte[] bytes) throws IOException {
        if (this.regionScanner == null) {
            throw new IllegalStateException("RegionScanner.reseek() called when the flow scanner's internal scanner is not a RegionScanner");
        }
        return this.regionScanner.reseek(bytes);
    }

    public int getBatch() {
        return this.batchSize;
    }
}

