/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.subapplication;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationTable;

public enum SubApplicationColumnPrefix implements ColumnPrefix<SubApplicationTable>
{
    IS_RELATED_TO(SubApplicationColumnFamily.INFO, "s"),
    RELATES_TO(SubApplicationColumnFamily.INFO, "r"),
    INFO(SubApplicationColumnFamily.INFO, "i"),
    EVENT((ColumnFamily<SubApplicationTable>)SubApplicationColumnFamily.INFO, "e", true),
    CONFIG(SubApplicationColumnFamily.CONFIGS, null),
    METRIC((ColumnFamily<SubApplicationTable>)SubApplicationColumnFamily.METRICS, null, new LongConverter());

    private final ColumnFamily<SubApplicationTable> columnFamily;
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;
    private final ValueConverter valueConverter;

    private SubApplicationColumnPrefix(ColumnFamily<SubApplicationTable> columnFamily, String columnPrefix) {
        this(columnFamily, columnPrefix, false, GenericConverter.getInstance());
    }

    private SubApplicationColumnPrefix(ColumnFamily<SubApplicationTable> columnFamily, String columnPrefix, boolean compondColQual) {
        this(columnFamily, columnPrefix, compondColQual, GenericConverter.getInstance());
    }

    private SubApplicationColumnPrefix(ColumnFamily<SubApplicationTable> columnFamily, String columnPrefix, ValueConverter converter) {
        this(columnFamily, columnPrefix, false, converter);
    }

    private SubApplicationColumnPrefix(ColumnFamily<SubApplicationTable> columnFamily, String columnPrefix, boolean compondColQual, ValueConverter converter) {
        this.valueConverter = converter;
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    @Override
    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnPrefixInBytes() {
        return this.columnPrefixBytes != null ? (byte[])this.columnPrefixBytes.clone() : null;
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public Attribute[] getCombinedAttrsWithAggr(Attribute ... attributes) {
        return attributes;
    }

    @Override
    public boolean supplementCellTimeStamp() {
        return false;
    }
}

