/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.domain;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineHBaseSchemaConstants;
import org.apache.hadoop.yarn.server.timelineservice.storage.domain.DomainColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.domain.DomainTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainTableRW
extends BaseTableRW<DomainTable> {
    private static final String PREFIX = "yarn.timeline-service.domain";
    public static final String TABLE_NAME_CONF_NAME = "yarn.timeline-service.domain.table.name";
    public static final String DEFAULT_TABLE_NAME = "timelineservice.domain";
    private static final Logger LOG = LoggerFactory.getLogger(DomainTableRW.class);

    public DomainTableRW() {
        super(TABLE_NAME_CONF_NAME, DEFAULT_TABLE_NAME);
    }

    @Override
    public void createTable(Admin admin, Configuration hbaseConf) throws IOException {
        TableName table = this.getTableName(hbaseConf);
        if (admin.tableExists(table)) {
            throw new IOException("Table " + table.getNameAsString() + " already exists.");
        }
        HTableDescriptor domainTableDescp = new HTableDescriptor(table);
        HColumnDescriptor mappCF = new HColumnDescriptor(DomainColumnFamily.INFO.getBytes());
        mappCF.setBloomFilterType(BloomType.ROWCOL);
        domainTableDescp.addFamily(mappCF);
        domainTableDescp.setRegionSplitPolicyClassName("org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitPolicy");
        domainTableDescp.setValue("KeyPrefixRegionSplitPolicy.prefix_length", "4");
        admin.createTable(domainTableDescp, TimelineHBaseSchemaConstants.getUsernameSplits());
        LOG.info("Status of table creation for " + table.getNameAsString() + "=" + admin.tableExists(table));
    }
}

