/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHBaseTimelineStorageUtils {
    private String hbaseConfigPath = "target/hbase-site.xml";

    @BeforeEach
    public void setup() throws IOException {
        Configuration hbaseConf = new Configuration();
        hbaseConf.set("input", "test");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        hbaseConf.writeXml((OutputStream)bytesOut);
        bytesOut.close();
        File file = new File(this.hbaseConfigPath);
        FileOutputStream os = new FileOutputStream(file);
        ((OutputStream)os).write(bytesOut.toByteArray());
        ((OutputStream)os).close();
    }

    @Test
    void testGetTimelineServiceHBaseConfNullArgument() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> HBaseTimelineStorageUtils.getTimelineServiceHBaseConf(null));
    }

    @Test
    void testWithHbaseConfAtLocalFileSystem() throws IOException {
        Configuration conf = new Configuration();
        conf.set("yarn.timeline-service.hbase.configuration.file", this.hbaseConfigPath);
        Configuration hbaseConfFromLocal = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf((Configuration)conf);
        Assertions.assertEquals((Object)"test", (Object)hbaseConfFromLocal.get("input"), (String)"Failed to read hbase config from Local FileSystem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testWithHbaseConfAtHdfsFileSystem() throws IOException {
        MiniDFSCluster hdfsCluster = null;
        try {
            HdfsConfiguration hdfsConfig = new HdfsConfiguration();
            hdfsCluster = new MiniDFSCluster.Builder((Configuration)hdfsConfig).numDataNodes(1).build();
            DistributedFileSystem fs = hdfsCluster.getFileSystem();
            Path path = new Path("/tmp/hdfs-site.xml");
            fs.copyFromLocalFile(new Path(this.hbaseConfigPath), path);
            Configuration conf = new Configuration((Configuration)hdfsConfig);
            conf.set("yarn.timeline-service.hbase.configuration.file", path.toString());
            Configuration hbaseConfFromHdfs = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf((Configuration)conf);
            Assertions.assertEquals((Object)"test", (Object)hbaseConfFromHdfs.get("input"), (String)"Failed to read hbase config from Hdfs FileSystem");
        }
        finally {
            if (hdfsCluster != null) {
                hdfsCluster.shutdown();
            }
        }
    }
}

