/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreCollectionCreator;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreFactory;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.DocumentStoreWriter;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.DummyDocumentStoreWriter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DocumentStoreFactory.class})
public class TestDocumentStoreCollectionCreator {
    private final DocumentStoreWriter<TimelineDocument> documentStoreWriter = new DummyDocumentStoreWriter<TimelineDocument>();
    private final Configuration conf = new Configuration();

    @Before
    public void setUp() throws YarnException {
        this.conf.set("yarn.timeline-service.document-store.db-name", "TestDB");
        this.conf.set("yarn.timeline-service.document-store.cosmos-db.endpoint", "https://localhost:443");
        this.conf.set("yarn.timeline-service.document-store.cosmos-db.masterkey", "1234567");
        PowerMockito.mockStatic(DocumentStoreFactory.class, (Class[])new Class[0]);
        PowerMockito.when((Object)DocumentStoreFactory.createDocumentStoreWriter((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn(this.documentStoreWriter);
    }

    @Test
    public void collectionCreatorTest() {
        new DocumentStoreCollectionCreator().createTimelineSchema(new String[0]);
    }
}

