/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineWriteResponse;
import org.apache.hadoop.yarn.server.timelineservice.TimelineContext;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.CollectionType;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowactivity.FlowActivityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowrun.FlowRunDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreVendor;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.TimelineCollectionWriter;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineAggregationTrack;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStoreTimelineWriterImpl
extends AbstractService
implements TimelineWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentStoreTimelineWriterImpl.class);
    private static final String DOC_ID_DELIMITER = "!";
    private DocumentStoreVendor storeType;
    private TimelineCollectionWriter<TimelineEntityDocument> appCollWriter;
    private TimelineCollectionWriter<TimelineEntityDocument> entityCollWriter;
    private TimelineCollectionWriter<FlowActivityDocument> flowActivityCollWriter;
    private TimelineCollectionWriter<FlowRunDocument> flowRunCollWriter;

    public DocumentStoreTimelineWriterImpl() {
        super(DocumentStoreTimelineWriterImpl.class.getName());
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.storeType = DocumentStoreUtils.getStoreVendor(conf);
        LOG.info("Initializing Document Store Writer for : " + (Object)((Object)this.storeType));
        super.serviceInit(conf);
        this.appCollWriter = new TimelineCollectionWriter(CollectionType.APPLICATION, conf);
        this.entityCollWriter = new TimelineCollectionWriter(CollectionType.ENTITY, conf);
        this.flowActivityCollWriter = new TimelineCollectionWriter(CollectionType.FLOW_ACTIVITY, conf);
        this.flowRunCollWriter = new TimelineCollectionWriter(CollectionType.FLOW_RUN, conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
        this.appCollWriter.close();
        this.entityCollWriter.close();
        this.flowActivityCollWriter.close();
        this.flowRunCollWriter.close();
    }

    public TimelineWriteResponse write(TimelineCollectorContext context, TimelineEntities data, UserGroupInformation callerUgi) {
        LOG.debug("Writing Timeline Entity for appID : {}", (Object)context.getAppId());
        TimelineWriteResponse putStatus = new TimelineWriteResponse();
        String subApplicationUser = callerUgi.getShortUserName();
        if (DocumentStoreUtils.isNullOrEmpty(context.getFlowName(), context.getAppId(), context.getClusterId(), context.getUserId())) {
            LOG.warn("Found NULL for one of: flowName={} appId={} userId={} clusterId={} . Not proceeding on writing to store : " + (Object)((Object)this.storeType));
            return putStatus;
        }
        for (TimelineEntity timelineEntity : data.getEntities()) {
            TimelineEntityDocument entityDocument;
            if (timelineEntity == null) continue;
            if (ApplicationEntity.isApplicationEntity((TimelineEntity)timelineEntity)) {
                entityDocument = this.createTimelineEntityDoc(context, subApplicationUser, timelineEntity, true);
                FlowRunDocument flowRunDoc = this.createFlowRunDoc(context, timelineEntity.getMetrics());
                FlowActivityDocument flowActivityDoc = this.getFlowActivityDoc(context, timelineEntity, flowRunDoc, entityDocument);
                this.writeApplicationDoc(entityDocument);
                this.writeFlowRunDoc(flowRunDoc);
                if (flowActivityDoc == null) continue;
                this.storeFlowActivityDoc(flowActivityDoc);
                continue;
            }
            entityDocument = this.createTimelineEntityDoc(context, subApplicationUser, timelineEntity, false);
            this.appendSubAppUserIfExists(context, subApplicationUser);
            entityDocument.setCreatedTime(this.fetchEntityCreationTime(timelineEntity));
            this.writeEntityDoc(entityDocument);
        }
        return putStatus;
    }

    public TimelineWriteResponse write(TimelineCollectorContext context, TimelineDomain domain) throws IOException {
        return null;
    }

    private void appendSubAppUserIfExists(TimelineCollectorContext context, String subApplicationUser) {
        String userId = context.getUserId();
        if (!userId.equals(subApplicationUser) && !userId.contains(subApplicationUser)) {
            userId = userId.concat(DOC_ID_DELIMITER).concat(subApplicationUser);
            context.setUserId(userId);
        }
    }

    private TimelineEntityDocument createTimelineEntityDoc(TimelineCollectorContext context, String subApplicationUser, TimelineEntity timelineEntity, boolean isAppEntity) {
        TimelineEntityDocument entityDocument = new TimelineEntityDocument(timelineEntity);
        entityDocument.setContext((TimelineContext)context);
        entityDocument.setFlowVersion(context.getFlowVersion());
        entityDocument.setSubApplicationUser(subApplicationUser);
        if (isAppEntity) {
            entityDocument.setId(DocumentStoreUtils.constructTimelineEntityDocId(context, timelineEntity.getType()));
        } else {
            entityDocument.setId(DocumentStoreUtils.constructTimelineEntityDocId(context, timelineEntity.getType(), timelineEntity.getId()));
        }
        return entityDocument;
    }

    private FlowRunDocument createFlowRunDoc(TimelineCollectorContext context, Set<TimelineMetric> metrics) {
        FlowRunDocument flowRunDoc = new FlowRunDocument(context, metrics);
        flowRunDoc.setFlowVersion(context.getFlowVersion());
        flowRunDoc.setId(DocumentStoreUtils.constructFlowRunDocId(context));
        return flowRunDoc;
    }

    private long fetchEntityCreationTime(TimelineEntity timelineEntity) {
        switch (TimelineEntityType.valueOf((String)timelineEntity.getType())) {
            case YARN_CONTAINER: {
                TimelineEvent event = DocumentStoreUtils.fetchEvent(timelineEntity, "YARN_CONTAINER_CREATED");
                if (event == null) break;
                return event.getTimestamp();
            }
            case YARN_APPLICATION_ATTEMPT: {
                TimelineEvent event = DocumentStoreUtils.fetchEvent(timelineEntity, "YARN_APPLICATION_ATTEMPT_REGISTERED");
                if (event == null) break;
                return event.getTimestamp();
            }
        }
        if (timelineEntity.getCreatedTime() == null) {
            return 0L;
        }
        return timelineEntity.getCreatedTime();
    }

    private FlowActivityDocument getFlowActivityDoc(TimelineCollectorContext context, TimelineEntity timelineEntity, FlowRunDocument flowRunDoc, TimelineEntityDocument entityDocument) {
        FlowActivityDocument flowActivityDoc = null;
        TimelineEvent event = DocumentStoreUtils.fetchEvent(timelineEntity, "YARN_APPLICATION_CREATED");
        if (event != null) {
            entityDocument.setCreatedTime(event.getTimestamp());
            flowRunDoc.setMinStartTime(event.getTimestamp());
            flowActivityDoc = this.createFlowActivityDoc(context, context.getFlowName(), context.getFlowVersion(), context.getFlowRunId(), event);
        }
        if ((event = DocumentStoreUtils.fetchEvent(timelineEntity, "YARN_APPLICATION_FINISHED")) != null) {
            flowRunDoc.setMaxEndTime(event.getTimestamp());
            if (flowActivityDoc == null) {
                flowActivityDoc = this.createFlowActivityDoc(context, context.getFlowName(), context.getFlowVersion(), context.getFlowRunId(), event);
            }
        }
        return flowActivityDoc;
    }

    private FlowActivityDocument createFlowActivityDoc(TimelineCollectorContext context, String flowName, String flowVersion, long flowRunId, TimelineEvent event) {
        FlowActivityDocument flowActivityDoc = new FlowActivityDocument(flowName, flowVersion, flowRunId);
        flowActivityDoc.setDayTimestamp(DocumentStoreUtils.getTopOfTheDayTimestamp(event.getTimestamp()));
        flowActivityDoc.setFlowName(flowName);
        flowActivityDoc.setUser(context.getUserId());
        flowActivityDoc.setId(DocumentStoreUtils.constructFlowActivityDocId(context, event.getTimestamp()));
        return flowActivityDoc;
    }

    private void writeFlowRunDoc(FlowRunDocument flowRunDoc) {
        this.flowRunCollWriter.writeDocument(flowRunDoc);
    }

    private void storeFlowActivityDoc(FlowActivityDocument flowActivityDoc) {
        this.flowActivityCollWriter.writeDocument(flowActivityDoc);
    }

    private void writeEntityDoc(TimelineEntityDocument entityDocument) {
        this.entityCollWriter.writeDocument(entityDocument);
    }

    private void writeApplicationDoc(TimelineEntityDocument entityDocument) {
        this.appCollWriter.writeDocument(entityDocument);
    }

    public TimelineWriteResponse aggregate(TimelineEntity data, TimelineAggregationTrack track) {
        return null;
    }

    public void flush() {
    }
}

