/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.cosmosdb;

import com.microsoft.azure.cosmosdb.rx.AsyncDocumentClient;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreTestUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.CollectionType;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.cosmosdb.MockedCosmosDBDocumentStoreWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DocumentStoreUtils.class})
public class TestCosmosDBDocumentStoreWriter {
    @Before
    public void setUp() {
        AsyncDocumentClient asyncDocumentClient = (AsyncDocumentClient)Mockito.mock(AsyncDocumentClient.class);
        PowerMockito.mockStatic(DocumentStoreUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)DocumentStoreUtils.getCosmosDBDatabaseName((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn((Object)"FooBar");
        PowerMockito.when((Object)DocumentStoreUtils.createCosmosDBAsyncClient((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn((Object)asyncDocumentClient);
    }

    @Test
    public void applyingUpdatesOnPrevDocTest() throws IOException {
        MockedCosmosDBDocumentStoreWriter documentStoreWriter = new MockedCosmosDBDocumentStoreWriter(null);
        TimelineEntityDocument actualEntityDoc = new TimelineEntityDocument();
        TimelineEntityDocument expectedEntityDoc = DocumentStoreTestUtils.bakeTimelineEntityDoc();
        Assert.assertEquals((long)1L, (long)actualEntityDoc.getInfo().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getMetrics().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getEvents().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getConfigs().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getIsRelatedToEntities().size());
        Assert.assertEquals((long)0L, (long)actualEntityDoc.getRelatesToEntities().size());
        actualEntityDoc = (TimelineEntityDocument)documentStoreWriter.applyUpdatesOnPrevDoc(CollectionType.ENTITY, (TimelineDocument)actualEntityDoc, null);
        Assert.assertEquals((long)expectedEntityDoc.getInfo().size(), (long)actualEntityDoc.getInfo().size());
        Assert.assertEquals((long)expectedEntityDoc.getMetrics().size(), (long)actualEntityDoc.getMetrics().size());
        Assert.assertEquals((long)expectedEntityDoc.getEvents().size(), (long)actualEntityDoc.getEvents().size());
        Assert.assertEquals((long)expectedEntityDoc.getConfigs().size(), (long)actualEntityDoc.getConfigs().size());
        Assert.assertEquals((long)expectedEntityDoc.getRelatesToEntities().size(), (long)actualEntityDoc.getIsRelatedToEntities().size());
        Assert.assertEquals((long)expectedEntityDoc.getRelatesToEntities().size(), (long)actualEntityDoc.getRelatesToEntities().size());
    }
}

