/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineEntityGroupPlugin;

class EntityGroupPlugInForTest
extends TimelineEntityGroupPlugin {
    static final String APP_ID_FILTER_NAME = "appid";

    EntityGroupPlugInForTest() {
    }

    public Set<TimelineEntityGroupId> getTimelineEntityGroupId(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters) {
        ApplicationId appId = ApplicationId.fromString((String)primaryFilter.getValue().toString());
        return Sets.newHashSet((Object[])new TimelineEntityGroupId[]{EntityGroupPlugInForTest.getStandardTimelineGroupId(appId)});
    }

    public Set<TimelineEntityGroupId> getTimelineEntityGroupId(String entityId, String entityType) {
        ApplicationId appId = ApplicationId.fromString((String)entityId);
        return Sets.newHashSet((Object[])new TimelineEntityGroupId[]{EntityGroupPlugInForTest.getStandardTimelineGroupId(appId)});
    }

    public Set<TimelineEntityGroupId> getTimelineEntityGroupId(String entityType, SortedSet<String> entityIds, Set<String> eventTypes) {
        return Sets.newHashSet();
    }

    static TimelineEntityGroupId getStandardTimelineGroupId(ApplicationId appId) {
        return TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)"test");
    }
}

