/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import com.sun.jersey.api.client.Client;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.router.webapp.RouterBlock;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class AppsBlock
extends RouterBlock {
    private final Router router;
    private final Configuration conf;

    @Inject
    AppsBlock(Router router, View.ViewContext ctx) {
        super(router, ctx);
        this.router = router;
        this.conf = this.router.getConfig();
    }

    protected void render(HtmlBlock.Block html) {
        boolean isEnabled = this.isYarnFederationEnabled();
        String subClusterName = this.$("app.subcluster");
        String reqState = this.$("app.state");
        AppsInfo appsInfo = null;
        if (subClusterName != null && !subClusterName.isEmpty()) {
            this.initSubClusterMetricsOverviewTable(html, subClusterName);
            appsInfo = this.getSubClusterAppsInfo(subClusterName, reqState);
        } else {
            html.__(MetricsOverviewTable.class);
            appsInfo = this.getYarnFederationAppsInfo(isEnabled);
        }
        this.initYarnFederationAppsOfCluster(appsInfo, html);
    }

    private static String escape(String str) {
        return StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)str));
    }

    private AppsInfo getYarnFederationAppsInfo(boolean isEnabled) {
        String webAddress = null;
        webAddress = isEnabled ? WebAppUtils.getRouterWebAppURLWithScheme((Configuration)this.conf) : WebAppUtils.getRMWebAppURLWithScheme((Configuration)this.conf);
        return this.getSubClusterAppsInfoByWebAddress(webAddress, "");
    }

    private AppsInfo getSubClusterAppsInfo(String subCluster, String states) {
        try {
            String webAddress;
            SubClusterId subClusterId = SubClusterId.newInstance((String)subCluster);
            FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance((Configuration)this.conf);
            SubClusterInfo subClusterInfo = facade.getSubCluster(subClusterId);
            if (subClusterInfo != null && (webAddress = subClusterInfo.getRMWebServiceAddress()) != null && !webAddress.isEmpty()) {
                String herfWebAppAddress = WebAppUtils.getHttpSchemePrefix((Configuration)this.conf) + webAddress;
                return this.getSubClusterAppsInfoByWebAddress(herfWebAppAddress, states);
            }
        }
        catch (Exception e) {
            LOG.error("get AppsInfo From SubCluster = {} error.", (Object)subCluster, (Object)e);
        }
        return null;
    }

    private AppsInfo getSubClusterAppsInfoByWebAddress(String webAddress, String states) {
        Client client = RouterWebServiceUtil.createJerseyClient(this.conf);
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        if (StringUtils.isNotBlank((CharSequence)states)) {
            queryParams.put("states", new String[]{states});
        }
        AppsInfo apps = RouterWebServiceUtil.genericForward(webAddress, null, AppsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps", null, queryParams, this.conf, client);
        client.destroy();
        return apps;
    }

    private void initYarnFederationAppsOfCluster(AppsInfo appsInfo, HtmlBlock.Block html) {
        List appInfoList;
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#apps").thead().tr().th(".id", "ID").th(".user", "User").th(".name", "Name").th(".type", "Application Type").th(".queue", "Queue").th(".priority", "Application Priority").th(".starttime", "StartTime").th(".finishtime", "FinishTime").th(".state", "State").th(".finalstatus", "FinalStatus").th(".progress", "Progress").th(".ui", "Tracking UI").__()).__()).tbody();
        StringBuilder appsTableData = new StringBuilder("[\n");
        if (appsInfo != null && CollectionUtils.isNotEmpty((Collection)appsInfo.getApps()) && CollectionUtils.isNotEmpty(appInfoList = appsInfo.getApps().stream().map(this::parseAppInfoData).collect(Collectors.toList()))) {
            String formattedAppInfo = StringUtils.join(appInfoList, (String)",");
            appsTableData.append(formattedAppInfo);
        }
        appsTableData.append("]");
        html.script().$type("text/javascript").__(new Object[]{"var appsTableData=" + appsTableData}).__();
        ((Hamlet.TABLE)tbody.__()).__();
    }

    private String parseAppInfoData(AppInfo app) {
        StringBuilder appsDataBuilder = new StringBuilder();
        try {
            String percent = String.format("%.1f", Float.valueOf(app.getProgress() * 100.0f));
            String trackingURL = app.getTrackingUrl() == null ? "#" : app.getTrackingUrl();
            appsDataBuilder.append("[\"").append("<a href='").append(trackingURL).append("'>").append(app.getAppId()).append("</a>\",\"").append(AppsBlock.escape(app.getUser())).append("\",\"").append(AppsBlock.escape(app.getName())).append("\",\"").append(AppsBlock.escape(app.getApplicationType())).append("\",\"").append(AppsBlock.escape(app.getQueue())).append("\",\"").append(app.getPriority()).append("\",\"").append(app.getStartTime()).append("\",\"").append(app.getFinishTime()).append("\",\"").append(app.getState()).append("\",\"").append(app.getFinalStatus()).append("\",\"").append("<br title='").append(percent).append("'> <div class='").append(JQueryUI.C_PROGRESSBAR).append("' title='").append(StringHelper.join((Object[])new Object[]{percent, Character.valueOf('%')})).append("'> ").append("<div class='").append(JQueryUI.C_PROGRESSBAR_VALUE).append("' style='").append(StringHelper.join((Object[])new Object[]{"width:", percent, Character.valueOf('%')})).append("'> </div> </div>").append("\",\"<a href='").append(trackingURL).append("'>").append("History").append("</a>");
            appsDataBuilder.append("\"]\n");
        }
        catch (Exception e) {
            LOG.warn("Cannot add application {}: {}", (Object)app.getAppId(), (Object)e.getMessage());
        }
        return appsDataBuilder.toString();
    }
}

