/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.sun.jersey.api.ConflictException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.util.WebServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouterWebServiceUtil {
    private static String user = "YarnRouter";
    private static final Logger LOG = LoggerFactory.getLogger((String)RouterWebServiceUtil.class.getName());
    private static final String PARTIAL_REPORT = "Partial Report ";

    private RouterWebServiceUtil() {
    }

    protected static <T> T genericForward(final String webApp, final HttpServletRequest hsr, final Class<T> returnType, final HTTPMethods method, final String targetPath, final Object formParam, final Map<String, String[]> additionalParam, final Configuration conf) {
        UserGroupInformation callerUGI = null;
        callerUGI = hsr != null ? RMWebAppUtil.getCallerUserGroupInformation((HttpServletRequest)hsr, (boolean)true) : UserGroupInformation.createRemoteUser((String)user);
        if (callerUGI == null) {
            LOG.error("Unable to obtain user name, user not authenticated");
            return null;
        }
        try {
            return (T)callerUGI.doAs(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() {
                    Map paramMap = null;
                    if (hsr != null) {
                        paramMap = hsr.getParameterMap();
                    } else if (additionalParam != null) {
                        paramMap = additionalParam;
                    }
                    ClientResponse response = RouterWebServiceUtil.invokeRMWebService(webApp, targetPath, method, hsr == null ? null : hsr.getPathInfo(), paramMap, formParam, RouterWebServiceUtil.getMediaTypeFromHttpServletRequest(hsr, returnType), conf);
                    if (Response.class.equals((Object)returnType)) {
                        return RouterWebServiceUtil.clientResponseToResponse(response);
                    }
                    if (response.getStatus() == 200) {
                        return response.getEntity(returnType);
                    }
                    if (response.getStatus() == 204) {
                        try {
                            return returnType.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (ReflectiveOperationException | RuntimeException e) {
                            LOG.error("Cannot create empty entity for {}", (Object)returnType, (Object)e);
                        }
                    }
                    RouterWebServiceUtil.retrieveException(response);
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static ClientResponse invokeRMWebService(String webApp, String path, HTTPMethods method, String additionalPath, Map<String, String[]> queryParams, Object formParam, String mediaType, Configuration conf) {
        Client client = WebServiceClient.getWebServiceClient().createClient();
        InetSocketAddress socketAddress = NetUtils.getConnectAddress((InetSocketAddress)NetUtils.createSocketAddr((String)webApp));
        String scheme = YarnConfiguration.useHttps((Configuration)conf) ? "https://" : "http://";
        String webAddress = scheme + socketAddress.getHostName() + ":" + socketAddress.getPort();
        WebResource webResource = client.resource(webAddress).path(path);
        if (additionalPath != null && !additionalPath.isEmpty()) {
            webResource = webResource.path(additionalPath);
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            MultivaluedMapImpl paramMap = new MultivaluedMapImpl();
            for (Map.Entry<String, String[]> param : queryParams.entrySet()) {
                String[] values = param.getValue();
                for (int i = 0; i < values.length; ++i) {
                    paramMap.add((Object)param.getKey(), (Object)values[i]);
                }
            }
            webResource = webResource.queryParams((MultivaluedMap)paramMap);
        }
        WebResource.Builder builder = null;
        if (formParam != null) {
            builder = webResource.entity(formParam, mediaType);
            builder = (WebResource.Builder)builder.accept(new String[]{mediaType});
        } else {
            builder = webResource.accept(new String[]{mediaType});
        }
        ClientResponse response = null;
        switch (method) {
            case DELETE: {
                response = (ClientResponse)builder.delete(ClientResponse.class);
                break;
            }
            case GET: {
                response = (ClientResponse)builder.get(ClientResponse.class);
                break;
            }
            case POST: {
                response = (ClientResponse)builder.post(ClientResponse.class);
                break;
            }
            case PUT: {
                response = (ClientResponse)builder.put(ClientResponse.class);
                break;
            }
        }
        return response;
    }

    public static Response clientResponseToResponse(ClientResponse r) {
        if (r == null) {
            return null;
        }
        Response.ResponseBuilder rb = Response.status((int)r.getStatus());
        for (Map.Entry entry : r.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                rb.header((String)entry.getKey(), (Object)value);
            }
        }
        rb.entity((Object)r.getEntityInputStream());
        return rb.build();
    }

    public static void retrieveException(ClientResponse response) {
        String serverErrorMsg = (String)response.getEntity(String.class);
        int status = response.getStatus();
        if (status == 400) {
            throw new BadRequestException(serverErrorMsg);
        }
        if (status == 403) {
            throw new ForbiddenException(serverErrorMsg);
        }
        if (status == 404) {
            throw new NotFoundException(serverErrorMsg);
        }
        if (status == 409) {
            throw new ConflictException(serverErrorMsg);
        }
    }

    public static AppsInfo mergeAppsInfo(ArrayList<AppInfo> appsInfo, boolean returnPartialResult) {
        AppsInfo allApps = new AppsInfo();
        HashMap<String, AppInfo> federationAM = new HashMap<String, AppInfo>();
        HashMap<String, AppInfo> federationUAMSum = new HashMap<String, AppInfo>();
        for (AppInfo a : appsInfo) {
            if (a.getAMHostHttpAddress() != null) {
                federationAM.put(a.getAppId(), a);
                if (!federationUAMSum.containsKey(a.getAppId())) continue;
                RouterWebServiceUtil.mergeAMWithUAM(a, (AppInfo)federationUAMSum.get(a.getAppId()));
                federationUAMSum.remove(a.getAppId());
                continue;
            }
            if (federationAM.containsKey(a.getAppId())) {
                RouterWebServiceUtil.mergeAMWithUAM((AppInfo)federationAM.get(a.getAppId()), a);
                continue;
            }
            if (federationUAMSum.containsKey(a.getAppId())) {
                federationUAMSum.put(a.getAppId(), RouterWebServiceUtil.mergeUAMWithUAM((AppInfo)federationUAMSum.get(a.getAppId()), a));
                continue;
            }
            federationUAMSum.put(a.getAppId(), a);
        }
        for (AppInfo a : federationUAMSum.values()) {
            if (!returnPartialResult && (a.getName() == null || a.getName().startsWith("UnmanagedAM") || a.getName().startsWith(PARTIAL_REPORT))) continue;
            federationAM.put(a.getAppId(), a);
        }
        allApps.addAll(new ArrayList(federationAM.values()));
        return allApps;
    }

    private static AppInfo mergeUAMWithUAM(AppInfo uam1, AppInfo uam2) {
        AppInfo partialReport = new AppInfo();
        partialReport.setAppId(uam1.getAppId());
        partialReport.setName(PARTIAL_REPORT + uam1.getAppId());
        partialReport.setState(uam1.getState());
        RouterWebServiceUtil.mergeAMWithUAM(partialReport, uam1);
        RouterWebServiceUtil.mergeAMWithUAM(partialReport, uam2);
        return partialReport;
    }

    private static void mergeAMWithUAM(AppInfo am, AppInfo uam) {
        am.setPreemptedResourceMB(am.getPreemptedResourceMB() + uam.getPreemptedResourceMB());
        am.setPreemptedResourceVCores(am.getPreemptedResourceVCores() + uam.getPreemptedResourceVCores());
        am.setNumNonAMContainerPreempted(am.getNumNonAMContainerPreempted() + uam.getNumNonAMContainerPreempted());
        am.setNumAMContainerPreempted(am.getNumAMContainerPreempted() + uam.getNumAMContainerPreempted());
        am.setPreemptedMemorySeconds(am.getPreemptedMemorySeconds() + uam.getPreemptedMemorySeconds());
        am.setPreemptedVcoreSeconds(am.getPreemptedVcoreSeconds() + uam.getPreemptedVcoreSeconds());
        if (am.getState() == YarnApplicationState.RUNNING && uam.getState() == am.getState()) {
            am.getResourceRequests().addAll(uam.getResourceRequests());
            am.setAllocatedMB(am.getAllocatedMB() + uam.getAllocatedMB());
            am.setAllocatedVCores(am.getAllocatedVCores() + uam.getAllocatedVCores());
            am.setReservedMB(am.getReservedMB() + uam.getReservedMB());
            am.setReservedVCores(am.getReservedVCores() + uam.getReservedMB());
            am.setRunningContainers(am.getRunningContainers() + uam.getRunningContainers());
            am.setMemorySeconds(am.getMemorySeconds() + uam.getMemorySeconds());
            am.setVcoreSeconds(am.getVcoreSeconds() + uam.getVcoreSeconds());
        }
    }

    public static NodesInfo deleteDuplicateNodesInfo(ArrayList<NodeInfo> nodes) {
        NodesInfo nodesInfo = new NodesInfo();
        LinkedHashMap<String, NodeInfo> nodesMap = new LinkedHashMap<String, NodeInfo>();
        for (NodeInfo node : nodes) {
            String nodeId = node.getNodeId();
            if (nodesMap.containsKey(nodeId)) {
                if (((NodeInfo)nodesMap.get(nodeId)).getLastHealthUpdate() >= node.getLastHealthUpdate()) continue;
                nodesMap.put(node.getNodeId(), node);
                continue;
            }
            nodesMap.put(node.getNodeId(), node);
        }
        nodesInfo.addAll(new ArrayList(nodesMap.values()));
        return nodesInfo;
    }

    public static void mergeMetrics(ClusterMetricsInfo metrics, ClusterMetricsInfo metricsResponse) {
        metrics.setAppsSubmitted(metrics.getAppsSubmitted() + metricsResponse.getAppsSubmitted());
        metrics.setAppsCompleted(metrics.getAppsCompleted() + metricsResponse.getAppsCompleted());
        metrics.setAppsPending(metrics.getAppsPending() + metricsResponse.getAppsPending());
        metrics.setAppsRunning(metrics.getAppsRunning() + metricsResponse.getAppsRunning());
        metrics.setAppsFailed(metrics.getAppsFailed() + metricsResponse.getAppsFailed());
        metrics.setAppsKilled(metrics.getAppsKilled() + metricsResponse.getAppsKilled());
        metrics.setReservedMB(metrics.getReservedMB() + metricsResponse.getReservedMB());
        metrics.setAvailableMB(metrics.getAvailableMB() + metricsResponse.getAvailableMB());
        metrics.setAllocatedMB(metrics.getAllocatedMB() + metricsResponse.getAllocatedMB());
        metrics.setReservedVirtualCores(metrics.getReservedVirtualCores() + metricsResponse.getReservedVirtualCores());
        metrics.setAvailableVirtualCores(metrics.getAvailableVirtualCores() + metricsResponse.getAvailableVirtualCores());
        metrics.setAllocatedVirtualCores(metrics.getAllocatedVirtualCores() + metricsResponse.getAllocatedVirtualCores());
        metrics.setContainersAllocated(metrics.getContainersAllocated() + metricsResponse.getContainersAllocated());
        metrics.setContainersReserved(metrics.getReservedContainers() + metricsResponse.getReservedContainers());
        metrics.setContainersPending(metrics.getPendingContainers() + metricsResponse.getPendingContainers());
        metrics.setTotalMB(metrics.getTotalMB() + metricsResponse.getTotalMB());
        metrics.setTotalVirtualCores(metrics.getTotalVirtualCores() + metricsResponse.getTotalVirtualCores());
        metrics.setTotalNodes(metrics.getTotalNodes() + metricsResponse.getTotalNodes());
        metrics.setLostNodes(metrics.getLostNodes() + metricsResponse.getLostNodes());
        metrics.setUnhealthyNodes(metrics.getUnhealthyNodes() + metricsResponse.getUnhealthyNodes());
        metrics.setDecommissioningNodes(metrics.getDecommissioningNodes() + metricsResponse.getDecommissioningNodes());
        metrics.setDecommissionedNodes(metrics.getDecommissionedNodes() + metricsResponse.getDecommissionedNodes());
        metrics.setRebootedNodes(metrics.getRebootedNodes() + metricsResponse.getRebootedNodes());
        metrics.setActiveNodes(metrics.getActiveNodes() + metricsResponse.getActiveNodes());
        metrics.setShutdownNodes(metrics.getShutdownNodes() + metricsResponse.getShutdownNodes());
    }

    protected static <T> String getMediaTypeFromHttpServletRequest(HttpServletRequest request, Class<T> returnType) {
        if (request == null) {
            return "application/xml";
        }
        if (!returnType.equals(Response.class)) {
            return "application/xml";
        }
        String header = request.getHeader("Accept");
        if (header == null || header.equals("*")) {
            return "application/json";
        }
        return header;
    }
}

