/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.router.clientrm.ClientRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientRequestInterceptor
implements ClientRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientRequestInterceptor.class);
    private Configuration conf;
    private ClientRequestInterceptor nextInterceptor;
    protected UserGroupInformation user = null;

    @Override
    public void setNextInterceptor(ClientRequestInterceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (this.nextInterceptor != null) {
            this.nextInterceptor.setConf(conf);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init(String userName) {
        this.setupUser(userName);
        if (this.nextInterceptor != null) {
            this.nextInterceptor.init(userName);
        }
    }

    @Override
    public void shutdown() {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.shutdown();
        }
    }

    @Override
    public ClientRequestInterceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    private void setupUser(String userName) {
        try {
            this.user = userName.equalsIgnoreCase(UserGroupInformation.getCurrentUser().getUserName()) ? UserGroupInformation.getCurrentUser() : UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        }
        catch (IOException e) {
            String message = "Error while creating Router ClientRM Service for user:";
            if (this.user != null) {
                message = message + ", user: " + this.user;
            }
            LOG.info(message);
            throw new YarnRuntimeException(message, (Throwable)e);
        }
    }
}

