/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AutoCreatedQueueDeletionEvent;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCreatedQueueDeletionPolicy
implements SchedulingEditPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(AutoCreatedQueueDeletionPolicy.class);
    private Clock clock;
    private RMContext rmContext;
    private ResourceCalculator rc;
    private CapacityScheduler scheduler;
    private long monitoringInterval;
    private Set<String> markedForDeletion = new HashSet<String>();
    private Set<String> sentForDeletion = new HashSet<String>();

    @Override
    public void init(Configuration config, RMContext context, ResourceScheduler sched) {
        LOG.info("Auto Deletion Policy monitor: {}" + this.getClass().getCanonicalName());
        if (!(sched instanceof CapacityScheduler)) {
            throw new YarnRuntimeException("Class " + sched.getClass().getCanonicalName() + " not instance of " + CapacityScheduler.class.getCanonicalName());
        }
        this.rmContext = context;
        this.scheduler = (CapacityScheduler)sched;
        this.clock = this.scheduler.getClock();
        this.rc = this.scheduler.getResourceCalculator();
        CapacitySchedulerConfiguration csConfig = this.scheduler.getConfiguration();
        this.monitoringInterval = csConfig.getLong("yarn.scheduler.capacity.auto-queue-creation-v2.queue-expiration-time", 300L) * 1000L;
        this.prepareForAutoDeletion();
    }

    public void prepareForAutoDeletion() {
        HashSet<String> newMarks = new HashSet<String>();
        for (Map.Entry<String, CSQueue> queueEntry : this.scheduler.getCapacitySchedulerQueueManager().getQueues().entrySet()) {
            String queuePath = queueEntry.getKey();
            CSQueue queue = queueEntry.getValue();
            if (!(queue instanceof AbstractCSQueue) || !((AbstractCSQueue)queue).isEligibleForAutoDeletion()) continue;
            if (this.markedForDeletion.contains(queuePath)) {
                this.sentForDeletion.add(queuePath);
                this.markedForDeletion.remove(queuePath);
                continue;
            }
            newMarks.add(queuePath);
        }
        this.markedForDeletion.clear();
        this.markedForDeletion.addAll(newMarks);
    }

    @Override
    public void editSchedule() {
        long startTs = this.clock.getTime();
        this.prepareForAutoDeletion();
        this.triggerAutoDeletionForExpiredQueues();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total time used=" + (this.clock.getTime() - startTs) + " ms.");
        }
    }

    public void triggerAutoDeletionForExpiredQueues() {
        for (String queueName : this.sentForDeletion) {
            CSQueue checkQueue = this.scheduler.getCapacitySchedulerQueueManager().getQueue(queueName);
            this.deleteAutoCreatedQueue(checkQueue);
        }
        this.sentForDeletion.clear();
    }

    private void deleteAutoCreatedQueue(CSQueue queue) {
        if (queue != null) {
            AutoCreatedQueueDeletionEvent autoCreatedQueueDeletionEvent = new AutoCreatedQueueDeletionEvent(queue);
            LOG.info("Queue:" + queue.getQueuePath() + " will trigger deletion event to CS.");
            this.scheduler.getRMContext().getDispatcher().getEventHandler().handle((Event)autoCreatedQueueDeletionEvent);
        }
    }

    @Override
    public long getMonitoringInterval() {
        return this.monitoringInterval;
    }

    @Override
    public String getPolicyName() {
        return AutoCreatedQueueDeletionPolicy.class.getCanonicalName();
    }

    @VisibleForTesting
    public Set<String> getMarkedForDeletion() {
        return this.markedForDeletion;
    }

    @VisibleForTesting
    public Set<String> getSentForDeletion() {
        return this.sentForDeletion;
    }
}

