/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueuePlacementRule;

public class AllocationFileQueuePlacementPolicy {
    private List<AllocationFileQueuePlacementRule> rules = Lists.newArrayList();

    public AllocationFileQueuePlacementPolicy addRule(AllocationFileQueuePlacementRule rule) {
        this.rules.add(rule);
        return this;
    }

    public String render() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.addStartTag(pw);
        this.addRules(pw);
        this.addEndTag(pw);
        pw.close();
        return sw.toString();
    }

    private void addStartTag(PrintWriter pw) {
        pw.println("<queuePlacementPolicy>");
    }

    private void addRules(PrintWriter pw) {
        for (AllocationFileQueuePlacementRule rule : this.rules) {
            pw.println(rule.render());
        }
    }

    private void addEndTag(PrintWriter pw) {
        pw.println("</queuePlacementPolicy>");
    }
}

