/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTags;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm.LocalAllocationTagsManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalAllocationTagsManager {
    private RMContext rmContext;

    @Before
    public void setup() {
        MockRM rm = new MockRM();
        rm.start();
        MockNodes.resetHostIds();
        List<RMNode> rmNodes = MockNodes.newNodes(2, 4, Resource.newInstance((int)4096, (int)4));
        for (RMNode rmNode : rmNodes) {
            rm.getRMContext().getRMNodes().putIfAbsent(rmNode.getNodeID(), rmNode);
        }
        this.rmContext = rm.getRMContext();
    }

    @Test
    public void testTempContainerAllocations() throws InvalidAllocationTagsQueryException {
        AllocationTagsManager atm = new AllocationTagsManager(this.rmContext);
        LocalAllocationTagsManager ephAtm = new LocalAllocationTagsManager(atm);
        ephAtm.addTempTags(NodeId.fromString((String)"host1:123"), TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper", (Object)"reducer"));
        atm.addContainer(NodeId.fromString((String)"host1:123"), TestUtils.getMockContainerId(1, 2), (Set)ImmutableSet.of((Object)"service"));
        atm.addContainer(NodeId.fromString((String)"host2:123"), TestUtils.getMockContainerId(1, 3), (Set)ImmutableSet.of((Object)"reducer"));
        ephAtm.addTempTags(NodeId.fromString((String)"host2:123"), TestUtils.getMockApplicationId(2), (Set)ImmutableSet.of((Object)"service"));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host1:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper")), Long::sum));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host1:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"service")), Long::sum));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(2), (Set)ImmutableSet.of((Object)"service")), Long::sum));
        ephAtm.cleanTempContainers(TestUtils.getMockApplicationId(2));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(2), (Set)ImmutableSet.of((Object)"service")), Long::sum));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host1:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper")), Long::sum));
        ephAtm.cleanTempContainers(TestUtils.getMockApplicationId(1));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host1:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"mapper")), Long::sum));
        Assert.assertEquals((long)1L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host1:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), (Set)ImmutableSet.of((Object)"service")), Long::sum));
        Assert.assertEquals((long)0L, (long)atm.getNodeCardinalityByOp(NodeId.fromString((String)"host2:123"), AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(2), (Set)ImmutableSet.of((Object)"service")), Long::sum));
        Assert.assertEquals((long)2L, (long)((AllocationTagsManager.TypeToCountedTags)atm.getPerAppNodeMappings().get(TestUtils.getMockApplicationId(1))).getTypeToTagsWithCount().size());
        Assert.assertNull(atm.getPerAppNodeMappings().get(TestUtils.getMockApplicationId(2)));
    }
}

