/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement.GuaranteedOrZeroCapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FairOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCapacitySchedulerAutoQueueCreation
extends TestCapacitySchedulerAutoCreatedQueueBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestCapacitySchedulerAutoQueueCreation.class);
    private static final String SPECIFIED_QUEUE_MAPPING = "%specified";
    private static final String CURRENT_USER_MAPPING = "%user";
    private static final Resource TEMPLATE_MAX_RES = Resource.newInstance((int)16384, (int)48);
    private static final Resource TEMPLATE_MIN_RES = Resource.newInstance((int)1638, (int)4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testAutoCreateLeafQueueCreation() throws Exception {
        try {
            this.submitApp(this.mockRM, this.cs.getQueue("c"), "user_0", "user_0", 1, 1);
            List appsInC = this.cs.getAppsInQueue("c");
            Assert.assertEquals((long)1L, (long)appsInC.size());
            Assert.assertNotNull((Object)this.cs.getQueue("user_0"));
            AutoCreatedLeafQueue autoCreatedLeafQueue = (AutoCreatedLeafQueue)this.cs.getQueue("user_0");
            ManagedParentQueue parentQueue = (ManagedParentQueue)this.cs.getQueue("c");
            Assert.assertEquals((Object)parentQueue, (Object)autoCreatedLeafQueue.getParent());
            HashMap<String, Float> expectedChildQueueAbsCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(1);
            this.validateInitialQueueEntitlement((CSQueue)parentQueue, "user_0", expectedChildQueueAbsCapacity, accessibleNodeLabelsOnC);
            int maxApps = this.cs.getConfiguration().isLegacyQueueMode() ? 4000 : 3999;
            this.validateUserAndAppLimits(autoCreatedLeafQueue, maxApps, maxApps);
            this.validateContainerLimits(autoCreatedLeafQueue, 6, 10240L);
            Assert.assertTrue((boolean)(autoCreatedLeafQueue.getOrderingPolicy() instanceof FairOrderingPolicy));
            TestCapacitySchedulerAutoQueueCreation.setupGroupQueueMappings("d", this.cs.getConfiguration(), CURRENT_USER_MAPPING);
            this.cs.reinitialize((Configuration)this.cs.getConfiguration(), this.mockRM.getRMContext());
            this.submitApp(this.mockRM, this.cs.getQueue("d"), "testuser", "testuser", 1, 1);
            autoCreatedLeafQueue = (AutoCreatedLeafQueue)this.cs.getQueue("testuser");
            parentQueue = (ManagedParentQueue)this.cs.getQueue("d");
            Assert.assertEquals((Object)parentQueue, (Object)autoCreatedLeafQueue.getParent());
            expectedChildQueueAbsCapacity = new HashMap<String, Float>(){
                {
                    this.put("", Float.valueOf(0.02f));
                }
            };
            this.validateInitialQueueEntitlement((CSQueue)parentQueue, "testuser", (Map<String, Float>)expectedChildQueueAbsCapacity, (Set<String>)new HashSet<String>(){
                {
                    this.add("");
                }
            });
        }
        finally {
            this.cleanupQueue("user_0");
            this.cleanupQueue("testuser");
        }
    }

    @Test(timeout=20000L)
    public void testAutoCreateLeafQueueCreationSchedulerMaximumAllocation() throws Exception {
        try {
            this.setSchedulerMinMaxAllocation(this.cs.getConfiguration());
            this.cs.getConfiguration().setAutoCreatedLeafQueueConfigMaximumAllocation("root.c", "memory-mb=18384,vcores=8");
            this.cs.reinitialize((Configuration)this.cs.getConfiguration(), this.mockRM.getRMContext());
            this.submitApp(this.mockRM, this.cs.getQueue("c"), "user_0", "user_0", 1, 1);
            List appsInC = this.cs.getAppsInQueue("c");
            Assert.assertEquals((long)1L, (long)appsInC.size());
            Assert.assertNotNull((Object)this.cs.getQueue("user_0"));
            AutoCreatedLeafQueue autoCreatedLeafQueue = (AutoCreatedLeafQueue)this.cs.getQueue("user_0");
            this.validateContainerLimits(autoCreatedLeafQueue, 8, 18384L);
        }
        finally {
            this.cleanupQueue("user_0");
            this.cleanupQueue("testuser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testAutoCreateLeafQueueCreationUsingFullParentPath() throws Exception {
        try {
            TestCapacitySchedulerAutoQueueCreation.setupGroupQueueMappings("root.d", this.cs.getConfiguration(), CURRENT_USER_MAPPING);
            this.cs.reinitialize((Configuration)this.cs.getConfiguration(), this.mockRM.getRMContext());
            this.submitApp(this.mockRM, this.cs.getQueue("d"), "testuser", "testuser", 1, 1);
            AutoCreatedLeafQueue autoCreatedLeafQueue = (AutoCreatedLeafQueue)this.cs.getQueue("testuser");
            ManagedParentQueue parentQueue = (ManagedParentQueue)this.cs.getQueue("d");
            Assert.assertEquals((Object)parentQueue, (Object)autoCreatedLeafQueue.getParent());
            HashMap<String, Float> expectedChildQueueAbsCapacity = new HashMap<String, Float>(){
                {
                    this.put("", Float.valueOf(0.02f));
                }
            };
            this.validateInitialQueueEntitlement((CSQueue)parentQueue, "testuser", (Map<String, Float>)expectedChildQueueAbsCapacity, (Set<String>)new HashSet<String>(){
                {
                    this.add("");
                }
            });
        }
        finally {
            this.cleanupQueue("user_0");
            this.cleanupQueue("testuser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReinitializeStoppedAutoCreatedLeafQueue() throws Exception {
        try {
            String host = "127.0.0.1";
            RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
            this.cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
            MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.mockRM).withAppName("test-auto-queue-creation-1").withUser("user_0").withAcls(null).withQueue("user_0").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.mockRM, data1);
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.mockRM).withAppName("test-auto-queue-creation-2").withUser("user_1").withAcls(null).withQueue("user_1").withUnmanagedAM(false).build();
            RMApp app2 = MockRMAppSubmitter.submit(this.mockRM, data);
            List appsInC = this.cs.getAppsInQueue("c");
            Assert.assertEquals((long)2L, (long)appsInC.size());
            Assert.assertNotNull((Object)this.cs.getQueue("user_0"));
            Assert.assertNotNull((Object)this.cs.getQueue("user_1"));
            AutoCreatedLeafQueue user0Queue = (AutoCreatedLeafQueue)this.cs.getQueue("user_0");
            AutoCreatedLeafQueue user1Queue = (AutoCreatedLeafQueue)this.cs.getQueue("user_0");
            ManagedParentQueue parentQueue = (ManagedParentQueue)this.cs.getQueue("c");
            Assert.assertEquals((Object)parentQueue, (Object)user0Queue.getParent());
            Assert.assertEquals((Object)parentQueue, (Object)user1Queue.getParent());
            Map<String, Float> expectedAbsChildQueueCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(2);
            this.validateInitialQueueEntitlement((CSQueue)parentQueue, "user_0", expectedAbsChildQueueCapacity, accessibleNodeLabelsOnC);
            this.validateInitialQueueEntitlement((CSQueue)parentQueue, "user_1", expectedAbsChildQueueCapacity, accessibleNodeLabelsOnC);
            ApplicationAttemptId appAttemptId = (ApplicationAttemptId)appsInC.get(0);
            Priority priority2 = TestUtils.createMockPriority(1);
            RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
            ResourceRequest r1 = TestUtils.createResourceRequest("*", 1024, 1, true, priority2, recordFactory);
            this.cs.allocate(appAttemptId, Collections.singletonList(r1), null, Collections.emptyList(), Collections.singletonList(host), null, NULL_UPDATE_REQUESTS);
            CapacityScheduler.schedule((CapacityScheduler)this.cs);
            user0Queue.stopQueue();
            this.cs.killAllAppsInQueue("user_0");
            this.mockRM.waitForState(appAttemptId, RMAppAttemptState.KILLED);
            this.mockRM.waitForState(appAttemptId.getApplicationId(), RMAppState.KILLED);
            user0Queue.stopQueue();
            Assert.assertEquals((Object)QueueState.STOPPED, (Object)user0Queue.getQueueInfo().getQueueState());
            this.cs.reinitialize(this.cs.getConf(), this.mockRM.getRMContext());
            AutoCreatedLeafQueue user0QueueReinited = (AutoCreatedLeafQueue)this.cs.getQueue("user_0");
            this.validateCapacities(user0QueueReinited, 0.0f, 0.0f, 1.0f, 1.0f);
            AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.cs.getQueue("user_1");
            expectedAbsChildQueueCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(1);
            this.validateInitialQueueEntitlement((CSQueue)parentQueue, leafQueue.getQueuePath(), expectedAbsChildQueueCapacity, accessibleNodeLabelsOnC);
        }
        finally {
            this.cleanupQueue("user_0");
        }
    }

    @Test
    public void testConvertAutoCreateDisabledOnManagedParentQueueFails() throws Exception {
        CapacityScheduler newCS = new CapacityScheduler();
        try {
            CapacitySchedulerConfiguration newConf = this.setupSchedulerConfiguration();
            TestCapacitySchedulerAutoQueueCreation.setupQueueConfiguration(newConf);
            newConf.setAutoCreateChildQueueEnabled("root.c", false);
            newCS.setConf((Configuration)new YarnConfiguration());
            newCS.setRMContext(this.mockRM.getRMContext());
            newCS.init(this.cs.getConf());
            newCS.start();
            newCS.reinitialize((Configuration)newConf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)newConf), new NMTokenSecretManagerInRM((Configuration)newConf), new ClientToAMTokenSecretManagerInRM(), null));
        }
        catch (IOException iOException) {
        }
        finally {
            newCS.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConvertLeafQueueToParentQueueWithAutoCreate() throws Exception {
        CapacityScheduler newCS = new CapacityScheduler();
        try {
            CapacitySchedulerConfiguration newConf = this.setupSchedulerConfiguration();
            TestCapacitySchedulerAutoQueueCreation.setupQueueConfiguration(newConf);
            newConf.setAutoCreatedLeafQueueConfigCapacity("root.a.a1", 3.0f);
            newConf.setAutoCreateChildQueueEnabled("root.a.a1", true);
            newCS.setConf((Configuration)new YarnConfiguration());
            newCS.setRMContext(this.mockRM.getRMContext());
            newCS.init(this.cs.getConf());
            newCS.start();
            LeafQueue a1Queue = (LeafQueue)newCS.getQueue("a1");
            a1Queue.stopQueue();
            newCS.reinitialize((Configuration)newConf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)newConf), new NMTokenSecretManagerInRM((Configuration)newConf), new ClientToAMTokenSecretManagerInRM(), null));
        }
        finally {
            newCS.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConvertFailsFromParentQueueToManagedParentQueue() throws Exception {
        CapacityScheduler newCS = new CapacityScheduler();
        try {
            CapacitySchedulerConfiguration newConf = this.setupSchedulerConfiguration();
            TestCapacitySchedulerAutoQueueCreation.setupQueueConfiguration(newConf);
            newConf.setAutoCreatedLeafQueueConfigCapacity("root.a", 2.0f);
            newConf.setAutoCreateChildQueueEnabled("root.a", true);
            newCS.setConf((Configuration)new YarnConfiguration());
            newCS.setRMContext(this.mockRM.getRMContext());
            newCS.init(this.cs.getConf());
            newCS.start();
            ParentQueue a1Queue = (ParentQueue)newCS.getQueue("a");
            a1Queue.stopQueue();
            newCS.reinitialize((Configuration)newConf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)newConf), new NMTokenSecretManagerInRM((Configuration)newConf), new ClientToAMTokenSecretManagerInRM(), null));
            Assert.fail((String)"Expected exception while converting a parent queue to an auto create enabled parent queue");
        }
        catch (IOException iOException) {
        }
        finally {
            newCS.stop();
        }
    }

    @Test(timeout=10000L)
    public void testAutoCreateLeafQueueFailsWithNoQueueMapping() throws Exception {
        String INVALID_USER = "invalid_user";
        RMApp app = MockRMAppSubmitter.submit(this.mockRM, MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.mockRM).withAppName("app").withUser("invalid_user").withAcls(null).withQueue("invalid_user").withWaitForAppAcceptedState(false).build());
        this.mockRM.drainEvents();
        this.mockRM.waitForState(app.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)app.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueueMappingValidationFailsWithInvalidParentQueueInMapping() throws Exception {
        MockRM newMockRM = this.setupSchedulerInstance();
        try {
            CapacityScheduler newCS = (CapacityScheduler)newMockRM.getResourceScheduler();
            try {
                this.setupQueueMapping(newCS, CURRENT_USER_MAPPING, "a1", CURRENT_USER_MAPPING);
                newCS.updatePlacementRules();
                Assert.fail((String)"Expected invalid parent queue mapping failure");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Queue path 'a1.%user' is invalid because 'root.a.a1' is a leaf queue"));
            }
            try {
                this.setupQueueMapping(newCS, "app_user", "INVALID_PARENT_QUEUE", "app_user");
                newCS.updatePlacementRules();
                Assert.fail((String)"Expected invalid parent queue mapping failure");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Path root 'INVALID_PARENT_QUEUE' does not exist."));
            }
        }
        finally {
            if (newMockRM != null) {
                ((CapacityScheduler)newMockRM.getResourceScheduler()).stop();
                newMockRM.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueueMappingUpdatesFailsOnRemovalOfParentQueueInMapping() throws Exception {
        MockRM newMockRM = this.setupSchedulerInstance();
        try {
            CapacityScheduler newCS = (CapacityScheduler)newMockRM.getResourceScheduler();
            this.setupQueueMapping(newCS, CURRENT_USER_MAPPING, "c", CURRENT_USER_MAPPING);
            newCS.updatePlacementRules();
            try {
                this.setupQueueMapping(newCS, CURRENT_USER_MAPPING, "nonexistent", CURRENT_USER_MAPPING);
                newCS.updatePlacementRules();
                Assert.fail((String)"Expected invalid parent queue mapping failure");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Path root 'nonexistent' does not exist."));
            }
        }
        finally {
            if (newMockRM != null) {
                ((CapacityScheduler)newMockRM.getResourceScheduler()).stop();
                newMockRM.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParentQueueUpdateInQueueMappingFailsAfterAutoCreation() throws Exception {
        MockRM newMockRM = this.setupSchedulerInstance();
        CapacityScheduler newCS = (CapacityScheduler)newMockRM.getResourceScheduler();
        try {
            this.submitApp(newCS, "user_0", "user_0", "c");
            Assert.assertNotNull((Object)newCS.getQueue("user_0"));
            this.setupQueueMapping(newCS, "user_0", "a", CURRENT_USER_MAPPING);
            newCS.updatePlacementRules();
            RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
            Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)this.dispatcher);
            newCS.setRMContext(rmContext);
            ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
            AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "user_0", "user_0", new ApplicationPlacementContext("user_0", "root.a"));
            newCS.handle((SchedulerEvent)addAppEvent);
            RMAppEvent event = new RMAppEvent(appId, RMAppEventType.APP_REJECTED, "error");
            this.dispatcher.spyOnNextEvent((Event)event, 10000L);
        }
        finally {
            if (newMockRM != null) {
                ((CapacityScheduler)newMockRM.getResourceScheduler()).stop();
                newMockRM.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoQueueCreationFailsForEmptyPathWithAQCAndWeightMode() throws Exception {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
        CapacitySchedulerConfiguration conf = this.setupSchedulerConfiguration();
        conf.setAutoQueueCreationV2Enabled("root", true);
        conf.setCapacity("root.default", "1w");
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM newMockRM = new MockRM((Configuration)conf);
        newMockRM.start();
        ((CapacityScheduler)newMockRM.getResourceScheduler()).start();
        CapacityScheduler newCS = (CapacityScheduler)newMockRM.getResourceScheduler();
        try {
            this.submitApp(newCS, "user_0", "user", "root.");
            RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
            Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)this.dispatcher);
            newCS.setRMContext(rmContext);
            ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
            AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "user", "user_0");
            newCS.handle((SchedulerEvent)addAppEvent);
            RMAppEvent event = new RMAppEvent(appId, RMAppEventType.APP_REJECTED, "error");
            this.dispatcher.spyOnNextEvent((Event)event, 10000L);
        }
        finally {
            ((CapacityScheduler)newMockRM.getResourceScheduler()).stop();
            newMockRM.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoQueueCreationWhenQueueExistsWithSameName() throws Exception {
        MockRM newMockRM = this.setupSchedulerInstance();
        CapacityScheduler newCS = (CapacityScheduler)newMockRM.getResourceScheduler();
        try {
            this.setupQueueMapping(newCS, CURRENT_USER_MAPPING, "root.c", CURRENT_USER_MAPPING);
            newCS.updatePlacementRules();
            Assert.assertNull((Object)newCS.getQueue("root.c.a1"));
            RMApp app = MockRMAppSubmitter.submit(newMockRM, MockRMAppSubmissionData.Builder.createWithMemory(512L, newMockRM).withAppName("testAutoQueueCreationWhenQueueExistsWithSameName").withUser("a1").withQueue("default").build());
            RMAppAttempt attempt = MockRM.waitForAttemptScheduled(app, newMockRM);
            Assert.assertNotNull((Object)newCS.getQueue("root.c.a1"));
            Assert.assertEquals((Object)"root.c.a1", (Object)app.getQueue());
        }
        finally {
            if (newMockRM != null) {
                ((CapacityScheduler)newMockRM.getResourceScheduler()).stop();
                newMockRM.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreationFailsWhenParentCapacityExceeded() throws Exception {
        MockRM newMockRM = this.setupSchedulerInstance();
        CapacityScheduler newCS = (CapacityScheduler)newMockRM.getResourceScheduler();
        try {
            CapacitySchedulerConfiguration conf = newCS.getConfiguration();
            conf.setShouldFailAutoQueueCreationWhenGuaranteedCapacityExceeded("root.c", true);
            newCS.reinitialize((Configuration)conf, newMockRM.getRMContext());
            ManagedParentQueue parentQueue = (ManagedParentQueue)newCS.getQueue("c");
            AutoCreatedLeafQueue c1 = new AutoCreatedLeafQueue(newCS.getQueueContext(), "c1", parentQueue);
            newCS.addQueue((Queue)c1);
            c1.setCapacity(0.5f);
            c1.setAbsoluteCapacity(c1.getParent().getAbsoluteCapacity() * 1.0f);
            c1.setMaxCapacity(1.0f);
            this.setEntitlement(c1, new QueueEntitlement(0.5f, 1.0f));
            AutoCreatedLeafQueue c2 = new AutoCreatedLeafQueue(newCS.getQueueContext(), "c2", parentQueue);
            newCS.addQueue((Queue)c2);
            this.setEntitlement(c2, new QueueEntitlement(0.5f, 1.0f));
            try {
                AutoCreatedLeafQueue c3 = new AutoCreatedLeafQueue(newCS.getQueueContext(), "c3", parentQueue);
                newCS.addQueue((Queue)c3);
                Assert.fail((String)"Expected exception for auto queue creation failure");
            }
            catch (SchedulerDynamicEditException schedulerDynamicEditException) {
                // empty catch block
            }
        }
        finally {
            if (newMockRM != null) {
                ((CapacityScheduler)newMockRM.getResourceScheduler()).stop();
                newMockRM.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreatedQueueActivationDeactivation() throws Exception {
        try {
            CSQueue parentQueue = this.cs.getQueue("c");
            ApplicationId user1AppId = this.submitApp(this.mockRM, parentQueue, "user_1", "user_1", 1, 1);
            Map<String, Float> expectedAbsChildQueueCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(1);
            this.validateInitialQueueEntitlement(parentQueue, "user_1", expectedAbsChildQueueCapacity, accessibleNodeLabelsOnC);
            ApplicationId user2AppId = this.submitApp(this.mockRM, parentQueue, "user_2", "user_2", 2, 1);
            expectedAbsChildQueueCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(2);
            this.validateInitialQueueEntitlement(parentQueue, "user_2", expectedAbsChildQueueCapacity, accessibleNodeLabelsOnC);
            this.submitApp(this.mockRM, parentQueue, "user_1", "user_1", 3, 2);
            GuaranteedOrZeroCapacityOverTimePolicy autoCreatedQueueManagementPolicy = (GuaranteedOrZeroCapacityOverTimePolicy)((ManagedParentQueue)parentQueue).getAutoCreatedQueueManagementPolicy();
            for (String nodeLabel : accessibleNodeLabelsOnC) {
                Assert.assertEquals((float)expectedAbsChildQueueCapacity.get(nodeLabel).floatValue(), (float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(nodeLabel), (float)0.001f);
            }
            this.submitApp(this.mockRM, parentQueue, "user_3", "user_3", 4, 1);
            CSQueue user3LeafQueue = this.cs.getQueue("user_3");
            this.validateCapacities((AutoCreatedLeafQueue)user3LeafQueue, 0.0f, 0.0f, 1.0f, 1.0f);
            this.validateCapacitiesByLabel((ManagedParentQueue)parentQueue, (AutoCreatedLeafQueue)user3LeafQueue, "GPU");
            Assert.assertEquals((float)0.2f, (float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(""), (float)0.001f);
            Assert.assertEquals((float)0.9f, (float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity("GPU"), (float)0.001f);
            MockRM.launchAM((RMApp)this.mockRM.getRMContext().getRMApps().get(user1AppId), this.mockRM, this.nm1);
            this.cs.killAllAppsInQueue("user_2");
            this.mockRM.waitForState(user2AppId, RMAppState.KILLED);
            List queueManagementChanges = autoCreatedQueueManagementPolicy.computeQueueManagementChanges();
            ManagedParentQueue managedParentQueue = (ManagedParentQueue)parentQueue;
            managedParentQueue.validateAndApplyQueueManagementChanges(queueManagementChanges);
            this.validateDeactivatedQueueEntitlement(parentQueue, "user_2", expectedAbsChildQueueCapacity, queueManagementChanges);
            HashSet<String> expectedNodeLabelsUpdated = new HashSet<String>();
            expectedNodeLabelsUpdated.add("");
            expectedNodeLabelsUpdated.add("SSD");
            this.validateActivatedQueueEntitlement(parentQueue, "user_3", expectedAbsChildQueueCapacity, queueManagementChanges, expectedNodeLabelsUpdated);
        }
        finally {
            this.cleanupQueue("user_1");
            this.cleanupQueue("user_2");
            this.cleanupQueue("user_3");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterResourceUpdationOnAutoCreatedLeafQueues() throws Exception {
        MockRM newMockRM = this.setupSchedulerInstance();
        try {
            CapacityScheduler newCS = (CapacityScheduler)newMockRM.getResourceScheduler();
            CSQueue parentQueue = newCS.getQueue("c");
            this.submitApp(newMockRM, parentQueue, "user_1", "user_1", 1, 1);
            Map<String, Float> expectedAbsChildQueueCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(1);
            this.validateInitialQueueEntitlement(newMockRM, newCS, parentQueue, "user_1", expectedAbsChildQueueCapacity, accessibleNodeLabelsOnC);
            ApplicationId user2AppId = this.submitApp(newMockRM, parentQueue, "user_2", "user_2", 2, 1);
            expectedAbsChildQueueCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(2);
            this.validateInitialQueueEntitlement(newMockRM, newCS, parentQueue, "user_2", expectedAbsChildQueueCapacity, accessibleNodeLabelsOnC);
            GuaranteedOrZeroCapacityOverTimePolicy autoCreatedQueueManagementPolicy = (GuaranteedOrZeroCapacityOverTimePolicy)((ManagedParentQueue)parentQueue).getAutoCreatedQueueManagementPolicy();
            Assert.assertEquals((float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(""), (float)0.2f, (float)0.001f);
            this.submitApp(newMockRM, parentQueue, "user_3", "user_3", 3, 1);
            CSQueue user3LeafQueue = newCS.getQueue("user_3");
            this.validateCapacities((AutoCreatedLeafQueue)user3LeafQueue, 0.0f, 0.0f, 1.0f, 1.0f);
            Assert.assertEquals((float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(""), (float)0.2f, (float)0.001f);
            newMockRM.registerNode("127.0.0.3:1234", 128000, 20);
            Resource MAX_RES = Resources.addTo((Resource)TEMPLATE_MAX_RES, (Resource)Resources.createResource((int)128000, (int)20));
            Resource MIN_RES = Resources.createResource((int)14438, (int)6);
            Assert.assertEquals((String)"Effective Min resource for USER3 is not correct", (Object)Resources.none(), (Object)user3LeafQueue.getQueueResourceQuotas().getEffectiveMinResource());
            Assert.assertEquals((String)"Effective Max resource for USER3 is not correct", (Object)MAX_RES, (Object)user3LeafQueue.getQueueResourceQuotas().getEffectiveMaxResource());
            CSQueue user1LeafQueue = newCS.getQueue("user_1");
            CSQueue user2LeafQueue = newCS.getQueue("user_2");
            Assert.assertEquals((String)"Effective Min resource for USER2 is not correct", (Object)MIN_RES, (Object)user1LeafQueue.getQueueResourceQuotas().getEffectiveMinResource());
            Assert.assertEquals((String)"Effective Max resource for USER2 is not correct", (Object)MAX_RES, (Object)user1LeafQueue.getQueueResourceQuotas().getEffectiveMaxResource());
            Assert.assertEquals((String)"Effective Min resource for USER1 is not correct", (Object)MIN_RES, (Object)user2LeafQueue.getQueueResourceQuotas().getEffectiveMinResource());
            Assert.assertEquals((String)"Effective Max resource for USER1 is not correct", (Object)MAX_RES, (Object)user2LeafQueue.getQueueResourceQuotas().getEffectiveMaxResource());
            newMockRM.unRegisterNode(this.nm3);
            Resource MIN_RES_UPDATED = Resources.createResource((int)12800, (int)2);
            Resource MAX_RES_UPDATED = Resources.createResource((int)128000, (int)20);
            Assert.assertEquals((String)"Effective Min resource for USER2 is not correct", (Object)MIN_RES_UPDATED, (Object)user1LeafQueue.getQueueResourceQuotas().getEffectiveMinResource());
            Assert.assertEquals((String)"Effective Max resource for USER2 is not correct", (Object)MAX_RES_UPDATED, (Object)user2LeafQueue.getQueueResourceQuotas().getEffectiveMaxResource());
        }
        finally {
            this.cleanupQueue("user_1");
            this.cleanupQueue("user_2");
            this.cleanupQueue("user_3");
            if (newMockRM != null) {
                ((CapacityScheduler)newMockRM.getResourceScheduler()).stop();
                newMockRM.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReinitializeQueuesWithAutoCreatedLeafQueues() throws Exception {
        MockRM newMockRM = this.setupSchedulerInstance();
        try {
            CapacityScheduler newCS = (CapacityScheduler)newMockRM.getResourceScheduler();
            CapacitySchedulerConfiguration conf = newCS.getConfiguration();
            CSQueue parentQueue = newCS.getQueue("c");
            this.submitApp(newMockRM, parentQueue, "user_1", "user_1", 1, 1);
            Map<String, Float> expectedChildQueueAbsCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(1);
            this.validateInitialQueueEntitlement(newMockRM, newCS, parentQueue, "user_1", expectedChildQueueAbsCapacity, accessibleNodeLabelsOnC);
            ApplicationId user2AppId = this.submitApp(newMockRM, parentQueue, "user_2", "user_2", 2, 1);
            expectedChildQueueAbsCapacity = this.populateExpectedAbsCapacityByLabelForParentQueue(2);
            this.validateInitialQueueEntitlement(newMockRM, newCS, parentQueue, "user_2", expectedChildQueueAbsCapacity, accessibleNodeLabelsOnC);
            conf.setCapacity("root.c", 30.0f);
            conf.setCapacity("root.d", 10.0f);
            conf.setMaximumCapacity("root.c", 50.0f);
            newCS.reinitialize((Configuration)conf, newMockRM.getRMContext());
            AutoCreatedLeafQueue user0Queue = (AutoCreatedLeafQueue)newCS.getQueue("user_1");
            this.validateCapacities(user0Queue, 0.5f, 0.15f, 1.0f, 0.5f);
            int maxApps = this.cs.getConfiguration().isLegacyQueueMode() ? 4000 : 3999;
            this.validateUserAndAppLimits(user0Queue, maxApps, maxApps);
            conf.setAutoCreatedLeafQueueConfigCapacity("root.c", 30.0f);
            conf.setAutoCreatedLeafQueueConfigMaxCapacity("root.c", 40.0f);
            newCS.reinitialize((Configuration)conf, newMockRM.getRMContext());
            this.validateCapacities(user0Queue, 0.3f, 0.09f, 0.4f, 0.2f);
            this.validateUserAndAppLimits(user0Queue, maxApps, maxApps);
            this.submitApp(newMockRM, parentQueue, "user_3", "user_3", 3, 1);
            AutoCreatedLeafQueue user3Queue = (AutoCreatedLeafQueue)newCS.getQueue("user_1");
            this.validateCapacities(user3Queue, 0.3f, 0.09f, 0.4f, 0.2f);
            this.validateUserAndAppLimits(user3Queue, maxApps, maxApps);
            this.submitApp(newMockRM, parentQueue, "user_3", "user_3", 4, 2);
            this.validateCapacities(user3Queue, 0.3f, 0.09f, 0.4f, 0.2f);
            this.validateUserAndAppLimits(user3Queue, maxApps, maxApps);
            this.validateContainerLimits(user3Queue, 6, 10240L);
            GuaranteedOrZeroCapacityOverTimePolicy autoCreatedQueueManagementPolicy = (GuaranteedOrZeroCapacityOverTimePolicy)((ManagedParentQueue)parentQueue).getAutoCreatedQueueManagementPolicy();
            Assert.assertEquals((float)0.27f, (float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(""), (float)0.001f);
        }
        finally {
            this.cleanupQueue("user_1");
            this.cleanupQueue("user_2");
            if (newMockRM != null) {
                ((CapacityScheduler)newMockRM.getResourceScheduler()).stop();
                newMockRM.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicAutoQueueCreationWithTags() throws Exception {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
        this.mockRM = null;
        try {
            CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
            csConf.setQueues("root", new String[]{"a", "b"});
            csConf.setCapacity("root.a", 90.0f);
            csConf.setCapacity("root.b", 10.0f);
            csConf.setAutoCreateChildQueueEnabled("root.a", true);
            csConf.setAutoCreatedLeafQueueConfigCapacity("root.a", 50.0f);
            csConf.setAutoCreatedLeafQueueConfigMaxCapacity("root.a", 100.0f);
            csConf.setAcl("root.a", QueueACL.ADMINISTER_QUEUE, "*");
            csConf.setAcl("root.a", QueueACL.SUBMIT_APPLICATIONS, "*");
            csConf.setBoolean("yarn.resourcemanager.application-tag-based-placement.enable", true);
            csConf.setStrings("yarn.resourcemanager.application-tag-based-placement.username.whitelist", new String[]{"hadoop"});
            csConf.set("yarn.scheduler.capacity.queue-mappings", "u:%user:root.a.%user");
            final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
            mgr.init((Configuration)csConf);
            this.mockRM = new MockRM((Configuration)csConf){

                @Override
                public RMNodeLabelsManager createNodeLabelManager() {
                    return mgr;
                }
            };
            this.mockRM.start();
            MockNM nm = this.mockRM.registerNode("127.0.0.1:1234", 16384);
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.mockRM).withAppName("apptodynamicqueue").withUser("hadoop").withAcls(null).withUnmanagedAM(false).withApplicationTags(Sets.newHashSet((Object[])new String[]{"userid=testuser"})).build();
            RMApp app = MockRMAppSubmitter.submit(this.mockRM, data);
            MockRM.launchAndRegisterAM(app, this.mockRM, nm);
            nm.nodeHeartbeat(true);
            CapacityScheduler cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
            CSQueue queue = cs.getQueue("root.a.testuser");
            Assert.assertNotNull((String)"Leaf queue has not been auto-created", (Object)queue);
            Assert.assertEquals((String)"Number of running applications", (long)1L, (long)queue.getNumApplications());
        }
        finally {
            if (this.mockRM != null) {
                this.mockRM.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAutoCreateLeafQueueFailsWithSpecifiedEmptyStringLeafQueue() throws Exception {
        String invalidQueue = "";
        MockRM newMockRM = this.setupSchedulerInstance();
        CapacityScheduler newCS = (CapacityScheduler)newMockRM.getResourceScheduler();
        this.setupQueueMapping(newCS, "app_user", "root.c", SPECIFIED_QUEUE_MAPPING);
        newCS.updatePlacementRules();
        try {
            this.submitApp(newCS, "app_user", "", "root.c");
            RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
            Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)this.dispatcher);
            newCS.setRMContext(rmContext);
            ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
            AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "root.c.", "app_user");
            newCS.handle((SchedulerEvent)addAppEvent);
            RMAppEvent event = new RMAppEvent(appId, RMAppEventType.APP_REJECTED, "error");
            this.dispatcher.spyOnNextEvent((Event)event, 10000L);
        }
        finally {
            ((CapacityScheduler)newMockRM.getResourceScheduler()).stop();
            newMockRM.stop();
        }
    }
}

