/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.List;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AppPriorityACLGroup;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationPriorityACLConfiguration {
    private final int defaultPriorityQueueA = 3;
    private final int defaultPriorityQueueB = -1;
    private final int maxPriorityQueueA = 5;
    private final int maxPriorityQueueB = 10;
    private final int clusterMaxPriority = 10;
    private static final String QUEUE_A_USER = "queueA_user";
    private static final String QUEUE_B_USER = "queueB_user";
    private static final String QUEUE_A_GROUP = "queueA_group";
    private static final String QUEUEA = "queueA";
    private static final String QUEUEB = "queueB";
    private static final String QUEUEC = "queueC";

    @Test
    public void testSimpleACLConfiguration() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{QUEUEA, QUEUEB, QUEUEC});
        csConf.setCapacity("root.queueA", 50.0f);
        csConf.setCapacity("root.queueB", 25.0f);
        csConf.setCapacity("root.queueC", 25.0f);
        String[] aclsForA = new String[]{QUEUE_A_USER, QUEUE_A_GROUP};
        csConf.setPriorityAcls("root.queueA", Priority.newInstance((int)5), Priority.newInstance((int)3), aclsForA);
        List pGroupA = csConf.getPriorityAcls("root.queueA", Priority.newInstance((int)10));
        this.verifyACLs(pGroupA, QUEUE_A_USER, QUEUE_A_GROUP, 5, 3);
    }

    @Test
    public void testACLConfigurationForInvalidCases() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{QUEUEA, QUEUEB, QUEUEC});
        csConf.setCapacity("root.queueA", 50.0f);
        csConf.setCapacity("root.queueB", 25.0f);
        csConf.setCapacity("root.queueC", 25.0f);
        String[] aclsForA = new String[]{QUEUE_A_USER, QUEUE_A_GROUP};
        csConf.setPriorityAcls("root.queueA", Priority.newInstance((int)5), Priority.newInstance((int)3), aclsForA);
        String[] aclsForB = new String[]{QUEUE_B_USER};
        csConf.setPriorityAcls("root.queueB", Priority.newInstance((int)10), Priority.newInstance((int)-1), aclsForB);
        List pGroupA = csConf.getPriorityAcls("root.queueA", Priority.newInstance((int)10));
        List pGroupB = csConf.getPriorityAcls("root.queueB", Priority.newInstance((int)10));
        this.verifyACLs(pGroupA, QUEUE_A_USER, QUEUE_A_GROUP, 5, 3);
        this.verifyACLs(pGroupB, QUEUE_B_USER, "", 10, 0);
    }

    private void verifyACLs(List<AppPriorityACLGroup> pGroup, String queueUser, String queueGroup, int maxPriority, int defaultPriority) {
        AppPriorityACLGroup group = pGroup.get(0);
        String aclString = queueUser + " " + queueGroup;
        Assert.assertEquals((Object)aclString.trim(), (Object)group.getACLList().getAclString().trim());
        Assert.assertEquals((long)maxPriority, (long)group.getMaxPriority().getPriority());
        Assert.assertEquals((long)defaultPriority, (long)group.getDefaultPriority().getPriority());
    }
}

