/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resourcetracker;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMNMRPCResponseId {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    ResourceTrackerService resourceTrackerService;
    private NodeId nodeId;

    @Before
    public void setUp() {
        Configuration conf = new Configuration();
        InlineDispatcher dispatcher = new InlineDispatcher();
        dispatcher.register(SchedulerEventType.class, (EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        RMContextImpl context = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, new RMContainerTokenSecretManager(conf), new NMTokenSecretManagerInRM(conf), null, null);
        dispatcher.register(RMNodeEventType.class, (EventHandler)new ResourceManager.NodeEventDispatcher((RMContext)context));
        NodesListManager nodesListManager = new NodesListManager((RMContext)context);
        nodesListManager.init(conf);
        context.getContainerTokenSecretManager().rollMasterKey();
        context.getNMTokenSecretManager().rollMasterKey();
        this.resourceTrackerService = new ResourceTrackerService((RMContext)context, nodesListManager, new NMLivelinessMonitor((Dispatcher)dispatcher), context.getContainerTokenSecretManager(), context.getNMTokenSecretManager());
        this.resourceTrackerService.init(conf);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testRPCResponseId() throws IOException, YarnException {
        String node = "localhost";
        Resource capability = Resources.createResource((int)1024);
        RegisterNodeManagerRequest request = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        this.nodeId = NodeId.newInstance((String)node, (int)1234);
        request.setNodeId(this.nodeId);
        request.setHttpPort(0);
        request.setResource(capability);
        RegisterNodeManagerRequest request1 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        request1.setNodeId(this.nodeId);
        request1.setHttpPort(0);
        request1.setResource(capability);
        this.resourceTrackerService.registerNodeManager(request1);
        NodeStatus nodeStatus = (NodeStatus)recordFactory.newRecordInstance(NodeStatus.class);
        nodeStatus.setNodeId(this.nodeId);
        NodeHealthStatus nodeHealthStatus = (NodeHealthStatus)recordFactory.newRecordInstance(NodeHealthStatus.class);
        nodeHealthStatus.setIsNodeHealthy(true);
        nodeStatus.setNodeHealthStatus(nodeHealthStatus);
        NodeHeartbeatRequest nodeHeartBeatRequest = (NodeHeartbeatRequest)recordFactory.newRecordInstance(NodeHeartbeatRequest.class);
        nodeHeartBeatRequest.setNodeStatus(nodeStatus);
        nodeStatus.setResponseId(0);
        NodeHeartbeatResponse response = this.resourceTrackerService.nodeHeartbeat(nodeHeartBeatRequest);
        Assert.assertTrue((response.getResponseId() == 1 ? 1 : 0) != 0);
        nodeStatus.setResponseId(response.getResponseId());
        response = this.resourceTrackerService.nodeHeartbeat(nodeHeartBeatRequest);
        Assert.assertTrue((response.getResponseId() == 2 ? 1 : 0) != 0);
        response = this.resourceTrackerService.nodeHeartbeat(nodeHeartBeatRequest);
        Assert.assertTrue((response.getResponseId() == 2 ? 1 : 0) != 0);
        nodeStatus.setResponseId(0);
        response = this.resourceTrackerService.nodeHeartbeat(nodeHeartBeatRequest);
        Assert.assertTrue((boolean)NodeAction.RESYNC.equals((Object)response.getNodeAction()));
        Assert.assertEquals((Object)"Too far behind rm response id:2 nm response id:0", (Object)response.getDiagnosticsMessage());
    }
}

