/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyIntraQueueWithDRF
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", true);
        this.resourceCalculator = new DominantResourceCalculator();
        Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testSimpleIntraQueuePreemptionWithVCoreResource() throws IOException {
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100:50,true;";
        String nodesConfig = "n1= res=100:50";
        String queuesConfig = "root(=[100:50 100:50 80:40 120:60 0]);-a(=[10:5 100:50 10:5 50:25 0]);-b(=[40:20 100:50 40:20 60:30 0]);-c(=[20:10 100:50 10:5 10:5 0]);-d(=[30:15 100:50 20:10 0 0])";
        String appsConfig = "a\t(1,1:1,n1,,5,false,25:25);a\t(1,1:1,n1,,5,false,25:25);b\t(4,1:1,n1,,36,false,20:20);b\t(4,1:1,n1,,2,false,10:10);b\t(5,1:1,n1,,1,false,10:10);b\t(6,1:1,n1,,1,false,10:10);c\t(1,1:1,n1,,10,false,10:10);d\t(1,1:1,n1,,20,false,0)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testIntraQueuePreemptionFairOrderingWithStrictAndRelaxedDRF() throws IOException {
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "userlimit_first");
        this.conf.set("yarn.scheduler.capacity.root.b.ordering-policy", "fair");
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.conservative-drf", true);
        String labelsConfig = "=61440:600,true;";
        String nodesConfig = "n1= res=61440:600";
        String queuesConfig = "root(=[61440:600 61440:600 61440:600 30720:30 0]);-a(=[30720:300 61440:600 0:0 0:0 0]);-b(=[30720:300 61440:600 61440:60 30720:30 0]);";
        String appsConfig = "b\t(1,1024:1,n1,,60,false,0:0,user1);b\t(1,0:0,n1,,0,false,30720:30,user3);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        Resource ul = Resource.newInstance((int)30720, (int)300);
        Mockito.when((Object)((LeafQueue)this.cs.getQueue("root.b")).getResourceLimitForAllUsers((String)ArgumentMatchers.any(), (Resource)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SchedulingMode)ArgumentMatchers.any())).thenReturn((Object)ul);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)6))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.conservative-drf", false);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        Mockito.when((Object)((LeafQueue)this.cs.getQueue("root.b")).getResourceLimitForAllUsers((String)ArgumentMatchers.any(), (Resource)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SchedulingMode)ArgumentMatchers.any())).thenReturn((Object)ul);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)29))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testIntraQueuePreemptionFairOrdering3ResourcesWithStrictAndRelaxedDRF() throws IOException {
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "userlimit_first");
        this.conf.set("yarn.scheduler.capacity.root.b.ordering-policy", "fair");
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.conservative-drf", true);
        String RESOURCE_1 = "res1";
        this.riMap.put(RESOURCE_1, ResourceInformation.newInstance((String)RESOURCE_1, (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Integer.MAX_VALUE));
        ResourceUtils.initializeResourcesFromResourceInformationMap((Map)this.riMap);
        String labelsConfig = "=61440:600,true;";
        String nodesConfig = "n1= res=61440:600";
        String queuesConfig = "root(=[61440:600 61440:600 61440:600 30720:30 0]);-a(=[30720:300 61440:600 0:0 0:0 0]);-b(=[30720:300 61440:600 61440:60 30720:30 0]);";
        String appsConfig = "b\t(1,1024:1,n1,,60,false,0:0,user1);b\t(1,0:0,n1,,0,false,30720:30,user3);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        Resource ul = Resource.newInstance((int)30720, (int)300);
        Mockito.when((Object)((LeafQueue)this.cs.getQueue("root.b")).getResourceLimitForAllUsers((String)ArgumentMatchers.any(), (Resource)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SchedulingMode)ArgumentMatchers.any())).thenReturn((Object)ul);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)0))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        Mockito.reset((Object[])new EventHandler[]{this.eventHandler});
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.conservative-drf", false);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        Mockito.when((Object)((LeafQueue)this.cs.getQueue("root.b")).getResourceLimitForAllUsers((String)ArgumentMatchers.any(), (Resource)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SchedulingMode)ArgumentMatchers.any())).thenReturn((Object)ul);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)29))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testIntraQueuePreemptionWithDominantVCoreResource() throws IOException {
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100:200,true;";
        String nodesConfig = "n1= res=100:200";
        String queuesConfig = "root(=[100:50 100:50 50:40 110:60 0]);-a(=[40:20 100:50 9:9 50:30 0]);-b(=[60:30 100:50 40:30 60:30 0]);";
        String appsConfig = "a\t(1,2:1,n1,,4,false,25:25);a\t(1,1:3,n1,,2,false,25:25);b\t(4,2:1,n1,,10,false,20:20);b\t(4,1:2,n1,,5,false,10:10);b\t(5,1:1,n1,,5,false,30:20);b\t(6,2:1,n1,,5,false,30:20);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)9))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)4))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)4))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(5))));
    }
}

