/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.FairSchedulerPage;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMWebAppFairScheduler {
    @Test
    public void testFairSchedulerWebAppPage() {
        List<RMAppState> appStates = Arrays.asList(RMAppState.NEW, RMAppState.NEW_SAVING, RMAppState.SUBMITTED);
        final RMContext rmContext = TestRMWebAppFairScheduler.mockRMContext(appStates);
        Injector injector = WebAppTests.createMockInjector(RMContext.class, (Object)rmContext, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    ResourceManager mockRmWithFairScheduler = TestRMWebAppFairScheduler.mockRm(rmContext);
                    binder.bind(ResourceManager.class).toInstance((Object)mockRmWithFairScheduler);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
        FairSchedulerPage fsViewInstance = (FairSchedulerPage)injector.getInstance(FairSchedulerPage.class);
        fsViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    public void testFairSchedulerWebAppPageInInconsistentState() {
        List<RMAppState> appStates = Arrays.asList(RMAppState.NEW, RMAppState.NEW_SAVING, RMAppState.SUBMITTED, RMAppState.RUNNING, RMAppState.FINAL_SAVING, RMAppState.ACCEPTED, RMAppState.FINISHED);
        final RMContext rmContext = TestRMWebAppFairScheduler.mockRMContext(appStates);
        Injector injector = WebAppTests.createMockInjector(RMContext.class, (Object)rmContext, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    ResourceManager mockRmWithFairScheduler = TestRMWebAppFairScheduler.mockRmWithApps(rmContext);
                    binder.bind(ResourceManager.class).toInstance((Object)mockRmWithFairScheduler);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
        FairSchedulerPage fsViewInstance = (FairSchedulerPage)injector.getInstance(FairSchedulerPage.class);
        try {
            fsViewInstance.render();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to render FairSchedulerPage: " + StringUtils.stringifyException((Throwable)e)));
        }
        WebAppTests.flushOutput((Injector)injector);
    }

    private static RMContext mockRMContext(List<RMAppState> states) {
        final ConcurrentMap applicationsMaps = Maps.newConcurrentMap();
        int i = 0;
        for (RMAppState state : states) {
            MockRMApp app = new MockRMApp(i, i, state){

                @Override
                public RMAppMetrics getRMAppMetrics() {
                    return new RMAppMetrics(Resource.newInstance((int)0, (int)0), 0, 0, new HashMap(), new HashMap(), 0);
                }

                @Override
                public YarnApplicationState createApplicationState() {
                    return YarnApplicationState.ACCEPTED;
                }
            };
            RMAppAttempt attempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
            app.setCurrentAppAttempt(attempt);
            applicationsMaps.put(app.getApplicationId(), app);
            ++i;
        }
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, null, null, null, null){

            public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
                return applicationsMaps;
            }

            public ResourceScheduler getScheduler() {
                return (ResourceScheduler)Mockito.mock(AbstractYarnScheduler.class);
            }
        };
        return rmContext;
    }

    private static ResourceManager mockRm(RMContext rmContext) throws IOException {
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        FairScheduler rs = TestRMWebAppFairScheduler.mockFairScheduler();
        ClientRMService clientRMService = TestRMWebAppFairScheduler.mockClientRMService(rmContext);
        Mockito.when((Object)rm.getResourceScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        Mockito.when((Object)rm.getClientRMService()).thenReturn((Object)clientRMService);
        return rm;
    }

    private static FairScheduler mockFairScheduler() throws IOException {
        FairScheduler fs = new FairScheduler();
        FairSchedulerConfiguration conf = new FairSchedulerConfiguration();
        fs.setRMContext((RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null));
        fs.init((Configuration)conf);
        return fs;
    }

    private static ResourceManager mockRmWithApps(RMContext rmContext) throws IOException {
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        FairScheduler rs = TestRMWebAppFairScheduler.mockFairSchedulerWithoutApps(rmContext);
        ClientRMService clientRMService = TestRMWebAppFairScheduler.mockClientRMService(rmContext);
        Mockito.when((Object)rm.getResourceScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        Mockito.when((Object)rm.getClientRMService()).thenReturn((Object)clientRMService);
        return rm;
    }

    private static FairScheduler mockFairSchedulerWithoutApps(RMContext rmContext) throws IOException {
        FairScheduler fs = new FairScheduler(){

            public FSAppAttempt getSchedulerApp(ApplicationAttemptId applicationAttemptId) {
                return null;
            }

            public FSAppAttempt getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
                return null;
            }
        };
        FairSchedulerConfiguration conf = new FairSchedulerConfiguration();
        fs.setRMContext(rmContext);
        fs.init((Configuration)conf);
        return fs;
    }

    public static ClientRMService mockClientRMService(RMContext rmContext) {
        return (ClientRMService)Mockito.mock(ClientRMService.class);
    }
}

