/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicyWithExclusivePartitions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.IteratorSelector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.MockSchedulableEntity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.junit.Assert;
import org.junit.Test;

public class TestFifoOrderingPolicyWithExclusivePartitions {
    private static final String PARTITION = "test";
    private static final String PARTITION2 = "test2";

    @Test
    public void testNoConfiguredExclusiveEnforcedPartitions() {
        FifoOrderingPolicyWithExclusivePartitions policy = new FifoOrderingPolicyWithExclusivePartitions();
        policy.configure(Collections.EMPTY_MAP);
        MockSchedulableEntity p1 = new MockSchedulableEntity(4L, 0, false);
        p1.setPartition(PARTITION);
        p1.setId("p1");
        MockSchedulableEntity p2 = new MockSchedulableEntity(3L, 1, false);
        p2.setPartition(PARTITION);
        p2.setId("p2");
        MockSchedulableEntity r1 = new MockSchedulableEntity(2L, 0, false);
        r1.setId("r1");
        MockSchedulableEntity r2 = new MockSchedulableEntity(1L, 0, false);
        r2.setId("r2");
        policy.addSchedulableEntity((SchedulableEntity)p1);
        policy.addAllSchedulableEntities(Arrays.asList(p2, r1, r2));
        Assert.assertEquals((long)4L, (long)policy.getNumSchedulableEntities());
        Assert.assertEquals((long)4L, (long)policy.getSchedulableEntities().size());
        IteratorSelector sel = new IteratorSelector();
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, IteratorSelector.EMPTY_ITERATOR_SELECTOR, "p2", "r2", "r1", "p1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "p1", "r1", "r2", "p2");
        sel.setPartition(PARTITION);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, "p2", "r2", "r1", "p1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "p1", "r1", "r2", "p2");
        policy.removeSchedulableEntity((SchedulableEntity)p2);
        policy.removeSchedulableEntity((SchedulableEntity)r2);
        Assert.assertEquals((long)2L, (long)policy.getNumSchedulableEntities());
        Assert.assertEquals((long)2L, (long)policy.getSchedulableEntities().size());
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, IteratorSelector.EMPTY_ITERATOR_SELECTOR, "r1", "p1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "p1", "r1");
        sel.setPartition(PARTITION);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, "r1", "p1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "p1", "r1");
    }

    @Test
    public void testSingleExclusiveEnforcedPartition() {
        FifoOrderingPolicyWithExclusivePartitions policy = new FifoOrderingPolicyWithExclusivePartitions();
        policy.configure(Collections.singletonMap("exclusive-enforced-partitions", PARTITION));
        MockSchedulableEntity p1 = new MockSchedulableEntity(1L, 0, false);
        p1.setPartition(PARTITION);
        p1.setId("p1");
        MockSchedulableEntity p2 = new MockSchedulableEntity(5L, 1, false);
        p2.setPartition(PARTITION);
        p2.setId("p2");
        MockSchedulableEntity p3 = new MockSchedulableEntity(3L, 0, false);
        p3.setPartition(PARTITION);
        p3.setId("p3");
        MockSchedulableEntity r1 = new MockSchedulableEntity(6L, 0, false);
        r1.setId("r1");
        MockSchedulableEntity r2 = new MockSchedulableEntity(4L, 0, false);
        r2.setId("r2");
        MockSchedulableEntity r3 = new MockSchedulableEntity(2L, 1, false);
        r3.setId("r3");
        policy.addSchedulableEntity((SchedulableEntity)r1);
        Assert.assertEquals((long)1L, (long)policy.getNumSchedulableEntities());
        Assert.assertEquals((Object)"r1", (Object)((MockSchedulableEntity)policy.getSchedulableEntities().iterator().next()).getId());
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, IteratorSelector.EMPTY_ITERATOR_SELECTOR, "r1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "r1");
        List<MockSchedulableEntity> entities = Arrays.asList(r2, r3, p1, p2);
        policy.addAllSchedulableEntities(entities);
        policy.addSchedulableEntity((SchedulableEntity)p3);
        Assert.assertEquals((long)6L, (long)policy.getNumSchedulableEntities());
        Assert.assertEquals((long)6L, (long)policy.getSchedulableEntities().size());
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, IteratorSelector.EMPTY_ITERATOR_SELECTOR, "r3", "r2", "r1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "r1", "r2", "p3", "p1", "p2", "r3");
        IteratorSelector sel = new IteratorSelector();
        sel.setPartition("dummy");
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, "r3", "r2", "r1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "r1", "r2", "p3", "p1", "p2", "r3");
        sel.setPartition(PARTITION);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, "p2", "p1", "p3");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "r1", "r2", "p3", "p1", "p2", "r3");
        policy.removeSchedulableEntity((SchedulableEntity)p2);
        policy.removeSchedulableEntity((SchedulableEntity)r2);
        Assert.assertEquals((long)4L, (long)policy.getNumSchedulableEntities());
        Assert.assertEquals((long)4L, (long)policy.getSchedulableEntities().size());
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, IteratorSelector.EMPTY_ITERATOR_SELECTOR, "r3", "r1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "r1", "p3", "p1", "r3");
        sel.setPartition(PARTITION);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, "p1", "p3");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "r1", "p3", "p1", "r3");
        policy.removeSchedulableEntity((SchedulableEntity)p1);
        policy.removeSchedulableEntity((SchedulableEntity)p3);
        Assert.assertEquals((long)2L, (long)policy.getNumSchedulableEntities());
        Assert.assertEquals((long)2L, (long)policy.getSchedulableEntities().size());
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, IteratorSelector.EMPTY_ITERATOR_SELECTOR, "r3", "r1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "r1", "r3");
        sel.setPartition(PARTITION);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, new String[0]);
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "r1", "r3");
    }

    @Test
    public void testMultipleExclusiveEnforcedPartitions() {
        FifoOrderingPolicyWithExclusivePartitions policy = new FifoOrderingPolicyWithExclusivePartitions();
        policy.configure(Collections.singletonMap("exclusive-enforced-partitions", "test,test2"));
        MockSchedulableEntity p1 = new MockSchedulableEntity(1L, 0, false);
        p1.setPartition(PARTITION);
        p1.setId("p1");
        MockSchedulableEntity p2 = new MockSchedulableEntity(5L, 1, false);
        p2.setPartition(PARTITION);
        p2.setId("p2");
        MockSchedulableEntity r1 = new MockSchedulableEntity(3L, 0, false);
        r1.setPartition(PARTITION2);
        r1.setId("r1");
        MockSchedulableEntity r2 = new MockSchedulableEntity(4L, 0, false);
        r2.setPartition(PARTITION2);
        r2.setId("r2");
        MockSchedulableEntity s1 = new MockSchedulableEntity(6L, 0, false);
        s1.setId("s1");
        MockSchedulableEntity s2 = new MockSchedulableEntity(2L, 0, false);
        s2.setId("s2");
        policy.addAllSchedulableEntities(Arrays.asList(s1, s2, r1));
        Assert.assertEquals((long)3L, (long)policy.getNumSchedulableEntities());
        Assert.assertEquals((long)3L, (long)policy.getSchedulableEntities().size());
        IteratorSelector sel = new IteratorSelector();
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, IteratorSelector.EMPTY_ITERATOR_SELECTOR, "s2", "s1");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "s1", "r1", "s2");
        sel.setPartition(PARTITION2);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, "r1");
        policy.addAllSchedulableEntities(Arrays.asList(r2, p1, p2));
        Assert.assertEquals((long)6L, (long)policy.getNumSchedulableEntities());
        Assert.assertEquals((long)6L, (long)policy.getSchedulableEntities().size());
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, IteratorSelector.EMPTY_ITERATOR_SELECTOR, "s2", "s1");
        sel.setPartition(PARTITION);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, "p2", "p1");
        sel.setPartition(PARTITION2);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, "r1", "r2");
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "s1", "r2", "r1", "s2", "p1", "p2");
        policy.removeSchedulableEntity((SchedulableEntity)p2);
        policy.removeSchedulableEntity((SchedulableEntity)r1);
        policy.removeSchedulableEntity((SchedulableEntity)r2);
        Assert.assertEquals((long)3L, (long)policy.getNumSchedulableEntities());
        Assert.assertEquals((long)3L, (long)policy.getSchedulableEntities().size());
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, IteratorSelector.EMPTY_ITERATOR_SELECTOR, "s2", "s1");
        sel.setPartition(PARTITION);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, "p1");
        sel.setPartition(PARTITION2);
        this.verifyAssignmentIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, sel, new String[0]);
        this.verifyPreemptionIteratorOrder((FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity>)policy, "s1", "s2", "p1");
    }

    private void verifyAssignmentIteratorOrder(FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity> policy, IteratorSelector sel, String ... ids) {
        this.verifyIteratorOrder(policy.getAssignmentIterator(sel), ids);
    }

    private void verifyPreemptionIteratorOrder(FifoOrderingPolicyWithExclusivePartitions<MockSchedulableEntity> policy, String ... ids) {
        this.verifyIteratorOrder(policy.getPreemptionIterator(), ids);
    }

    private void verifyIteratorOrder(Iterator<MockSchedulableEntity> itr, String ... ids) {
        for (String id : ids) {
            Assert.assertEquals((Object)id, (Object)itr.next().getId());
        }
        Assert.assertFalse((boolean)itr.hasNext());
    }
}

