/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.WeightConverterTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.WeightToWeightConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWeightToWeightConverter
extends WeightConverterTestBase {
    private WeightToWeightConverter converter;
    private CapacitySchedulerConfiguration csConfig;

    @Before
    public void setup() {
        this.converter = new WeightToWeightConverter();
        this.csConfig = new CapacitySchedulerConfiguration(new Configuration(false));
    }

    @Test
    public void testNoChildQueueConversion() {
        FSQueue root = this.createFSQueues(new int[0]);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertEquals((String)"root weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight("root"), (float)0.0f);
        Assert.assertEquals((String)"Converted items", (long)23L, (long)this.csConfig.getPropsWithPrefix("yarn.scheduler.capacity.").size());
    }

    @Test
    public void testSingleWeightConversion() {
        FSQueue root = this.createFSQueues(1);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertEquals((String)"root weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight("root"), (float)0.0f);
        Assert.assertEquals((String)"root.a weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight("root.a"), (float)0.0f);
        Assert.assertEquals((String)"Number of properties", (long)24L, (long)this.csConfig.getPropsWithPrefix("yarn.scheduler.capacity.").size());
    }

    @Test
    public void testMultiWeightConversion() {
        FSQueue root = this.createFSQueues(1, 2, 3);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertEquals((String)"Number of properties", (long)26L, (long)this.csConfig.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertEquals((String)"root weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight("root"), (float)0.0f);
        Assert.assertEquals((String)"root.a weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight("root.a"), (float)0.0f);
        Assert.assertEquals((String)"root.b weight", (float)2.0f, (float)this.csConfig.getNonLabeledQueueWeight("root.b"), (float)0.0f);
        Assert.assertEquals((String)"root.c weight", (float)3.0f, (float)this.csConfig.getNonLabeledQueueWeight("root.c"), (float)0.0f);
    }

    @Test
    public void testAutoCreateV2FlagOnParent() {
        FSQueue root = this.createFSQueues(1);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertTrue((String)"root autocreate v2 enabled", (boolean)this.csConfig.isAutoQueueCreationV2Enabled("root"));
    }

    @Test
    public void testAutoCreateV2FlagOnParentWithoutChildren() {
        FSParentQueue root = this.createParent(new ArrayList<FSQueue>());
        this.converter.convertWeightsForChildQueues((FSQueue)root, this.csConfig);
        Assert.assertEquals((String)"Number of properties", (long)23L, (long)this.csConfig.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertTrue((String)"root autocreate v2 enabled", (boolean)this.csConfig.isAutoQueueCreationV2Enabled("root"));
    }
}

