/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueHelpers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerTestUtilities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCapacitySchedulerApps {
    public static final int MAX_PARALLEL_APPS = 5;
    public static final String USER_0 = "user_0";
    private ResourceManager resourceManager = null;
    private RMContext mockContext;

    @Before
    public void setUp() throws Exception {
        this.resourceManager = CapacitySchedulerTestUtilities.createResourceManager();
        this.mockContext = CapacitySchedulerTestUtilities.createMockRMContext();
    }

    @After
    public void tearDown() throws Exception {
        CapacitySchedulerTestUtilities.stopResourceManager(this.resourceManager);
    }

    @Test
    public void testGetAppsInQueue() throws Exception {
        Application application0 = new Application(USER_0, "a1", this.resourceManager);
        application0.submit();
        Application application1 = new Application(USER_0, "a2", this.resourceManager);
        application1.submit();
        Application application2 = new Application(USER_0, "b2", this.resourceManager);
        application2.submit();
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(application0.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInA.contains(application1.getApplicationAttemptId()));
        Assert.assertEquals((long)2L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(application0.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInRoot.contains(application1.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInRoot.contains(application2.getApplicationAttemptId()));
        Assert.assertEquals((long)3L, (long)appsInRoot.size());
        Assert.assertNull((Object)scheduler.getAppsInQueue("nonexistentqueue"));
    }

    @Test
    public void testAddAndRemoveAppFromCapacityScheduler() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        AbstractYarnScheduler cs = (AbstractYarnScheduler)rm.getResourceScheduler();
        SchedulerApplication<SchedulerApplicationAttempt> app = TestSchedulerUtils.verifyAppAddedAndRemovedFromScheduler(cs.getSchedulerApplications(), (EventHandler<SchedulerEvent>)cs, "a1");
        Assert.assertEquals((Object)"a1", (Object)app.getQueue().getQueueName());
    }

    @Test
    public void testKillAllAppsInQueue() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-1").withUser(USER_0).withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        String queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInA1.get(0)).getQueue().getQueueName();
        Assert.assertEquals((Object)"a1", (Object)queue);
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        scheduler.killAllAppsInQueue("a1");
        rm.waitForState(app.getApplicationId(), RMAppState.KILLED);
        rm.waitForAppRemovedFromScheduler(app.getApplicationId());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.isEmpty());
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertTrue((boolean)appsInA1.isEmpty());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.isEmpty());
        rm.stop();
    }

    @Test
    public void testKillAllAppsInvalidSource() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        ResourceScheduler scheduler = rm.getResourceScheduler();
        ApplicationAttemptId appAttemptId = this.submitApp(rm);
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        try {
            scheduler.killAllAppsInQueue("DOES_NOT_EXIST");
            Assert.fail();
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testAppReservationWithDominantResourceCalculator() throws Exception {
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setResourceComparator(DominantResourceCalculator.class);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csconf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 10240, 1);
        MockNM nm2 = rm.registerNode("127.0.0.1:1235", 10240, 4);
        rm.registerNode("127.0.0.1:1236", 10240, 4);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        SchedulerNodeReport reportNm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)1024L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)9216L, (long)reportNm1.getAvailableResource().getMemorySize());
        am1.addRequests(new String[]{"127.0.0.1", "127.0.0.2"}, 1024, 1, 1);
        am1.schedule();
        nm1.nodeHeartbeat(true);
        Thread.sleep(1000L);
        AllocateResponse allocResponse = am1.schedule();
        ApplicationResourceUsageReport report = rm.getResourceScheduler().getAppResourceUsageReport(attempt1.getAppAttemptId());
        Assert.assertEquals((long)0L, (long)allocResponse.getAllocatedContainers().size());
        Assert.assertEquals((long)0L, (long)report.getNumReservedContainers());
        nm2.nodeHeartbeat(true);
        while (allocResponse.getAllocatedContainers().size() == 0) {
            Thread.sleep(100L);
            allocResponse = am1.schedule();
        }
        report = rm.getResourceScheduler().getAppResourceUsageReport(attempt1.getAppAttemptId());
        Assert.assertEquals((long)1L, (long)allocResponse.getAllocatedContainers().size());
        Assert.assertEquals((long)0L, (long)report.getNumReservedContainers());
        rm.stop();
    }

    @Test
    public void testMoveAppAmbiguousQueue() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMoveAmbiguousQueue();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        QueueMetrics metrics = scheduler.getRootQueueMetrics();
        Assert.assertEquals((long)0L, (long)metrics.getAppsPending());
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-1").withUser(USER_0).withAcls(null).withQueue("root.a.a").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        List appsInA = scheduler.getAppsInQueue("root.a.a");
        Assert.assertEquals((long)1L, (long)appsInA.size());
        String queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInA.get(0)).getQueue().getQueueName();
        Assert.assertEquals((Object)"a", (Object)queue);
        scheduler.moveApplication(app.getApplicationId(), "a1");
        List appsInA1 = scheduler.getAppsInQueue("root.a.a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInA1.get(0)).getQueue().getQueueName();
        Assert.assertEquals((Object)"a1", (Object)queue);
        appsInA = scheduler.getAppsInQueue("root.a.a");
        Assert.assertTrue((boolean)appsInA.isEmpty());
        rm.stop();
    }

    @Test
    public void testMoveAppBasic() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        QueueMetrics metrics = scheduler.getRootQueueMetrics();
        Assert.assertEquals((long)0L, (long)metrics.getAppsPending());
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-1").withUser(USER_0).withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        String queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInA1.get(0)).getQueue().getQueueName();
        Assert.assertEquals((Object)"a1", (Object)queue);
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        Assert.assertEquals((long)1L, (long)metrics.getAppsPending());
        List appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertTrue((boolean)appsInB1.isEmpty());
        List appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.isEmpty());
        scheduler.moveApplication(app.getApplicationId(), "b1");
        appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertEquals((long)1L, (long)appsInB1.size());
        queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInB1.get(0)).getQueue().getQueueName();
        Assert.assertEquals((Object)"b1", (Object)queue);
        appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInB.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        Assert.assertEquals((long)1L, (long)metrics.getAppsPending());
        appsInA1 = scheduler.getAppsInQueue("a1");
        Assert.assertTrue((boolean)appsInA1.isEmpty());
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.isEmpty());
        rm.stop();
    }

    @Test
    public void testMoveAppPendingMetrics() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        ResourceScheduler scheduler = rm.getResourceScheduler();
        this.assertApps(scheduler, 0, 0, 0);
        RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-1").withUser(USER_0).withAcls(null).withQueue("a1").build());
        RMApp app2 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-2").withUser(USER_0).withAcls(null).withQueue("a1").build());
        this.assertApps(scheduler, 2, 0, 2);
        RMApp app3 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-2").withUser(USER_0).withAcls(null).withQueue("b1").build());
        this.assertApps(scheduler, 2, 1, 3);
        scheduler.moveApplication(app1.getApplicationId(), "b1");
        this.assertApps(scheduler, 1, 2, 3);
        scheduler.moveApplication(app2.getApplicationId(), "b1");
        this.assertApps(scheduler, 0, 3, 3);
        scheduler.moveApplication(app3.getApplicationId(), "a1");
        this.assertApps(scheduler, 1, 2, 3);
        rm.stop();
    }

    private void assertApps(ResourceScheduler scheduler, int a1Size, int b1Size, int appsPending) {
        this.assertAppsSize(scheduler, "a1", a1Size);
        this.assertAppsSize(scheduler, "b1", b1Size);
        Assert.assertEquals((long)appsPending, (long)scheduler.getRootQueueMetrics().getAppsPending());
    }

    private void assertAppsSize(ResourceScheduler scheduler, String queueName, int size) {
        Assert.assertEquals((long)size, (long)scheduler.getAppsInQueue(queueName).size());
    }

    @Test
    public void testMoveAppSameParent() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-1").withUser(USER_0).withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        this.assertOneAppInQueue(scheduler, "a1");
        this.assertApps((ResourceScheduler)scheduler, "root", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "a", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "a2", new ApplicationAttemptId[0]);
        scheduler.moveApplication(app.getApplicationId(), "a2");
        this.assertApps((ResourceScheduler)scheduler, "root", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "a", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "a1", new ApplicationAttemptId[0]);
        this.assertOneAppInQueue(scheduler, "a2");
        rm.stop();
    }

    private void assertApps(ResourceScheduler scheduler, String queueName, ApplicationAttemptId ... apps) {
        Assert.assertEquals((Object)Lists.newArrayList((Object[])apps), (Object)scheduler.getAppsInQueue(queueName));
    }

    private void assertOneAppInQueue(AbstractYarnScheduler scheduler, String queueName) {
        List apps = scheduler.getAppsInQueue(queueName);
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)queueName, (Object)scheduler.getApplicationAttempt((ApplicationAttemptId)apps.get(0)).getQueue().getQueueName());
    }

    @Test
    public void testMoveAppForMoveToQueueWithFreeCap() throws Exception {
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        String host0 = "host_0";
        NodeManager nm0 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host0, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)1), mockNodeStatus);
        String host1 = "host_1";
        NodeManager nm1 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host1, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)1), mockNodeStatus);
        Priority priority0 = Priority.newInstance((int)0);
        Priority priority1 = Priority.newInstance((int)1);
        Application application0 = new Application(USER_0, "a1", this.resourceManager);
        application0.submit();
        application0.addNodeManager(host0, 1234, nm0);
        application0.addNodeManager(host1, 1234, nm1);
        Resource capability00 = Resources.createResource((int)1024, (int)1);
        application0.addResourceRequestSpec(priority1, capability00);
        Resource capability01 = Resources.createResource((int)2048, (int)1);
        application0.addResourceRequestSpec(priority0, capability01);
        Task task00 = new Task(application0, priority1, new String[]{host0, host1});
        application0.addTask(task00);
        Application application1 = new Application("user_1", "b2", this.resourceManager);
        application1.submit();
        application1.addNodeManager(host0, 1234, nm0);
        application1.addNodeManager(host1, 1234, nm1);
        Resource capability10 = Resources.createResource((int)1024, (int)1);
        application1.addResourceRequestSpec(priority1, capability10);
        Resource capability11 = Resources.createResource((int)2048, (int)1);
        application1.addResourceRequestSpec(priority0, capability11);
        Task task10 = new Task(application1, priority1, new String[]{host0, host1});
        application1.addTask(task10);
        application0.schedule();
        application1.schedule();
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm0);
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm1);
        application0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(1024, application0);
        application1.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(1024, application1);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(2048, nm0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(0, nm1);
        scheduler.moveApplication(application0.getApplicationId(), "b1");
        Task task11 = new Task(application1, priority0, new String[]{"*"});
        application1.addTask(task11);
        application1.schedule();
        Task task01 = new Task(application0, priority0, new String[]{host0, host1});
        application0.addTask(task01);
        application0.schedule();
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm0);
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm1);
        application1.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application1);
        application0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(4096, nm0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(2048, nm1);
    }

    @Test
    public void testMoveAppSuccess() throws Exception {
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        String host0 = "host_0";
        NodeManager nm0 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host0, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)1), mockNodeStatus);
        String host1 = "host_1";
        NodeManager nm1 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host1, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)1), mockNodeStatus);
        Priority priority0 = Priority.newInstance((int)0);
        Priority priority1 = Priority.newInstance((int)1);
        Application application0 = new Application(USER_0, "a1", this.resourceManager);
        application0.submit();
        application0.addNodeManager(host0, 1234, nm0);
        application0.addNodeManager(host1, 1234, nm1);
        Resource capability00 = Resources.createResource((int)3072, (int)1);
        application0.addResourceRequestSpec(priority1, capability00);
        Resource capability01 = Resources.createResource((int)2048, (int)1);
        application0.addResourceRequestSpec(priority0, capability01);
        Task task00 = new Task(application0, priority1, new String[]{host0, host1});
        application0.addTask(task00);
        Application application1 = new Application("user_1", "b2", this.resourceManager);
        application1.submit();
        application1.addNodeManager(host0, 1234, nm0);
        application1.addNodeManager(host1, 1234, nm1);
        Resource capability10 = Resources.createResource((int)1024, (int)1);
        application1.addResourceRequestSpec(priority1, capability10);
        Resource capability11 = Resources.createResource((int)2048, (int)1);
        application1.addResourceRequestSpec(priority0, capability11);
        Task task10 = new Task(application1, priority1, new String[]{host0, host1});
        application1.addTask(task10);
        application0.schedule();
        application1.schedule();
        scheduler.moveApplication(application0.getApplicationId(), "b2");
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm0);
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm1);
        application0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(0, application0);
        application1.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(1024, application1);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(1024, nm0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(0, nm1);
        scheduler.moveApplication(application0.getApplicationId(), "a2");
        application0.schedule();
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm1);
        application0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(1024, nm0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(3072, nm1);
    }

    @Test(expected=YarnException.class)
    public void testMoveAppViolateQueueState() throws Exception {
        this.resourceManager = new ResourceManager(){

            protected RMNodeLabelsManager createNodeLabelManager() {
                NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(csConf);
        StringBuilder qState = new StringBuilder();
        qState.append("yarn.scheduler.capacity.").append("root.b").append(".").append("state");
        csConf.set(qState.toString(), QueueState.STOPPED.name());
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.webapp.api-service.enable", false);
        this.resourceManager.init((Configuration)conf);
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMContext().getNMTokenSecretManager().rollMasterKey();
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.mockContext.getConfigurationProvider()).thenReturn((Object)new LocalConfigurationProvider());
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        String host0 = "host_0";
        NodeManager nm0 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host0, 1234, 2345, "/default-rack", Resources.createResource((int)6144, (int)1), mockNodeStatus);
        Priority priority0 = Priority.newInstance((int)0);
        Priority priority1 = Priority.newInstance((int)1);
        Application application0 = new Application(USER_0, "a1", this.resourceManager);
        application0.submit();
        application0.addNodeManager(host0, 1234, nm0);
        Resource capability00 = Resources.createResource((int)3072, (int)1);
        application0.addResourceRequestSpec(priority1, capability00);
        Resource capability01 = Resources.createResource((int)2048, (int)1);
        application0.addResourceRequestSpec(priority0, capability01);
        Task task00 = new Task(application0, priority1, new String[]{host0});
        application0.addTask(task00);
        application0.schedule();
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm0);
        application0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(3072, nm0);
        scheduler.moveApplication(application0.getApplicationId(), "b1");
    }

    @Test
    public void testMoveAppQueueMetricsCheck() throws Exception {
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        String host0 = "host_0";
        NodeManager nm0 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host0, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)1), mockNodeStatus);
        String host1 = "host_1";
        NodeManager nm1 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host1, 1234, 2345, "/default-rack", Resources.createResource((int)5120, (int)1), mockNodeStatus);
        Priority priority0 = Priority.newInstance((int)0);
        Priority priority1 = Priority.newInstance((int)1);
        Application application0 = new Application(USER_0, "a1", this.resourceManager);
        application0.submit();
        application0.addNodeManager(host0, 1234, nm0);
        application0.addNodeManager(host1, 1234, nm1);
        Resource capability00 = Resources.createResource((int)3072, (int)1);
        application0.addResourceRequestSpec(priority1, capability00);
        Resource capability01 = Resources.createResource((int)2048, (int)1);
        application0.addResourceRequestSpec(priority0, capability01);
        Task task00 = new Task(application0, priority1, new String[]{host0, host1});
        application0.addTask(task00);
        Application application1 = new Application("user_1", "b2", this.resourceManager);
        application1.submit();
        application1.addNodeManager(host0, 1234, nm0);
        application1.addNodeManager(host1, 1234, nm1);
        Resource capability10 = Resources.createResource((int)1024, (int)1);
        application1.addResourceRequestSpec(priority1, capability10);
        Resource capability11 = Resources.createResource((int)2048, (int)1);
        application1.addResourceRequestSpec(priority0, capability11);
        Task task10 = new Task(application1, priority1, new String[]{host0, host1});
        application1.addTask(task10);
        application0.schedule();
        application1.schedule();
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm0);
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm1);
        CapacityScheduler cs = (CapacityScheduler)this.resourceManager.getResourceScheduler();
        CSQueue origRootQ = cs.getRootQueue();
        CapacitySchedulerInfo oldInfo = new CapacitySchedulerInfo(origRootQ, cs);
        int origNumAppsA = this.getNumAppsInQueue("a", origRootQ.getChildQueues());
        int origNumAppsRoot = origRootQ.getNumApplications();
        scheduler.moveApplication(application0.getApplicationId(), "a2");
        CSQueue newRootQ = cs.getRootQueue();
        int newNumAppsA = this.getNumAppsInQueue("a", newRootQ.getChildQueues());
        int newNumAppsRoot = newRootQ.getNumApplications();
        CapacitySchedulerInfo newInfo = new CapacitySchedulerInfo(newRootQ, cs);
        CapacitySchedulerLeafQueueInfo origOldA1 = (CapacitySchedulerLeafQueueInfo)this.getQueueInfo("a1", oldInfo.getQueues());
        CapacitySchedulerLeafQueueInfo origNewA1 = (CapacitySchedulerLeafQueueInfo)this.getQueueInfo("a1", newInfo.getQueues());
        CapacitySchedulerLeafQueueInfo targetOldA2 = (CapacitySchedulerLeafQueueInfo)this.getQueueInfo("a2", oldInfo.getQueues());
        CapacitySchedulerLeafQueueInfo targetNewA2 = (CapacitySchedulerLeafQueueInfo)this.getQueueInfo("a2", newInfo.getQueues());
        Assert.assertEquals((long)1L, (long)origOldA1.getNumApplications());
        Assert.assertEquals((long)1L, (long)origNumAppsA);
        Assert.assertEquals((long)2L, (long)origNumAppsRoot);
        Assert.assertEquals((long)0L, (long)origNewA1.getNumApplications());
        Assert.assertEquals((long)1L, (long)newNumAppsA);
        Assert.assertEquals((long)2L, (long)newNumAppsRoot);
        Assert.assertEquals((long)3072L, (long)origOldA1.getResourcesUsed().getMemorySize());
        Assert.assertEquals((long)1L, (long)origOldA1.getResourcesUsed().getvCores());
        Assert.assertEquals((long)0L, (long)origNewA1.getResourcesUsed().getMemorySize());
        Assert.assertEquals((long)0L, (long)origNewA1.getResourcesUsed().getvCores());
        Assert.assertEquals((long)3072L, (long)targetNewA2.getResourcesUsed().getMemorySize());
        Assert.assertEquals((long)1L, (long)targetNewA2.getResourcesUsed().getvCores());
        Assert.assertEquals((long)0L, (long)targetOldA2.getNumApplications());
        Assert.assertEquals((long)0L, (long)targetOldA2.getResourcesUsed().getMemorySize());
        Assert.assertEquals((long)0L, (long)targetOldA2.getResourcesUsed().getvCores());
        Assert.assertEquals((long)1L, (long)targetNewA2.getNumApplications());
        Assert.assertEquals((long)1L, (long)origOldA1.getNumContainers());
        Assert.assertEquals((long)0L, (long)origNewA1.getNumContainers());
        Assert.assertEquals((long)1L, (long)targetNewA2.getNumContainers());
        Assert.assertEquals((long)0L, (long)targetOldA2.getNumContainers());
        Assert.assertEquals((long)3072L, (long)((UserInfo)origOldA1.getUsers().getUsersList().get(0)).getResourcesUsed().getMemorySize());
        Assert.assertEquals((long)1L, (long)((UserInfo)origOldA1.getUsers().getUsersList().get(0)).getResourcesUsed().getvCores());
        Assert.assertEquals((long)0L, (long)origNewA1.getUsers().getUsersList().size());
        Assert.assertEquals((long)3072L, (long)((UserInfo)targetNewA2.getUsers().getUsersList().get(0)).getResourcesUsed().getMemorySize());
        Assert.assertEquals((long)1L, (long)((UserInfo)targetNewA2.getUsers().getUsersList().get(0)).getResourcesUsed().getvCores());
        application0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application0);
        application1.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(1024, application1);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(4096, nm0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(0, nm1);
    }

    @Test
    public void testMoveAllApps() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        ApplicationAttemptId appAttemptId = this.submitApp(rm);
        this.assertOneAppInQueue(scheduler, "a1");
        this.assertApps((ResourceScheduler)scheduler, "root", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "a", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "a1", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "b1", new ApplicationAttemptId[0]);
        this.assertApps((ResourceScheduler)scheduler, "b", new ApplicationAttemptId[0]);
        scheduler.moveAllApps("a1", "b1");
        Thread.sleep(1000L);
        this.assertOneAppInQueue(scheduler, "b1");
        this.assertApps((ResourceScheduler)scheduler, "root", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "b", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "b1", appAttemptId);
        this.assertApps((ResourceScheduler)scheduler, "a1", new ApplicationAttemptId[0]);
        this.assertApps((ResourceScheduler)scheduler, "a", new ApplicationAttemptId[0]);
        rm.stop();
    }

    @Test
    public void testMaxParallelAppsPendingQueueMetrics() throws Exception {
        int i;
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        ResourceScheduler scheduler = rm.getResourceScheduler();
        CapacityScheduler cs = (CapacityScheduler)scheduler;
        cs.getQueueContext().getConfiguration().setInt(CapacitySchedulerConfiguration.getQueuePrefix((String)"root.a.a1") + "max-parallel-apps", 5);
        cs.reinitialize((Configuration)cs.getQueueContext().getConfiguration(), this.mockContext);
        ArrayList<ApplicationAttemptId> attemptIds = new ArrayList<ApplicationAttemptId>();
        for (i = 0; i < 10; ++i) {
            attemptIds.add(this.submitApp(rm));
        }
        for (i = 0; i < 5; ++i) {
            cs.handle((SchedulerEvent)new AppAttemptRemovedSchedulerEvent((ApplicationAttemptId)attemptIds.get(i), RMAppAttemptState.FINISHED, true));
        }
        for (i = 5; i < 10; ++i) {
            cs.handle((SchedulerEvent)new AppAttemptRemovedSchedulerEvent((ApplicationAttemptId)attemptIds.get(i), RMAppAttemptState.FINISHED, true));
        }
        Assert.assertEquals((String)"No pending app should remain for root queue", (long)0L, (long)cs.getRootQueueMetrics().getAppsPending());
        Assert.assertEquals((String)"No running application should remain for root queue", (long)0L, (long)cs.getRootQueueMetrics().getAppsRunning());
        rm.stop();
    }

    private ApplicationAttemptId submitApp(MockRM rm) throws Exception {
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-1").withUser(USER_0).withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        return rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
    }

    @Test
    public void testMoveAllAppsInvalidDestination() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        ResourceScheduler scheduler = rm.getResourceScheduler();
        ApplicationAttemptId appAttemptId = this.submitApp(rm);
        this.assertApps(scheduler, "root", appAttemptId);
        this.assertApps(scheduler, "a", appAttemptId);
        this.assertApps(scheduler, "a1", appAttemptId);
        this.assertApps(scheduler, "b", new ApplicationAttemptId[0]);
        this.assertApps(scheduler, "b1", new ApplicationAttemptId[0]);
        try {
            scheduler.moveAllApps("a1", "DOES_NOT_EXIST");
            Assert.fail();
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        this.assertApps(scheduler, "root", appAttemptId);
        this.assertApps(scheduler, "a", appAttemptId);
        this.assertApps(scheduler, "a1", appAttemptId);
        this.assertApps(scheduler, "b", new ApplicationAttemptId[0]);
        this.assertApps(scheduler, "b1", new ApplicationAttemptId[0]);
        rm.stop();
    }

    @Test
    public void testMoveAllAppsInvalidSource() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        ResourceScheduler scheduler = rm.getResourceScheduler();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-1").withUser(USER_0).withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        this.assertApps(scheduler, "root", appAttemptId);
        this.assertApps(scheduler, "a", appAttemptId);
        this.assertApps(scheduler, "a1", appAttemptId);
        this.assertApps(scheduler, "b", new ApplicationAttemptId[0]);
        this.assertApps(scheduler, "b1", new ApplicationAttemptId[0]);
        try {
            scheduler.moveAllApps("DOES_NOT_EXIST", "b1");
            Assert.fail();
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
        this.assertApps(scheduler, "root", appAttemptId);
        this.assertApps(scheduler, "a", appAttemptId);
        this.assertApps(scheduler, "a1", appAttemptId);
        this.assertApps(scheduler, "b", new ApplicationAttemptId[0]);
        this.assertApps(scheduler, "b1", new ApplicationAttemptId[0]);
        rm.stop();
    }

    @Test
    public void testMoveAppWithActiveUsersWithOnlyPendingApps() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)conf);
        newConf.setQueues("root", new String[]{"a", "b"});
        newConf.setCapacity("root.a", 50.0f);
        newConf.setCapacity("root.b", 50.0f);
        newConf.setQueues("root.a", new String[]{"a1"});
        newConf.setCapacity("root.a.a1", 100.0f);
        newConf.setUserLimitFactor("root.a.a1", 2.0f);
        newConf.setMaximumAMResourcePercentPerPartition("root.a.a1", "", 0.1f);
        newConf.setQueues("root.b", new String[]{"b1"});
        newConf.setCapacity("root.b.b1", 100.0f);
        newConf.setUserLimitFactor("root.b.b1", 2.0f);
        MockRM rm = new MockRM((Configuration)newConf);
        rm.start();
        CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("h1:1234", 16384);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-move-1").withUser("u1").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data3);
        MockAM am1 = MockRM.launchAndRegisterAM(app, rm, nm1);
        ApplicationAttemptId appAttemptId = rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("u2").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data2);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm1);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("u3").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm, data1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("u4").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app4 = MockRMAppSubmitter.submit(rm, data);
        am1.allocate("*", 1024, 50, null);
        am2.allocate("*", 1024, 50, null);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        this.assertApps((ResourceScheduler)scheduler, "root", app3.getCurrentAppAttempt().getAppAttemptId(), app4.getCurrentAppAttempt().getAppAttemptId(), appAttemptId, app2.getCurrentAppAttempt().getAppAttemptId());
        this.assertApps((ResourceScheduler)scheduler, "a", app3.getCurrentAppAttempt().getAppAttemptId(), app4.getCurrentAppAttempt().getAppAttemptId(), appAttemptId, app2.getCurrentAppAttempt().getAppAttemptId());
        this.assertApps((ResourceScheduler)scheduler, "a1", app3.getCurrentAppAttempt().getAppAttemptId(), app4.getCurrentAppAttempt().getAppAttemptId(), appAttemptId, app2.getCurrentAppAttempt().getAppAttemptId());
        this.assertApps((ResourceScheduler)scheduler, "b", new ApplicationAttemptId[0]);
        this.assertApps((ResourceScheduler)scheduler, "b1", new ApplicationAttemptId[0]);
        UsersManager um = (UsersManager)scheduler.getQueue("a1").getAbstractUsersManager();
        Assert.assertEquals((long)4L, (long)um.getNumActiveUsers());
        Assert.assertEquals((long)2L, (long)um.getNumActiveUsersWithOnlyPendingApps());
        scheduler.moveAllApps("a1", "b1");
        for (int i = 0; i < 10; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
            Thread.sleep(500L);
        }
        this.assertApps((ResourceScheduler)scheduler, "root", appAttemptId, app2.getCurrentAppAttempt().getAppAttemptId(), app3.getCurrentAppAttempt().getAppAttemptId(), app4.getCurrentAppAttempt().getAppAttemptId());
        this.assertApps((ResourceScheduler)scheduler, "a", new ApplicationAttemptId[0]);
        this.assertApps((ResourceScheduler)scheduler, "a1", new ApplicationAttemptId[0]);
        this.assertApps((ResourceScheduler)scheduler, "b", appAttemptId, app2.getCurrentAppAttempt().getAppAttemptId(), app3.getCurrentAppAttempt().getAppAttemptId(), app4.getCurrentAppAttempt().getAppAttemptId());
        this.assertApps((ResourceScheduler)scheduler, "b1", appAttemptId, app2.getCurrentAppAttempt().getAppAttemptId(), app3.getCurrentAppAttempt().getAppAttemptId(), app4.getCurrentAppAttempt().getAppAttemptId());
        UsersManager umB1 = (UsersManager)scheduler.getQueue("b1").getAbstractUsersManager();
        Assert.assertEquals((long)2L, (long)umB1.getNumActiveUsers());
        Assert.assertEquals((long)2L, (long)umB1.getNumActiveUsersWithOnlyPendingApps());
        rm.close();
    }

    @Test(timeout=60000L)
    public void testMoveAttemptNotAdded() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(this.getCapacityConfiguration(conf));
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        ApplicationId appId = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        RMAppAttemptMetrics attemptMetric = new RMAppAttemptMetrics(appAttemptId, rm.getRMContext());
        RMAppImpl app = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        RMAppAttemptImpl attempt = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)attempt.getMasterContainer()).thenReturn((Object)container);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)attempt.getSubmissionContext()).thenReturn((Object)submissionContext);
        Mockito.when((Object)attempt.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)attempt.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)attempt);
        rm.getRMContext().getRMApps().put(appId, app);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "a1", "user");
        try {
            cs.moveApplication(appId, "b1");
            Assert.fail((String)"Move should throw exception app not available");
        }
        catch (YarnException e) {
            Assert.assertEquals((Object)"App to be moved application_100_0001 not found.", (Object)e.getMessage());
        }
        cs.handle((SchedulerEvent)addAppEvent);
        cs.moveApplication(appId, "b1");
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        cs.handle((SchedulerEvent)addAttemptEvent);
        CSQueue rootQ = cs.getRootQueue();
        CSQueue queueB = cs.getQueue("b");
        CSQueue queueA = cs.getQueue("a");
        CSQueue queueA1 = cs.getQueue("a1");
        CSQueue queueB1 = cs.getQueue("b1");
        Assert.assertEquals((long)1L, (long)rootQ.getNumApplications());
        Assert.assertEquals((long)0L, (long)queueA.getNumApplications());
        Assert.assertEquals((long)1L, (long)queueB.getNumApplications());
        Assert.assertEquals((long)0L, (long)queueA1.getNumApplications());
        Assert.assertEquals((long)1L, (long)queueB1.getNumApplications());
        rm.close();
    }

    @Test
    public void testRemoveAttemptMoveAdded() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, CapacityScheduler.class);
        conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm = new MockRM(this.getCapacityConfiguration((Configuration)conf));
        CapacityScheduler sch = (CapacityScheduler)rm.getResourceScheduler();
        Resource newResource = Resource.newInstance((int)4096, (int)1);
        RMNode node = MockNodes.newNodeInfo(0, newResource, 1, "127.0.0.1");
        NodeAddedSchedulerEvent addNode = new NodeAddedSchedulerEvent(node);
        sch.handle((SchedulerEvent)addNode);
        ApplicationAttemptId appAttemptId = CapacitySchedulerTestUtilities.appHelper(rm, sch, 100, 1, "a1", "user");
        CSQueue queueA1 = sch.getQueue("a1");
        CSQueue queueB = sch.getQueue("b");
        CSQueue queueB1 = sch.getQueue("b1");
        ContainerId newContainerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)2L);
        RMContainerImpl rmContainer = (RMContainerImpl)Mockito.mock(RMContainerImpl.class);
        Mockito.when((Object)rmContainer.getState()).thenReturn((Object)RMContainerState.RUNNING);
        Container container2 = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)rmContainer.getContainer()).thenReturn((Object)container2);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        Mockito.when((Object)container2.getResource()).thenReturn((Object)resource);
        Mockito.when((Object)rmContainer.getExecutionType()).thenReturn((Object)ExecutionType.GUARANTEED);
        Mockito.when((Object)container2.getNodeId()).thenReturn((Object)node.getNodeID());
        Mockito.when((Object)container2.getId()).thenReturn((Object)newContainerId);
        Mockito.when((Object)rmContainer.getNodeLabelExpression()).thenReturn((Object)"");
        Mockito.when((Object)rmContainer.getContainerId()).thenReturn((Object)newContainerId);
        sch.getApplicationAttempt(appAttemptId).getLiveContainersMap().put(newContainerId, rmContainer);
        QueueMetrics queueA1M = queueA1.getMetrics();
        queueA1M.incrPendingResources(rmContainer.getNodeLabelExpression(), "user1", 1, resource);
        queueA1M.allocateResources(rmContainer.getNodeLabelExpression(), "user1", resource);
        sch.handle((SchedulerEvent)new AppAttemptRemovedSchedulerEvent(appAttemptId, RMAppAttemptState.KILLED, true));
        sch.moveApplication(appAttemptId.getApplicationId(), "b1");
        Assert.assertEquals((long)0L, (long)queueA1.getNumApplications());
        Assert.assertEquals((long)1L, (long)queueB.getNumApplications());
        Assert.assertEquals((long)0L, (long)queueB1.getNumApplications());
        ApplicationAttemptId appAttemptId2 = BuilderUtils.newApplicationAttemptId((ApplicationId)appAttemptId.getApplicationId(), (int)2);
        AppAttemptAddedSchedulerEvent addAttemptEvent2 = new AppAttemptAddedSchedulerEvent(appAttemptId2, true);
        sch.handle((SchedulerEvent)addAttemptEvent2);
        Assert.assertEquals((long)0L, (long)queueA1.getNumApplications());
        Assert.assertEquals((long)1L, (long)queueB.getNumApplications());
        Assert.assertEquals((long)1L, (long)queueB1.getNumApplications());
        QueueMetrics queueB1M = queueB1.getMetrics();
        QueueMetrics queueBM = queueB.getMetrics();
        Assert.assertEquals((long)0L, (long)queueA1M.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)queueA1M.getAllocatedVirtualCores());
        Assert.assertEquals((long)1024L, (long)queueB1M.getAllocatedMB());
        Assert.assertEquals((long)1L, (long)queueB1M.getAllocatedVirtualCores());
        sch.handle((SchedulerEvent)new AppAttemptRemovedSchedulerEvent(appAttemptId2, RMAppAttemptState.FINISHED, false));
        Assert.assertEquals((long)0L, (long)queueA1M.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)queueA1M.getAllocatedVirtualCores());
        Assert.assertEquals((long)0L, (long)queueB1M.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)queueB1M.getAllocatedVirtualCores());
        this.verifyQueueMetrics(queueB1M);
        this.verifyQueueMetrics(queueBM);
        this.verifyQueueMetrics(queueA1M);
        rm.close();
    }

    @Test
    public void testAppSubmission() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setQueues("root.a", new String[]{"a1", "a2", "b"});
        conf.setCapacity("root.a.a1", 20.0f);
        conf.setCapacity("root.a.b", 10.0f);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        RMApp noParentQueueApp = this.submitAppAndWaitForState(rm, "q", RMAppState.FAILED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)noParentQueueApp.getState());
        RMApp ambiguousQueueApp = this.submitAppAndWaitForState(rm, "b", RMAppState.FAILED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)ambiguousQueueApp.getState());
        RMApp emptyPartQueueApp = this.submitAppAndWaitForState(rm, "root..a1", RMAppState.FAILED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)emptyPartQueueApp.getState());
        RMApp failedAutoQueue = this.submitAppAndWaitForState(rm, "root.a.b.c.d", RMAppState.FAILED);
        Assert.assertEquals((Object)RMAppState.FAILED, (Object)failedAutoQueue.getState());
    }

    private RMApp submitAppAndWaitForState(MockRM rm, String b, RMAppState state) throws Exception {
        MockRMAppSubmissionData ambiguousQueueAppData = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withWaitForAppAcceptedState(false).withAppName("app").withUser("user").withAcls(null).withQueue(b).withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, ambiguousQueueAppData);
        rm.waitForState(app1.getApplicationId(), state);
        return app1;
    }

    private int getNumAppsInQueue(String name, List<CSQueue> queues) {
        for (CSQueue queue : queues) {
            if (!queue.getQueueShortName().equals(name)) continue;
            return queue.getNumApplications();
        }
        return -1;
    }

    private CapacitySchedulerQueueInfo getQueueInfo(String name, CapacitySchedulerQueueInfoList info) {
        if (info != null) {
            for (CapacitySchedulerQueueInfo queueInfo : info.getQueueInfoList()) {
                if (queueInfo.getQueueName().equals(name)) {
                    return queueInfo;
                }
                CapacitySchedulerQueueInfo result = this.getQueueInfo(name, queueInfo.getQueues());
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private void verifyQueueMetrics(QueueMetrics queue) {
        Assert.assertEquals((long)0L, (long)queue.getPendingMB());
        Assert.assertEquals((long)0L, (long)queue.getActiveUsers());
        Assert.assertEquals((long)0L, (long)queue.getActiveApps());
        Assert.assertEquals((long)0L, (long)queue.getAppsPending());
        Assert.assertEquals((long)0L, (long)queue.getAppsRunning());
        Assert.assertEquals((long)0L, (long)queue.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)queue.getAllocatedVirtualCores());
    }

    private Configuration getCapacityConfiguration(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacity("root.a", 50.0f);
        conf.setCapacity("root.b", 50.0f);
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 50.0f);
        conf.setCapacity("root.a.a2", 50.0f);
        conf.setQueues("root.b", new String[]{"b1"});
        conf.setCapacity("root.b.b1", 100.0f);
        return conf;
    }
}

