/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueTemplate;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAutoCreatedQueueTemplate {
    private static final QueuePath TEST_QUEUE_ABC = new QueuePath("root.a.b.c");
    private static final QueuePath TEST_QUEUE_AB = new QueuePath("root.a.b");
    private static final QueuePath TEST_QUEUE_A = new QueuePath("root.a");
    private static final QueuePath TEST_QUEUE_B = new QueuePath("root.b");
    private static final String ROOT = "root";
    private CapacitySchedulerConfiguration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new CapacitySchedulerConfiguration();
        this.conf.setQueues(ROOT, new String[]{"a"});
        this.conf.setQueues("a", new String[]{"b"});
        this.conf.setQueues("b", new String[]{"c"});
    }

    @Test
    public void testNonWildCardTemplate() {
        this.conf.set(this.getTemplateKey(TEST_QUEUE_AB.getFullPath(), "capacity"), "6w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC.getFullPath());
        Assert.assertEquals((String)"weight is not set", (double)6.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC.getFullPath()), (double)1.0E-5);
    }

    @Test
    public void testOneLevelWildcardTemplate() {
        this.conf.set(this.getTemplateKey("root.a.*", "capacity"), "6w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC.getFullPath());
        Assert.assertEquals((String)"weight is not set", (double)6.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC.getFullPath()), (double)1.0E-5);
    }

    @Test
    public void testTwoLevelWildcardTemplate() {
        this.conf.set(this.getTemplateKey("root.*", "capacity"), "6w");
        this.conf.set(this.getTemplateKey("root.*.*", "capacity"), "5w");
        new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_A).setTemplateEntriesForChild(this.conf, TEST_QUEUE_AB.getFullPath());
        new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB).setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC.getFullPath());
        Assert.assertEquals((String)"weight is not set", (double)6.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_AB.getFullPath()), (double)1.0E-5);
        Assert.assertEquals((String)"weight is not set", (double)5.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC.getFullPath()), (double)1.0E-5);
    }

    @Test
    public void testIgnoredWhenRootWildcarded() {
        this.conf.set(this.getTemplateKey("*", "capacity"), "6w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, new QueuePath(ROOT));
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_A.getFullPath());
        Assert.assertEquals((String)"weight is set", (double)-1.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_A.getFullPath()), (double)1.0E-5);
    }

    @Test
    public void testIgnoredWhenNoParent() {
        this.conf.set(this.getTemplateKey(ROOT, "capacity"), "6w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, new QueuePath(ROOT));
        template.setTemplateEntriesForChild(this.conf, ROOT);
        Assert.assertEquals((String)"weight is set", (double)-1.0, (double)this.conf.getNonLabeledQueueWeight(ROOT), (double)1.0E-5);
    }

    @Test
    public void testWildcardAfterRoot() {
        this.conf.set(this.getTemplateKey("root.*", "acl_submit_applications"), "user");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, new QueuePath("root.a"));
        template.setTemplateEntriesForChild(this.conf, "root.a");
        Assert.assertEquals((String)"acl_submit_applications is set", (Object)"user", template.getTemplateProperties().get("acl_submit_applications"));
    }

    @Test
    public void testTemplatePrecedence() {
        this.conf.set(this.getTemplateKey("root.a.b", "capacity"), "6w");
        this.conf.set(this.getTemplateKey("root.a.*", "capacity"), "4w");
        this.conf.set(this.getTemplateKey("root.*.*", "capacity"), "2w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC.getFullPath());
        Assert.assertEquals((String)"explicit template does not have the highest precedence", (double)6.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC.getFullPath()), (double)1.0E-5);
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration();
        newConf.set(this.getTemplateKey("root.a.*", "capacity"), "4w");
        template = new AutoCreatedQueueTemplate(newConf, TEST_QUEUE_AB);
        template.setTemplateEntriesForChild(newConf, TEST_QUEUE_ABC.getFullPath());
        Assert.assertEquals((String)"precedence is invalid", (double)4.0, (double)newConf.getNonLabeledQueueWeight(TEST_QUEUE_ABC.getFullPath()), (double)1.0E-5);
    }

    @Test
    public void testRootTemplate() {
        this.conf.set(this.getTemplateKey(ROOT, "capacity"), "2w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, new QueuePath(ROOT));
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_A.getFullPath());
        Assert.assertEquals((String)"root property is not set", (double)2.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_A.getFullPath()), (double)1.0E-5);
    }

    @Test
    public void testQueueSpecificTemplates() {
        this.conf.set(this.getTemplateKey(ROOT, "capacity"), "2w");
        this.conf.set(this.getLeafTemplateKey(ROOT, "default-node-label-expression"), "test");
        this.conf.set(this.getLeafTemplateKey(ROOT, "capacity"), "10w");
        this.conf.setBoolean(this.getParentTemplateKey(ROOT, "auto-queue-creation-v2.queue-auto-removal.enable"), false);
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, new QueuePath(ROOT));
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_A.getFullPath());
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_B.getFullPath(), true);
        Assert.assertNull((String)"default-node-label-expression is set for parent", (Object)this.conf.getDefaultNodeLabelExpression(TEST_QUEUE_A.getFullPath()));
        Assert.assertEquals((String)"default-node-label-expression is not set for leaf", (Object)"test", (Object)this.conf.getDefaultNodeLabelExpression(TEST_QUEUE_B.getFullPath()));
        Assert.assertFalse((String)"auto queue removal is not disabled for parent", (boolean)this.conf.isAutoExpiredDeletionEnabled(TEST_QUEUE_A.getFullPath()));
        Assert.assertEquals((String)"weight should not be overridden when set by queue type specific template", (double)10.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_B.getFullPath()), (double)1.0E-5);
        Assert.assertEquals((String)"weight should be set by common template", (double)2.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_A.getFullPath()), (double)1.0E-5);
    }

    private String getTemplateKey(String queuePath, String entryKey) {
        return CapacitySchedulerConfiguration.getQueuePrefix((String)queuePath) + "auto-queue-creation-v2.template." + entryKey;
    }

    private String getParentTemplateKey(String queuePath, String entryKey) {
        return CapacitySchedulerConfiguration.getQueuePrefix((String)queuePath) + "auto-queue-creation-v2.parent-template." + entryKey;
    }

    private String getLeafTemplateKey(String queuePath, String entryKey) {
        return CapacitySchedulerConfiguration.getQueuePrefix((String)queuePath) + "auto-queue-creation-v2.leaf-template." + entryKey;
    }
}

