/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.server.resourcemanager.RMHATestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRMHAForNodeLabels
extends RMHATestBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestRMHAForNodeLabels.class);

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        File tempDir = File.createTempFile("nlb", ".tmp");
        tempDir.delete();
        tempDir.mkdirs();
        tempDir.deleteOnExit();
        this.confForRM1.setBoolean("yarn.node-labels.enabled", true);
        this.confForRM1.set("yarn.node-labels.fs-store.root-dir", tempDir.getAbsolutePath());
        this.confForRM2.setBoolean("yarn.node-labels.enabled", true);
        this.confForRM2.set("yarn.node-labels.fs-store.root-dir", tempDir.getAbsolutePath());
    }

    @Test
    public void testRMHARecoverNodeLabels() throws Exception {
        this.startRMs();
        rm1.getRMContext().getNodeLabelManager().addToCluserNodeLabels(Arrays.asList(NodeLabel.newInstance((String)"a"), NodeLabel.newInstance((String)"b"), NodeLabel.newInstance((String)"c")));
        HashMap<NodeId, ImmutableSet> nodeToLabels = new HashMap<NodeId, ImmutableSet>();
        nodeToLabels.put(NodeId.newInstance((String)"host1", (int)0), ImmutableSet.of((Object)"a"));
        nodeToLabels.put(NodeId.newInstance((String)"host2", (int)0), ImmutableSet.of((Object)"b"));
        rm1.getRMContext().getNodeLabelManager().replaceLabelsOnNode(nodeToLabels);
        this.explicitFailover();
        Assert.assertTrue((boolean)rm2.getRMContext().getNodeLabelManager().getClusterNodeLabelNames().containsAll((Collection<?>)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c")));
        Assert.assertTrue((boolean)((Set)rm2.getRMContext().getNodeLabelManager().getNodeLabels().get(NodeId.newInstance((String)"host1", (int)0))).contains("a"));
        Assert.assertTrue((boolean)((Set)rm2.getRMContext().getNodeLabelManager().getNodeLabels().get(NodeId.newInstance((String)"host2", (int)0))).contains("b"));
    }
}

