/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement;

import java.util.HashSet;
import java.util.function.LongBinaryOperator;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeOpCode;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.exceptions.SchedulerInvalidResoureRequestException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTags;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.MemoryPlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.SingleConstraintAppPlacementAllocator;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSingleConstraintAppPlacementAllocator {
    private AppSchedulingInfo appSchedulingInfo;
    private AllocationTagsManager spyAllocationTagsManager;
    private RMContext rmContext;
    private SchedulerRequestKey schedulerRequestKey;
    private SingleConstraintAppPlacementAllocator allocator;

    @Before
    public void setup() throws Exception {
        this.appSchedulingInfo = (AppSchedulingInfo)Mockito.mock(AppSchedulingInfo.class);
        Mockito.when((Object)this.appSchedulingInfo.getApplicationId()).thenReturn((Object)TestUtils.getMockApplicationId(1));
        Mockito.when((Object)this.appSchedulingInfo.getApplicationAttemptId()).thenReturn((Object)TestUtils.getMockApplicationAttemptId(1, 1));
        Mockito.when((Object)this.appSchedulingInfo.getDefaultNodeLabelExpression()).thenReturn((Object)"y");
        this.rmContext = TestUtils.getMockRMContext();
        AllocationTagsManager allocationTagsManager = new AllocationTagsManager(this.rmContext);
        MemoryPlacementConstraintManager placementConstraintManager = new MemoryPlacementConstraintManager();
        this.spyAllocationTagsManager = (AllocationTagsManager)Mockito.spy((Object)allocationTagsManager);
        this.schedulerRequestKey = new SchedulerRequestKey(Priority.newInstance((int)1), 2L, TestUtils.getMockContainerId(1, 1));
        this.rmContext.setAllocationTagsManager(this.spyAllocationTagsManager);
        this.rmContext.setPlacementConstraintManager((PlacementConstraintManager)placementConstraintManager);
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
    }

    private void assertValidSchedulingRequest(SchedulingRequest schedulingRequest) {
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest, false);
    }

    private void assertInvalidSchedulingRequest(SchedulingRequest schedulingRequest, boolean recreateAllocator) {
        try {
            if (recreateAllocator) {
                this.allocator = new SingleConstraintAppPlacementAllocator();
                this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
            }
            this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest, false);
        }
        catch (SchedulerInvalidResoureRequestException e) {
            return;
        }
        Assert.fail((String)("Expect failure for schedulingRequest=" + schedulingRequest.toString()));
    }

    @Test
    public void testSchedulingRequestValidation() {
        this.assertValidSchedulingRequest(SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{""})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build());
        Assert.assertEquals((Object)"", (Object)this.allocator.getTargetNodePartition());
        this.assertValidSchedulingRequest(SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{"x"})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build());
        Assert.assertEquals((Object)"x", (Object)this.allocator.getTargetNodePartition());
        this.assertValidSchedulingRequest(SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build());
        Assert.assertEquals((Object)"y", (Object)this.allocator.getTargetNodePartition());
        this.assertValidSchedulingRequest(SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build());
        Assert.assertEquals((Object)"y", (Object)this.allocator.getTargetNodePartition());
        this.assertInvalidSchedulingRequest(SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"})}).build()).build(), true);
        this.assertInvalidSchedulingRequest(SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[0]).build()).build(), true);
        this.assertInvalidSchedulingRequest(SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{""})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build(), true);
    }

    @Test
    public void testSchedulingRequestUpdate() {
        SchedulingRequest schedulingRequest = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{""})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest, false);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest, false);
        schedulingRequest.getResourceSizing().setNumAllocations(10);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest, false);
        SchedulingRequest newSchedulingRequest = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{""}), PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"})}).build()).resourceSizing(ResourceSizing.newInstance((int)11, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.allocator.updatePendingAsk(this.schedulerRequestKey, newSchedulingRequest, false);
        schedulingRequest.getResourceSizing().setResources(Resource.newInstance((int)2048, (int)1));
        this.assertInvalidSchedulingRequest(schedulingRequest, false);
        schedulingRequest = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetCardinality((String)"node", (int)0, (int)1, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{""})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.assertInvalidSchedulingRequest(schedulingRequest, false);
        int existingNumAllocations = this.allocator.getSchedulingRequest().getResourceSizing().getNumAllocations();
        schedulingRequest = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{""})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest, true);
        Assert.assertEquals((long)(existingNumAllocations + 1), (long)this.allocator.getSchedulingRequest().getResourceSizing().getNumAllocations());
    }

    @Test
    public void testFunctionality() throws InvalidAllocationTagsQueryException {
        SchedulingRequest schedulingRequest = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{""})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest, false);
        this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNode("host1", "/rack1", 123, 1024));
        ((AllocationTagsManager)Mockito.verify((Object)this.spyAllocationTagsManager, (VerificationMode)Mockito.times((int)1))).getNodeCardinalityByOp((NodeId)ArgumentMatchers.eq((Object)NodeId.fromString((String)"host1:123")), (AllocationTags)ArgumentMatchers.any(AllocationTags.class), (LongBinaryOperator)ArgumentMatchers.any(LongBinaryOperator.class));
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
        schedulingRequest = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"mapper", "reducer"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{"x"})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest, false);
        this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNode("host1", "/rack1", 123, 1024));
        ((AllocationTagsManager)Mockito.verify((Object)this.spyAllocationTagsManager, (VerificationMode)Mockito.atLeast((int)1))).getNodeCardinalityByOp((NodeId)ArgumentMatchers.eq((Object)NodeId.fromString((String)"host1:123")), (AllocationTags)ArgumentMatchers.any(AllocationTags.class), (LongBinaryOperator)ArgumentMatchers.any(LongBinaryOperator.class));
        SchedulerNode node1 = (SchedulerNode)Mockito.mock(SchedulerNode.class);
        Mockito.when((Object)node1.getPartition()).thenReturn((Object)"x");
        Mockito.when((Object)node1.getNodeID()).thenReturn((Object)NodeId.fromString((String)"host1:123"));
        Assert.assertTrue((boolean)this.allocator.precheckNode(node1, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY));
        SchedulerNode node2 = (SchedulerNode)Mockito.mock(SchedulerNode.class);
        Mockito.when((Object)node1.getPartition()).thenReturn((Object)"");
        Mockito.when((Object)node1.getNodeID()).thenReturn((Object)NodeId.fromString((String)"host2:123"));
        Assert.assertFalse((boolean)this.allocator.precheckNode(node2, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY));
    }

    @Test
    public void testNodeAttributesFunctionality() {
        SchedulingRequest schedulingRequest = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodeAttribute((String)"java", (String[])new String[]{"1.8"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{""})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest, false);
        HashSet<Object> attributes = new HashSet<NodeAttribute>();
        attributes.add(NodeAttribute.newInstance((String)"java", (NodeAttributeType)NodeAttributeType.STRING, (String)"1.8"));
        boolean result = this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNodeWithAttributes("host1", "/rack1", 123, 1024, attributes));
        Assert.assertTrue((String)"Allocation should be success for java=1.8", (boolean)result);
        SchedulingRequest schedulingRequest2 = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.NE, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodeAttribute((String)"python", (String[])new String[]{"3"}), PlacementConstraints.PlacementTargets.nodePartition((String[])new String[]{""})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest2, false);
        attributes = new HashSet();
        result = this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNodeWithAttributes("host1", "/rack1", 123, 1024, attributes));
        Assert.assertTrue((String)"Allocation should be success as python doesn't exist", (boolean)result);
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest2, false);
        attributes = new HashSet();
        attributes.add(NodeAttribute.newInstance((String)"python", (NodeAttributeType)NodeAttributeType.STRING, (String)"2"));
        result = this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNodeWithAttributes("host1", "/rack1", 123, 1024, attributes));
        Assert.assertTrue((String)"Allocation should be success as python=3 doesn't exist in node", (boolean)result);
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest2, false);
        attributes = new HashSet();
        attributes.add(NodeAttribute.newInstance((String)"python", (NodeAttributeType)NodeAttributeType.STRING, (String)"3"));
        result = this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNodeWithAttributes("host1", "/rack1", 123, 1024, attributes));
        Assert.assertFalse((String)"Allocation should fail as python=3 exist in node", (boolean)result);
    }

    @Test
    public void testConjunctionNodeAttributesFunctionality() {
        SchedulingRequest schedulingRequest1 = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.NE, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodeAttribute((String)"python", (String[])new String[]{"3"})}), PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodeAttribute((String)"java", (String[])new String[]{"1.8"})})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest1, false);
        HashSet<Object> attributes = new HashSet<NodeAttribute>();
        attributes.add(NodeAttribute.newInstance((String)"python", (NodeAttributeType)NodeAttributeType.STRING, (String)"3"));
        attributes.add(NodeAttribute.newInstance((String)"java", (NodeAttributeType)NodeAttributeType.STRING, (String)"1.8"));
        boolean result = this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNodeWithAttributes("host1", "/rack1", 123, 1024, attributes));
        Assert.assertFalse((String)"Allocation should fail as python=3 exists in node", (boolean)result);
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest1, false);
        attributes = new HashSet();
        attributes.add(NodeAttribute.newInstance((String)"python", (NodeAttributeType)NodeAttributeType.STRING, (String)"2"));
        attributes.add(NodeAttribute.newInstance((String)"java", (NodeAttributeType)NodeAttributeType.STRING, (String)"1.8"));
        result = this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNodeWithAttributes("host1", "/rack1", 123, 1024, attributes));
        Assert.assertTrue((String)"Allocation should be success as python=2 exists in node", (boolean)result);
        SchedulingRequest schedulingRequest2 = SchedulingRequest.newBuilder().executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED)).allocationRequestId(10L).priority(Priority.newInstance((int)1)).placementConstraintExpression(PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.NE, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodeAttribute((String)"python", (String[])new String[]{"3"})}), PlacementConstraints.targetNodeAttribute((String)"node", (NodeAttributeOpCode)NodeAttributeOpCode.EQ, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.nodeAttribute((String)"java", (String[])new String[]{"1.8"})})}).build()).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1))).build();
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest2, false);
        attributes = new HashSet();
        attributes.add(NodeAttribute.newInstance((String)"python", (NodeAttributeType)NodeAttributeType.STRING, (String)"3"));
        attributes.add(NodeAttribute.newInstance((String)"java", (NodeAttributeType)NodeAttributeType.STRING, (String)"1.8"));
        result = this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNodeWithAttributes("host1", "/rack1", 123, 1024, attributes));
        Assert.assertTrue((String)"Allocation should be success as java=1.8 exists in node", (boolean)result);
        this.allocator = new SingleConstraintAppPlacementAllocator();
        this.allocator.initialize(this.appSchedulingInfo, this.schedulerRequestKey, this.rmContext);
        this.allocator.updatePendingAsk(this.schedulerRequestKey, schedulingRequest2, false);
        attributes = new HashSet();
        attributes.add(NodeAttribute.newInstance((String)"python", (NodeAttributeType)NodeAttributeType.STRING, (String)"3"));
        attributes.add(NodeAttribute.newInstance((String)"java", (NodeAttributeType)NodeAttributeType.STRING, (String)"1.7"));
        result = this.allocator.canAllocate(NodeType.NODE_LOCAL, (SchedulerNode)TestUtils.getMockNodeWithAttributes("host1", "/rack1", 123, 1024, attributes));
        Assert.assertFalse((String)"Allocation should fail as java=1.8 doesnt exist in node", (boolean)result);
    }
}

