/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.List;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ClusterNodeTracker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.VisitedResourceRequestTracker;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestVisitedResourceRequestTracker {
    private final ClusterNodeTracker<FSSchedulerNode> nodeTracker = new ClusterNodeTracker();
    private final ResourceRequest anyRequest;
    private final ResourceRequest rackRequest;
    private final ResourceRequest node1Request;
    private final ResourceRequest node2Request;
    private final String NODE_VISITED = "The node is already visited. ";
    private final String RACK_VISITED = "The rack is already visited. ";
    private final String ANY_VISITED = "ANY is already visited. ";
    private final String NODE_FAILURE = "The node is visited again.";
    private final String RACK_FAILURE = "The rack is visited again.";
    private final String ANY_FAILURE = "ANY is visited again.";
    private final String FIRST_CALL_FAILURE = "First call to visit failed.";

    public TestVisitedResourceRequestTracker() {
        List<RMNode> rmNodes = MockNodes.newNodes(1, 2, Resources.createResource((int)8192, (int)8));
        FSSchedulerNode node1 = new FSSchedulerNode(rmNodes.get(0), false);
        this.nodeTracker.addNode((SchedulerNode)node1);
        this.node1Request = this.createRR(node1.getNodeName(), 1);
        FSSchedulerNode node2 = new FSSchedulerNode(rmNodes.get(1), false);
        this.node2Request = this.createRR(node2.getNodeName(), 1);
        this.nodeTracker.addNode((SchedulerNode)node2);
        this.anyRequest = this.createRR("*", 2);
        this.rackRequest = this.createRR(node1.getRackName(), 2);
    }

    private ResourceRequest createRR(String resourceName, int count) {
        return ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)resourceName, (Resource)Resources.none(), (int)count);
    }

    @Test
    public void testVisitAnyRequestFirst() {
        VisitedResourceRequestTracker tracker = new VisitedResourceRequestTracker(this.nodeTracker);
        Assert.assertTrue((String)"First call to visit failed.", (boolean)tracker.visit(this.anyRequest));
        Assert.assertFalse((String)"ANY is already visited. The rack is visited again.", (boolean)tracker.visit(this.rackRequest));
        Assert.assertFalse((String)"ANY is already visited. The node is visited again.", (boolean)tracker.visit(this.node1Request));
        Assert.assertFalse((String)"ANY is already visited. The node is visited again.", (boolean)tracker.visit(this.node2Request));
    }

    @Test
    public void testVisitRackRequestFirst() {
        VisitedResourceRequestTracker tracker = new VisitedResourceRequestTracker(this.nodeTracker);
        Assert.assertTrue((String)"First call to visit failed.", (boolean)tracker.visit(this.rackRequest));
        Assert.assertFalse((String)"The rack is already visited. ANY is visited again.", (boolean)tracker.visit(this.anyRequest));
        Assert.assertFalse((String)"The rack is already visited. The node is visited again.", (boolean)tracker.visit(this.node1Request));
        Assert.assertFalse((String)"The rack is already visited. The node is visited again.", (boolean)tracker.visit(this.node2Request));
    }

    @Test
    public void testVisitNodeRequestFirst() {
        VisitedResourceRequestTracker tracker = new VisitedResourceRequestTracker(this.nodeTracker);
        Assert.assertTrue((String)"First call to visit failed.", (boolean)tracker.visit(this.node1Request));
        Assert.assertFalse((String)"The node is already visited. ANY is visited again.", (boolean)tracker.visit(this.anyRequest));
        Assert.assertFalse((String)"The node is already visited. The rack is visited again.", (boolean)tracker.visit(this.rackRequest));
        Assert.assertTrue((String)"The node is already visited. Different node visit failed", (boolean)tracker.visit(this.node2Request));
    }
}

