/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestSchedulingRequestContainerAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSchedulingRequestContainerAllocationAsync {
    private final int GB = 1024;
    private YarnConfiguration conf;
    private String placementConstraintHandler;
    RMNodeLabelsManager mgr;

    @Parameterized.Parameters
    public static Collection<Object[]> placementConstarintHandlers() {
        Object[][] params = new Object[][]{{"placement-processor"}, {"scheduler"}};
        return Arrays.asList(params);
    }

    public TestSchedulingRequestContainerAllocationAsync(String placementConstraintHandler) {
        this.placementConstraintHandler = placementConstraintHandler;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.conf.set("yarn.resourcemanager.placement-constraints.handler", this.placementConstraintHandler);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    private void testIntraAppAntiAffinityAsync(int numThreads) throws Exception {
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        csConf.setInt("yarn.scheduler.capacity.schedule-asynchronously.maximum-threads", numThreads);
        csConf.setInt("yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms", 0);
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocationAsync.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        int nNMs = 200;
        MockNM[] nms = new MockNM[nNMs];
        RMNode[] rmNodes = new RMNode[nNMs];
        for (int i = 0; i < nNMs; ++i) {
            nms[i] = rm1.registerNode("127.0.0." + i + ":1234", 10240);
            rmNodes[i] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i].getNodeId());
        }
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)1000, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"mapper"), "mapper");
        List<Container> allocated = TestSchedulingRequestContainerAllocation.waitForAllocation(nNMs, 6000, am1, nms);
        Assert.assertEquals((long)nNMs, (long)allocated.size());
        Assert.assertEquals((long)nNMs, (long)TestSchedulingRequestContainerAllocation.getContainerNodesNum(allocated));
        rm1.close();
    }

    @Test(timeout=300000L)
    public void testSingleThreadAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(1);
    }

    @Test(timeout=300000L)
    public void testTwoThreadsAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(2);
    }

    @Test(timeout=300000L)
    public void testThreeThreadsAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(3);
    }

    @Test(timeout=300000L)
    public void testFourThreadsAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(4);
    }

    @Test(timeout=300000L)
    public void testFiveThreadsAsyncContainerAllocation() throws Exception {
        this.testIntraAppAntiAffinityAsync(5);
    }
}

