/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.metrics.CustomResourceMetricValue;
import org.apache.hadoop.yarn.resourcetypes.ResourceTypesTestHelper;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetricsTestData;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceMetricsChecker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestQueueMetrics;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueueMetricsForCustomResources {
    public static final long GB = 1024L;
    private static final Configuration CONF = new Configuration();
    public static final String CUSTOM_RES_1 = "custom_res_1";
    public static final String CUSTOM_RES_2 = "custom_res_2";
    public static final String USER = "alice";
    private Resource defaultResource;
    private MetricsSystem ms;

    @Before
    public void setUp() {
        this.ms = new MetricsSystemImpl();
        QueueMetrics.clearQueueMetrics();
        this.initializeResourceTypes();
        this.createDefaultResource();
    }

    private void createDefaultResource() {
        this.defaultResource = ResourceTypesTestHelper.newResource((long)4096L, (int)4, (Map)ImmutableMap.builder().put((Object)CUSTOM_RES_1, (Object)String.valueOf(15360L)).put((Object)CUSTOM_RES_2, (Object)String.valueOf(20480L)).build());
    }

    private void initializeResourceTypes() {
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        ResourceInformation res1 = ResourceInformation.newInstance((String)CUSTOM_RES_1, (String)ResourceInformation.VCORES.getUnits(), (long)0L, (long)2000L);
        ResourceInformation res2 = ResourceInformation.newInstance((String)CUSTOM_RES_2, (String)ResourceInformation.VCORES.getUnits(), (long)0L, (long)2000L);
        riMap.put("memory-mb", memory);
        riMap.put("vcores", vcores);
        riMap.put(CUSTOM_RES_1, res1);
        riMap.put(CUSTOM_RES_2, res2);
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
    }

    private static void assertCustomResourceValue(QueueMetrics metrics, MetricsForCustomResource metricsType, Function<QueueMetrics, Resource> func, String resourceName, long expectedValue) {
        Resource res = func.apply(metrics);
        Long value = res.getResourceValue(resourceName);
        TestQueueMetricsForCustomResources.assertCustomResourceValueInternal(metricsType, resourceName, expectedValue, value);
    }

    private static void assertCustomResourceValueInternal(MetricsForCustomResource metricsType, String resourceName, long expectedValue, Long value) {
        Assert.assertNotNull((String)("QueueMetrics should have custom resource metrics value for resource: " + resourceName), (Object)value);
        Assert.assertEquals((String)String.format("QueueMetrics should have custom resource metrics value %d for resource: %s for metrics type %s", new Object[]{expectedValue, resourceName, metricsType}), (long)expectedValue, (long)value);
    }

    private static Map<String, String> getCustomResourcesWithValue(long value) {
        return ImmutableMap.builder().put((Object)CUSTOM_RES_1, (Object)String.valueOf(value)).put((Object)CUSTOM_RES_2, (Object)String.valueOf(value)).build();
    }

    private QueueInfo createFourLevelQueueHierarchy() {
        QueueInfo root = new QueueInfo(null, "root", this.ms, CONF, USER);
        QueueInfo sub = new QueueInfo(root, "root.subQ", this.ms, CONF, USER);
        QueueInfo sub2 = new QueueInfo(sub, "root.subQ2", this.ms, CONF, USER);
        return new QueueInfo(sub2, "root.subQ2.leafQ", this.ms, CONF, USER);
    }

    private QueueInfo createBasicQueueHierarchy() {
        QueueInfo root = new QueueInfo(null, "root", this.ms, CONF, USER);
        return new QueueInfo(root, "root.leaf", this.ms, CONF, USER);
    }

    private QueueMetricsTestData.Builder createQueueMetricsTestDataWithContainers(int containers) {
        return this.createDefaultQueueMetricsTestData().withContainers(containers);
    }

    private QueueMetricsTestData.Builder createDefaultQueueMetricsTestData() {
        return QueueMetricsTestData.Builder.create().withUser(USER).withPartition("");
    }

    private void testIncreasePendingResources(QueueMetricsTestData testData) {
        this.testIncreasePendingResourcesInternal(testData.containers, testData);
    }

    private void testIncreasePendingResourcesWithoutContainer(QueueMetricsTestData testData) {
        this.testIncreasePendingResourcesInternal(1, testData);
    }

    private void testIncreasePendingResourcesInternal(int containers, QueueMetricsTestData testData) {
        testData.leafQueue.queueMetrics.incrPendingResources(testData.partition, testData.user, containers, testData.resource);
        ResourceMetricsChecker checker = ResourceMetricsChecker.create().gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, containers).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, (long)containers * testData.resource.getMemorySize()).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, containers * testData.resource.getVirtualCores()).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CUSTOM_RES1, (long)containers * testData.customResourceValues.get(CUSTOM_RES_1)).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CUSTOM_RES2, (long)containers * testData.customResourceValues.get(CUSTOM_RES_2));
        this.assertAllMetrics(testData.leafQueue, checker, QueueMetrics::getPendingResources, MetricsForCustomResource.PENDING, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> v * (long)containers));
    }

    private void testAllocateResources(boolean decreasePending, QueueMetricsTestData testData) {
        testData.leafQueue.queueMetrics.allocateResources(testData.partition, testData.user, testData.containers, testData.resource, decreasePending);
        ResourceMetricsChecker checker = ResourceMetricsChecker.create().gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, testData.containers).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, testData.containers).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, (long)testData.containers * testData.resource.getMemorySize()).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, testData.containers * testData.resource.getVirtualCores()).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 0).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 0L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 0).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CUSTOM_RES1, (long)testData.containers * testData.customResourceValues.get(CUSTOM_RES_1)).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CUSTOM_RES2, (long)testData.containers * testData.customResourceValues.get(CUSTOM_RES_2)).checkAgainst(testData.leafQueue.queueSource);
        if (decreasePending) {
            this.assertAllMetrics(testData.leafQueue, checker, QueueMetrics::getPendingResources, MetricsForCustomResource.PENDING, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> 0L));
        }
        if (!testData.customResourceValues.isEmpty()) {
            this.assertAllMetrics(testData.leafQueue, checker, QueueMetrics::getAllocatedResources, MetricsForCustomResource.ALLOCATED, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> v * (long)testData.containers));
        }
    }

    private void testUpdatePreemptedSeconds(QueueMetricsTestData testData, int seconds) {
        testData.leafQueue.queueMetrics.updatePreemptedMemoryMBSeconds(testData.resource.getMemorySize() * (long)seconds);
        testData.leafQueue.queueMetrics.updatePreemptedVcoreSeconds((long)(testData.resource.getVirtualCores() * seconds));
        testData.leafQueue.queueMetrics.updatePreemptedSecondsForCustomResources(testData.resource, (long)seconds);
        ResourceMetricsChecker checker = ResourceMetricsChecker.create().counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_MEMORY_MB_SECONDS_PREEMPTED, testData.resource.getMemorySize() * (long)seconds).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_VCORE_SECONDS_PREEMPTED, testData.resource.getVirtualCores() * seconds).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_PREEMPTED_SECONDS_CUSTOM_RES1, testData.customResourceValues.get(CUSTOM_RES_1) * (long)seconds).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_PREEMPTED_SECONDS_CUSTOM_RES2, testData.customResourceValues.get(CUSTOM_RES_2) * (long)seconds);
        this.assertQueueMetricsOnly(testData.leafQueue, checker, this::convertPreemptedSecondsToResource, MetricsForCustomResource.AGGREGATE_PREEMPTED_SECONDS, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> v * (long)seconds));
    }

    private Resource convertPreemptedSecondsToResource(QueueMetrics qm) {
        CustomResourceMetricValue customValues = qm.getAggregatedPreemptedSecondsResources();
        MutableCounterLong vcoreSeconds = qm.getAggregateVcoreSecondsPreempted();
        MutableCounterLong memorySeconds = qm.getAggregateMemoryMBSecondsPreempted();
        return Resource.newInstance((long)memorySeconds.value(), (int)((int)vcoreSeconds.value()), (Map)customValues.getValues());
    }

    private void testReserveResources(QueueMetricsTestData testData) {
        testData.leafQueue.queueMetrics.reserveResource(testData.partition, testData.user, testData.resource);
        ResourceMetricsChecker checker = ResourceMetricsChecker.create().gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 1).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, testData.resource.getMemorySize()).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, testData.resource.getVirtualCores()).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CUSTOM_RES1, testData.customResourceValues.get(CUSTOM_RES_1)).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CUSTOM_RES2, testData.customResourceValues.get(CUSTOM_RES_2)).checkAgainst(testData.leafQueue.queueSource);
        this.assertAllMetrics(testData.leafQueue, checker, QueueMetrics::getReservedResources, MetricsForCustomResource.RESERVED, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> v));
    }

    private void testGetAllocatedResources(QueueMetricsTestData testData) {
        this.testAllocateResources(false, testData);
        Resource res = testData.leafQueue.queueMetrics.getAllocatedResources();
        if (testData.customResourceValues.size() > 0) {
            TestQueueMetricsForCustomResources.assertCustomResourceValueInternal(MetricsForCustomResource.ALLOCATED, CUSTOM_RES_1, testData.customResourceValues.get(CUSTOM_RES_1) * (long)testData.containers, res.getResourceValue(CUSTOM_RES_1));
            TestQueueMetricsForCustomResources.assertCustomResourceValueInternal(MetricsForCustomResource.ALLOCATED, CUSTOM_RES_2, testData.customResourceValues.get(CUSTOM_RES_2) * (long)testData.containers, res.getResourceValue(CUSTOM_RES_2));
        }
    }

    private void assertAllMetrics(QueueInfo queueInfo, ResourceMetricsChecker checker, Function<QueueMetrics, Resource> func, MetricsForCustomResource metricsType, Map<String, Long> expectedCustomResourceValues) {
        this.assertAllQueueMetrics(queueInfo, checker, func, metricsType, expectedCustomResourceValues);
        checker = ResourceMetricsChecker.createFromChecker(checker).checkAgainst(queueInfo.userSource);
        ResourceMetricsChecker.createFromChecker(checker).checkAgainst(queueInfo.getRoot().userSource);
    }

    private void assertQueueMetricsOnly(QueueInfo queueInfo, ResourceMetricsChecker checker, Function<QueueMetrics, Resource> func, MetricsForCustomResource metricsType, Map<String, Long> expectedCustomResourceValues) {
        this.assertAllQueueMetrics(queueInfo, checker, func, metricsType, expectedCustomResourceValues);
    }

    private void assertAllQueueMetrics(QueueInfo queueInfo, ResourceMetricsChecker checker, Function<QueueMetrics, Resource> func, MetricsForCustomResource metricsType, Map<String, Long> expectedCustomResourceValues) {
        queueInfo.checkAllQueueSources(qs -> ResourceMetricsChecker.createFromChecker(checker).checkAgainst((MetricsSource)qs));
        queueInfo.checkAllQueueMetrics(qm -> {
            TestQueueMetricsForCustomResources.assertCustomResourceValue(qm, metricsType, func, CUSTOM_RES_1, (Long)expectedCustomResourceValues.get(CUSTOM_RES_1));
            TestQueueMetricsForCustomResources.assertCustomResourceValue(qm, metricsType, func, CUSTOM_RES_2, (Long)expectedCustomResourceValues.get(CUSTOM_RES_2));
        });
    }

    private Map<String, Long> computeExpectedCustomResourceValues(Map<String, Long> customResourceValues, BiFunction<String, Long, Long> func) {
        HashMap values = Maps.newHashMap();
        for (Map.Entry<String, Long> res : customResourceValues.entrySet()) {
            values.put(res.getKey(), func.apply(res.getKey(), res.getValue()));
        }
        return values;
    }

    @Test
    public void testSetAvailableResourcesToQueue1() {
        String queueName = "single";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)CONF);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        metrics.setAvailableResourcesToQueue(ResourceTypesTestHelper.newResource((long)1024L, (int)4, (Map)ImmutableMap.builder().put((Object)CUSTOM_RES_1, (Object)String.valueOf(5120L)).put((Object)CUSTOM_RES_2, (Object)String.valueOf(6144L)).build()));
        ResourceMetricsChecker.create().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_MB, 1024L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_V_CORES, 4).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_CUSTOM_RES1, 5120L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_CUSTOM_RES2, 6144L).checkAgainst(queueSource);
        TestQueueMetricsForCustomResources.assertCustomResourceValue(metrics, MetricsForCustomResource.AVAILABLE, QueueMetrics::getAvailableResources, CUSTOM_RES_1, 5120L);
        TestQueueMetricsForCustomResources.assertCustomResourceValue(metrics, MetricsForCustomResource.AVAILABLE, QueueMetrics::getAvailableResources, CUSTOM_RES_2, 6144L);
    }

    @Test
    public void testSetAvailableResourcesToQueue2() {
        String queueName = "single";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)CONF);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        metrics.setAvailableResourcesToQueue(null, ResourceTypesTestHelper.newResource((long)1024L, (int)4, (Map)ImmutableMap.builder().put((Object)CUSTOM_RES_1, (Object)String.valueOf(15360L)).put((Object)CUSTOM_RES_2, (Object)String.valueOf(20480L)).build()));
        ResourceMetricsChecker.create().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_MB, 1024L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_V_CORES, 4).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_CUSTOM_RES1, 15360L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_CUSTOM_RES2, 20480L).checkAgainst(queueSource);
        TestQueueMetricsForCustomResources.assertCustomResourceValue(metrics, MetricsForCustomResource.AVAILABLE, QueueMetrics::getAvailableResources, CUSTOM_RES_1, 15360L);
        TestQueueMetricsForCustomResources.assertCustomResourceValue(metrics, MetricsForCustomResource.AVAILABLE, QueueMetrics::getAvailableResources, CUSTOM_RES_2, 20480L);
    }

    @Test
    public void testIncreasePendingResources() {
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(5).withLeafQueue(this.createBasicQueueHierarchy()).withResourceToDecrease(ResourceTypesTestHelper.newResource((long)1024L, (int)2, TestQueueMetricsForCustomResources.getCustomResourcesWithValue(2048L)), 2).withResources(this.defaultResource).build();
        this.testIncreasePendingResources(testData);
    }

    @Test
    public void testDecreasePendingResources() {
        Resource resourceToDecrease = ResourceTypesTestHelper.newResource((long)1024L, (int)2, TestQueueMetricsForCustomResources.getCustomResourcesWithValue(2048L));
        int containersToDecrease = 2;
        int containers = 5;
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(containers).withLeafQueue(this.createBasicQueueHierarchy()).withResourceToDecrease(resourceToDecrease, containers).withResources(this.defaultResource).build();
        int vCoresToDecrease = resourceToDecrease.getVirtualCores();
        long memoryMBToDecrease = resourceToDecrease.getMemorySize();
        int containersAfterDecrease = containers - containersToDecrease;
        long customRes1ToDecrease = resourceToDecrease.getResourceValue(CUSTOM_RES_1);
        long customRes2ToDecrease = resourceToDecrease.getResourceValue(CUSTOM_RES_2);
        int vcoresAfterDecrease = this.defaultResource.getVirtualCores() * containers - vCoresToDecrease * containersToDecrease;
        long memoryAfterDecrease = this.defaultResource.getMemorySize() * (long)containers - memoryMBToDecrease * (long)containersToDecrease;
        long customResource1AfterDecrease = testData.customResourceValues.get(CUSTOM_RES_1) * (long)containers - customRes1ToDecrease * (long)containersToDecrease;
        long customResource2AfterDecrease = testData.customResourceValues.get(CUSTOM_RES_2) * (long)containers - customRes2ToDecrease * (long)containersToDecrease;
        this.testIncreasePendingResources(testData);
        testData.leafQueue.queueMetrics.decrPendingResources(testData.partition, testData.user, containersToDecrease, ResourceTypesTestHelper.newResource((long)memoryMBToDecrease, (int)vCoresToDecrease, (Map)ResourceTypesTestHelper.extractCustomResourcesAsStrings((Resource)resourceToDecrease)));
        ResourceMetricsChecker checker = ResourceMetricsChecker.create().gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, containersAfterDecrease).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, memoryAfterDecrease).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, vcoresAfterDecrease).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CUSTOM_RES1, customResource1AfterDecrease).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CUSTOM_RES2, customResource2AfterDecrease).checkAgainst(testData.leafQueue.queueSource);
        this.assertAllMetrics(testData.leafQueue, checker, QueueMetrics::getPendingResources, MetricsForCustomResource.PENDING, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> v * (long)containers - resourceToDecrease.getResourceValue(k) * (long)containersToDecrease));
    }

    @Test
    public void testAllocateResourcesWithoutDecreasePending() {
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(5).withLeafQueue(this.createBasicQueueHierarchy()).withResources(this.defaultResource).build();
        this.testAllocateResources(false, testData);
    }

    @Test
    public void testAllocateResourcesWithDecreasePending() {
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(5).withLeafQueue(this.createBasicQueueHierarchy()).withResourceToDecrease(ResourceTypesTestHelper.newResource((long)1024L, (int)2, TestQueueMetricsForCustomResources.getCustomResourcesWithValue(2048L)), 2).withResources(this.defaultResource).build();
        this.testIncreasePendingResources(testData);
        this.testAllocateResources(true, testData);
    }

    @Test
    public void testAllocateResourcesWithoutContainer() {
        QueueMetricsTestData testData = this.createDefaultQueueMetricsTestData().withLeafQueue(this.createBasicQueueHierarchy()).withResources(this.defaultResource).build();
        this.testIncreasePendingResourcesWithoutContainer(testData);
        Resource resource = testData.resource;
        testData.leafQueue.queueMetrics.allocateResources(testData.partition, testData.user, resource);
        ResourceMetricsChecker checker = ResourceMetricsChecker.create().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, resource.getMemorySize()).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, resource.getVirtualCores()).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 1).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 0L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 0).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CUSTOM_RES1, testData.customResourceValues.get(CUSTOM_RES_1)).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CUSTOM_RES2, testData.customResourceValues.get(CUSTOM_RES_2));
        checker.checkAgainst(testData.leafQueue.queueSource);
        checker.checkAgainst(testData.leafQueue.getRoot().queueSource);
        this.assertAllMetrics(testData.leafQueue, checker, QueueMetrics::getPendingResources, MetricsForCustomResource.PENDING, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> 0L));
        this.assertAllMetrics(testData.leafQueue, checker, QueueMetrics::getAllocatedResources, MetricsForCustomResource.ALLOCATED, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> v));
    }

    @Test
    public void testReleaseResources() {
        int containers = 5;
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(containers).withLeafQueue(this.createBasicQueueHierarchy()).withResourceToDecrease(this.defaultResource, containers).withResources(this.defaultResource).build();
        this.testAllocateResources(false, testData);
        testData.leafQueue.queueMetrics.releaseResources(testData.partition, testData.user, containers, this.defaultResource);
        ResourceMetricsChecker checker = ResourceMetricsChecker.create().counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, containers).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, containers).checkAgainst(testData.leafQueue.queueSource);
        this.assertAllMetrics(testData.leafQueue, checker, QueueMetrics::getAllocatedResources, MetricsForCustomResource.ALLOCATED, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> 0L));
    }

    @Test
    public void testUpdatePreemptedSecondsForCustomResources() {
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(5).withLeafQueue(this.createFourLevelQueueHierarchy()).withResources(this.defaultResource).build();
        boolean seconds = true;
        this.testUpdatePreemptedSeconds(testData, 1);
    }

    @Test
    public void testUpdatePreemptedSecondsForCustomResourcesMoreSeconds() {
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(5).withLeafQueue(this.createFourLevelQueueHierarchy()).withResources(this.defaultResource).build();
        int seconds = 15;
        this.testUpdatePreemptedSeconds(testData, 15);
    }

    @Test
    public void testReserveResources() {
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(5).withLeafQueue(this.createBasicQueueHierarchy()).withResources(this.defaultResource).build();
        this.testReserveResources(testData);
    }

    @Test
    public void testUnreserveResources() {
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(5).withLeafQueue(this.createBasicQueueHierarchy()).withResources(this.defaultResource).build();
        this.testReserveResources(testData);
        testData.leafQueue.queueMetrics.unreserveResource(testData.partition, testData.user, this.defaultResource);
        ResourceMetricsChecker checker = ResourceMetricsChecker.create().gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 0).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, 0L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, 0).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CUSTOM_RES1, 0L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CUSTOM_RES2, 0L).checkAgainst(testData.leafQueue.queueSource);
        this.assertAllMetrics(testData.leafQueue, checker, QueueMetrics::getReservedResources, MetricsForCustomResource.RESERVED, this.computeExpectedCustomResourceValues(testData.customResourceValues, (k, v) -> 0L));
    }

    @Test
    public void testGetAllocatedResourcesWithCustomResources() {
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(5).withLeafQueue(this.createBasicQueueHierarchy()).withResources(this.defaultResource).build();
        this.testGetAllocatedResources(testData);
    }

    @Test
    public void testGetAllocatedResourcesWithoutCustomResources() {
        QueueMetricsTestData testData = this.createQueueMetricsTestDataWithContainers(5).withResources(ResourceTypesTestHelper.newResource((long)4096L, (int)4, Collections.emptyMap())).withLeafQueue(this.createBasicQueueHierarchy()).build();
        this.testGetAllocatedResources(testData);
    }

    public static enum MetricsForCustomResource {
        ALLOCATED,
        AVAILABLE,
        PENDING,
        RESERVED,
        AGGREGATE_PREEMPTED_SECONDS;

    }
}

