/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.FifoCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.PreemptionCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyPreemptToBalance
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Test
    public void testPreemptionToBalanceDisabled() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 10 30]);-b(=[30 100 40 30]);-c(=[30 100 50 30]);-d(=[10 100 0 0])";
        String appsConfig = "a\t(1,1,n1,,10,false);b\t(1,1,n1,,40,false);c\t(1,1,n1,,50,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)5))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)15))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        Assert.assertEquals((long)30L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.a")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)35L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.b")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)35L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.c")).get("")).getIdealAssigned().getMemorySize());
    }

    @Test
    public void testPreemptionToBalanceEnabled() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 10 30]);-b(=[30 100 40 30]);-c(=[30 100 50 30]);-d(=[10 100 0 0])";
        String appsConfig = "a\t(1,1,n1,,10,false);b\t(1,1,n1,,40,false);c\t(1,1,n1,,50,false)";
        boolean isPreemptionToBalanceEnabled = true;
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.enabled", isPreemptionToBalanceEnabled);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)17))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        Assert.assertEquals((long)33L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.a")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)33L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.b")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)33L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.c")).get("")).getIdealAssigned().getMemorySize());
    }

    @Test
    public void testPreemptionToBalanceUsedPlusPendingLessThanGuaranteed() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 10 6]);-b(=[30 100 40 30]);-c(=[30 100 50 30]);-d(=[10 100 0 0])";
        String appsConfig = "a\t(1,1,n1,,10,false);b\t(1,1,n1,,40,false);c\t(1,1,n1,,50,false)";
        boolean isPreemptionToBalanceEnabled = true;
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.enabled", isPreemptionToBalanceEnabled);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)8))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        Assert.assertEquals((long)16L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.a")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)42L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.b")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)42L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.c")).get("")).getIdealAssigned().getMemorySize());
    }

    @Test
    public void testPreemptionToBalanceWithVcoreResource() throws IOException {
        Logger.getRootLogger().setLevel(Level.DEBUG);
        String labelsConfig = "=100:100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100:100 100:100 100:100 120:140]);-a(=[60:60 100:100 40:40 70:40]);-b(=[40:40 100:100 60:60 50:100])";
        String appsConfig = "a\t(1,1:1,n1,,40,false);b\t(1,1:1,n1,,60,false)";
        boolean isPreemptionToBalanceEnabled = true;
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.enabled", isPreemptionToBalanceEnabled);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, true);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)21))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        Assert.assertEquals((long)60L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.a")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)60L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.a")).get("")).getIdealAssigned().getVirtualCores());
        Assert.assertEquals((long)40L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.b")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)40L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.b")).get("")).getIdealAssigned().getVirtualCores());
    }

    @Test
    public void testPreemptionToBalanceWithConfiguredTimeout() throws IOException {
        Logger.getRootLogger().setLevel(Level.DEBUG);
        String labelsConfig = "=100:100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100:100 100:100 100:100 120:140]);-a(=[60:60 100:100 40:40 70:40]);-b(=[40:40 100:100 60:60 50:100])";
        String appsConfig = "a\t(1,1:1,n1,,40,false);b\t(1,1:1,n1,,60,false)";
        boolean isPreemptionToBalanceEnabled = true;
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.enabled", isPreemptionToBalanceEnabled);
        long FB_MAX_BEFORE_KILL = 60000L;
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.max-wait-before-kill", 60000L);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, true);
        this.policy.editSchedule();
        Map pcps = this.policy.getToPreemptCandidatesPerSelector();
        String FIFO_CANDIDATE_SELECTOR = "FifoCandidatesSelector";
        boolean hasFifoSelector = false;
        for (Map.Entry pc : pcps.entrySet()) {
            FifoCandidatesSelector pcs;
            if (!((PreemptionCandidatesSelector)pc.getKey()).getClass().getSimpleName().equals(FIFO_CANDIDATE_SELECTOR) || !(pcs = (FifoCandidatesSelector)pc.getKey()).getAllowQueuesBalanceAfterAllQueuesSatisfied()) continue;
            hasFifoSelector = true;
            Assertions.assertThat((long)pcs.getMaximumKillWaitTimeMs()).isEqualTo(60000L);
        }
        Assert.assertEquals((Object)hasFifoSelector, (Object)true);
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)21))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        Assert.assertEquals((long)60L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.a")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)60L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.a")).get("")).getIdealAssigned().getVirtualCores());
        Assert.assertEquals((long)40L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.b")).get("")).getIdealAssigned().getMemorySize());
        Assert.assertEquals((long)40L, (long)((TempQueuePerPartition)((Map)this.policy.getQueuePartitions().get("root.b")).get("")).getIdealAssigned().getVirtualCores());
    }
}

