/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ACLsTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class QueueACLsTestBase
extends ACLsTestBase {
    protected static final String QUEUED = "D";
    protected static final String QUEUED1 = "D1";
    private static final String ALL_ACL = "*";
    private static final String NONE_ACL = " ";

    public abstract String getQueueD();

    public abstract String getQueueD1();

    public abstract void updateConfigWithDAndD1Queues(String var1, String var2, String var3) throws IOException;

    @After
    public void tearDown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
        }
    }

    @Test
    public void testApplicationACLs() throws Exception {
        this.verifyKillAppSuccess("queueA_user", "queueA_user", "queueA", true);
        this.verifyKillAppSuccess("queueA_user", "queueA_admin", "queueA", true);
        this.verifyKillAppSuccess("queueA_user", "common_user", "queueA", true);
        this.verifyKillAppSuccess("queueA_user", "root_admin", "queueA", true);
        this.verifyKillAppFailure("queueA_user", "queueB_user", "queueA", true);
        this.verifyKillAppFailure("queueA_user", "queueB_admin", "queueA", true);
        this.verifyKillAppSuccess("queueB_user", "queueB_user", "queueB", true);
        this.verifyKillAppSuccess("queueB_user", "queueB_admin", "queueB", true);
        this.verifyKillAppSuccess("queueB_user", "common_user", "queueB", true);
        this.verifyKillAppSuccess("queueB_user", "root_admin", "queueB", true);
        this.verifyKillAppFailure("queueB_user", "queueA_user", "queueB", true);
        this.verifyKillAppFailure("queueB_user", "queueA_admin", "queueB", true);
        this.verifyKillAppSuccess("root_admin", "root_admin", "queueA", false);
        this.verifyKillAppSuccess("root_admin", "root_admin", "queueB", false);
        this.verifyGetClientAMToken("queueA_user", "root_admin", "queueA", true);
    }

    @Test
    public void testQueueAclRestrictedRootACL() throws IOException {
        this.updateConfigWithDAndD1Queues(NONE_ACL, ALL_ACL, ALL_ACL);
        this.checkAccess(false, true, true);
    }

    @Test
    public void testQueueAclNoAccess() throws IOException {
        this.updateConfigWithDAndD1Queues(NONE_ACL, NONE_ACL, NONE_ACL);
        this.checkAccess(false, false, false);
    }

    @Test
    public void testQueueAclRestrictedRootAndD1() throws IOException {
        this.updateConfigWithDAndD1Queues(NONE_ACL, ALL_ACL, NONE_ACL);
        this.checkAccess(false, true, true);
    }

    @Test
    public void testQueueAclRestrictedRootAndD() throws IOException {
        this.updateConfigWithDAndD1Queues(NONE_ACL, NONE_ACL, ALL_ACL);
        this.checkAccess(false, false, true);
    }

    @Test
    public void testQueueAclRestrictedD() throws IOException {
        this.updateConfigWithDAndD1Queues(ALL_ACL, NONE_ACL, ALL_ACL);
        this.checkAccess(true, true, true);
    }

    @Test
    public void testQueueAclRestrictedD1() throws IOException {
        this.updateConfigWithDAndD1Queues(ALL_ACL, ALL_ACL, NONE_ACL);
        this.checkAccess(true, true, true);
    }

    @Test
    public void testQueueAclDefaultValues() throws IOException {
        this.updateConfigWithDAndD1Queues(null, null, null);
        this.checkAccess(true, true, true);
    }

    private void checkAccess(boolean rootAccess, boolean dAccess, boolean d1Access) throws IOException {
        this.checkAccess(rootAccess, "root");
        this.checkAccess(dAccess, this.getQueueD());
        this.checkAccess(d1Access, this.getQueueD1());
    }

    private void checkAccess(boolean access, String queueName) throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        String failureMsg = "Wrong %s access to %s queue";
        Assert.assertEquals((String)String.format(failureMsg, QueueACL.ADMINISTER_QUEUE, queueName), (Object)access, (Object)this.resourceManager.getResourceScheduler().checkAccess(user, QueueACL.ADMINISTER_QUEUE, queueName));
        Assert.assertEquals((String)String.format(failureMsg, QueueACL.SUBMIT_APPLICATIONS, queueName), (Object)access, (Object)this.resourceManager.getResourceScheduler().checkAccess(user, QueueACL.SUBMIT_APPLICATIONS, queueName));
    }

    private void verifyGetClientAMToken(String submitter, String queueAdmin, String queueName, boolean setupACLs) throws Exception {
        ApplicationId applicationId = this.submitAppAndGetAppId(submitter, queueName, setupACLs);
        GetApplicationReportRequest appReportRequest = GetApplicationReportRequest.newInstance((ApplicationId)applicationId);
        ApplicationClientProtocol submitterClient = this.getRMClientForUser(submitter);
        ApplicationClientProtocol adMinUserClient = this.getRMClientForUser(queueAdmin);
        GetApplicationReportResponse submitterGetReport = submitterClient.getApplicationReport(appReportRequest);
        GetApplicationReportResponse adMinUserGetReport = adMinUserClient.getApplicationReport(appReportRequest);
        Assert.assertEquals((Object)submitterGetReport.getApplicationReport().getClientToAMToken(), (Object)adMinUserGetReport.getApplicationReport().getClientToAMToken());
    }

    private void verifyKillAppFailure(String submitter, String killer, String queueName, boolean setupACLs) throws Exception {
        ApplicationId applicationId = this.submitAppAndGetAppId(submitter, queueName, setupACLs);
        KillApplicationRequest finishAppRequest = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        ApplicationClientProtocol killerClient = this.getRMClientForUser(killer);
        try {
            killerClient.forceKillApplication(finishAppRequest);
            Assert.fail((String)"App killing by the enemy should fail!!");
        }
        catch (YarnException e) {
            LOG.info("Got exception while killing app as the enemy", (Throwable)e);
            Assert.assertTrue((boolean)e.getMessage().contains("User " + killer + " cannot perform operation MODIFY_APP on " + applicationId));
        }
        this.getRMClientForUser(submitter).forceKillApplication(finishAppRequest);
    }

    private void verifyKillAppSuccess(String submitter, String killer, String queueName, boolean setupACLs) throws Exception {
        ApplicationId applicationId = this.submitAppAndGetAppId(submitter, queueName, setupACLs);
        KillApplicationRequest finishAppRequest = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        ApplicationClientProtocol ownerClient = this.getRMClientForUser(killer);
        ownerClient.forceKillApplication(finishAppRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.KILLED);
    }

    private ApplicationId submitAppAndGetAppId(String submitter, String queueName, boolean setupACLs) throws Exception {
        GetNewApplicationRequest newAppRequest = GetNewApplicationRequest.newInstance();
        ApplicationClientProtocol submitterClient = this.getRMClientForUser(submitter);
        ApplicationId applicationId = submitterClient.getNewApplication(newAppRequest).getApplicationId();
        Resource resource = BuilderUtils.newResource((long)1024L, (int)1);
        Map<ApplicationAccessType, String> acls = this.createACLs(submitter, setupACLs);
        ContainerLaunchContext amContainerSpec = ContainerLaunchContext.newInstance(null, null, null, null, null, acls);
        ApplicationSubmissionContext appSubmissionContext = ApplicationSubmissionContext.newInstance((ApplicationId)applicationId, (String)"applicationName", (String)queueName, null, (ContainerLaunchContext)amContainerSpec, (boolean)false, (boolean)true, (int)1, (Resource)resource, (String)"applicationType");
        appSubmissionContext.setApplicationId(applicationId);
        appSubmissionContext.setQueue(queueName);
        SubmitApplicationRequest submitRequest = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)appSubmissionContext);
        submitterClient.submitApplication(submitRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.ACCEPTED);
        return applicationId;
    }

    private Map<ApplicationAccessType, String> createACLs(String submitter, boolean setupACLs) {
        AccessControlList viewACL = new AccessControlList("");
        AccessControlList modifyACL = new AccessControlList("");
        if (setupACLs) {
            viewACL.addUser(submitter);
            viewACL.addUser("common_user");
            modifyACL.addUser(submitter);
            modifyACL.addUser("common_user");
        }
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
        acls.put(ApplicationAccessType.VIEW_APP, viewACL.getAclString());
        acls.put(ApplicationAccessType.MODIFY_APP, modifyACL.getAclString());
        return acls;
    }
}

