/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.AllocateRequestPBImpl;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.resourcetypes.ResourceTypesTestHelper;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationMasterServiceTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMasterServiceTestBase.class);
    static final int GB = 1024;
    static final String CUSTOM_RES = "res_1";
    static final String DEFAULT_HOST = "127.0.0.1";
    static final String DEFAULT_PORT = "1234";
    protected static YarnConfiguration conf;

    protected abstract YarnConfiguration createYarnConfig();

    protected abstract Resource getResourceUsageForQueue(ResourceManager var1, String var2);

    protected abstract String getDefaultQueueName();

    Map<String, ResourceInformation> initializeMandatoryResources() {
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        riMap.put("memory-mb", memory);
        riMap.put("vcores", vcores);
        return riMap;
    }

    private void requestResources(MockAM am, long memory, int vCores, Map<String, Integer> customResources) throws Exception {
        Map convertedCustomResources = ResourceTypesTestHelper.convertCustomResources(customResources);
        am.allocate(Collections.singletonList(ResourceRequest.newBuilder().capability(ResourceTypesTestHelper.newResource((long)memory, (int)vCores, (Map)convertedCustomResources)).numContainers(1).resourceName("*").build()), null);
    }

    @Before
    public void setup() {
        conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
    }

    @Test(timeout=3000000L)
    public void testRMIdentifierOnContainerAllocation() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(2048L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        am1.addRequests(new String[]{DEFAULT_HOST}, 1024, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info("Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            alloc1Response = am1.schedule();
        }
        Container allocatedContainer = (Container)alloc1Response.getAllocatedContainers().get(0);
        ContainerTokenIdentifier tokenId = BuilderUtils.newContainerTokenIdentifier((Token)allocatedContainer.getContainerToken());
        Assert.assertEquals((long)MockRM.getClusterTimeStamp(), (long)tokenId.getRMIdentifier());
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000000L)
    public void testAllocateResponseIdOverflow() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = MockRMAppSubmitter.submitWithMemory(2048L, rm);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            am1.registerAppAttempt();
            Assert.assertTrue((boolean)am1.setApplicationLastResponseId(Integer.MAX_VALUE));
            am1.schedule();
            Assert.assertEquals((long)0L, (long)am1.getResponseId());
            am1.schedule();
            Assert.assertEquals((long)1L, (long)am1.getResponseId());
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testInvalidContainerReleaseRequest() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            am1.registerAppAttempt();
            am1.addRequests(new String[]{DEFAULT_HOST}, 1024, 1, 1);
            AllocateResponse alloc1Response = am1.schedule();
            nm1.nodeHeartbeat(true);
            while (alloc1Response.getAllocatedContainers().size() < 1) {
                LOG.info("Waiting for containers to be created for app 1...");
                Thread.sleep(1000L);
                alloc1Response = am1.schedule();
            }
            Assert.assertTrue((alloc1Response.getAllocatedContainers().size() > 0 ? 1 : 0) != 0);
            RMApp app2 = MockRMAppSubmitter.submitWithMemory(1024L, rm);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt2 = app2.getCurrentAppAttempt();
            MockAM am2 = rm.sendAMLaunched(attempt2.getAppAttemptId());
            am2.registerAppAttempt();
            ContainerId cId = ((Container)alloc1Response.getAllocatedContainers().get(0)).getId();
            am2.addContainerToBeReleased(cId);
            try {
                am2.schedule();
                Assert.fail((String)"Exception was expected!!");
            }
            catch (InvalidContainerReleaseException e) {
                StringBuilder sb = new StringBuilder("Cannot release container : ");
                sb.append(cId.toString());
                sb.append(" not belonging to this application attempt : ");
                sb.append(attempt2.getAppAttemptId().toString());
                Assert.assertTrue((boolean)e.getMessage().contains(sb.toString()));
            }
        }
        finally {
            rm.stop();
        }
    }

    @Test(timeout=1200000L)
    public void testProgressFilter() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(2048L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        AllocateRequestPBImpl allocateRequest = new AllocateRequestPBImpl();
        ArrayList release = new ArrayList();
        ArrayList ask = new ArrayList();
        allocateRequest.setReleaseList(release);
        allocateRequest.setAskList(ask);
        allocateRequest.setProgress(Float.POSITIVE_INFINITY);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 1.0f) {
            LOG.info("Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(Float.NaN);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 0.0f) {
            LOG.info("Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(9.0f);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 1.0f) {
            LOG.info("Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(Float.NEGATIVE_INFINITY);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 0.0f) {
            LOG.info("Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(0.5f);
        am1.allocate((AllocateRequest)allocateRequest);
        while ((double)attempt1.getProgress() != 0.5) {
            LOG.info("Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(-1.0f);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 0.0f) {
            LOG.info("Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=1200000L)
    public void testFinishApplicationMasterBeforeRegistering() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = MockRMAppSubmitter.submitWithMemory(2048L, rm);
            MockAM am1 = MockRM.launchAM(app1, rm, nm1);
            FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.FAILED, (String)"", (String)"");
            try {
                am1.unregisterAppAttempt(req, false);
                Assert.fail((String)"ApplicationMasterNotRegisteredException should be thrown");
            }
            catch (ApplicationMasterNotRegisteredException e) {
                Assert.assertNotNull((Object)((Object)e));
                Assert.assertNotNull((Object)e.getMessage());
                Assert.assertTrue((boolean)e.getMessage().contains("Application Master is trying to unregister before registering for:"));
            }
            catch (Exception e) {
                Assert.fail((String)"ApplicationMasterNotRegisteredException should be thrown");
            }
            am1.registerAppAttempt();
            am1.unregisterAppAttempt(req, false);
            rm.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FINISHING);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=1200000L)
    public void testRepeatedFinishApplicationMaster() throws Exception {
        final CountingDispatcher dispatcher = new CountingDispatcher();
        MockRM rm = new MockRM((Configuration)conf){

            @Override
            protected Dispatcher createDispatcher() {
                return dispatcher;
            }
        };
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm).build());
            MockAM am1 = MockRM.launchAM(app1, rm, nm1);
            am1.registerAppAttempt();
            FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.FAILED, (String)"", (String)"");
            for (int i = 0; i < 10; ++i) {
                am1.unregisterAppAttempt(req, false);
            }
            rm.drainEvents();
            Assert.assertEquals((String)"Expecting only one event", (long)1L, (long)dispatcher.getEventCount());
        }
        finally {
            rm.stop();
        }
    }

    @Test(timeout=3000000L)
    public void testResourceTypes() throws Exception {
        HashMap<YarnConfiguration, EnumSet<YarnServiceProtos.SchedulerResourceTypes>> driver = new HashMap<YarnConfiguration, EnumSet<YarnServiceProtos.SchedulerResourceTypes>>();
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setResourceComparator(DominantResourceCalculator.class);
        YarnConfiguration testCapacityDRConf = new YarnConfiguration((Configuration)csconf);
        testCapacityDRConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        YarnConfiguration testCapacityDefConf = new YarnConfiguration();
        testCapacityDefConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        YarnConfiguration testFairDefConf = new YarnConfiguration();
        testFairDefConf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        driver.put(conf, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY));
        driver.put(testCapacityDRConf, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.CPU, YarnServiceProtos.SchedulerResourceTypes.MEMORY));
        driver.put(testCapacityDefConf, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY));
        driver.put(testFairDefConf, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU));
        for (Map.Entry entry : driver.entrySet()) {
            EnumSet expectedValue = (EnumSet)entry.getValue();
            MockRM rm = new MockRM((Configuration)entry.getKey());
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = MockRMAppSubmitter.submitWithMemory(2048L, rm);
            Thread.sleep(1000L);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            RegisterApplicationMasterResponse resp = am1.registerAppAttempt();
            EnumSet types = resp.getSchedulerResourceTypes();
            LOG.info("types = " + types.toString());
            Assert.assertEquals((Object)expectedValue, (Object)types);
            rm.stop();
        }
    }

    @Test(timeout=1200000L)
    public void testAllocateAfterUnregister() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(2048L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.KILLED, (String)"", (String)"");
        am1.unregisterAppAttempt(req, false);
        am1.addRequests(new String[]{DEFAULT_HOST}, 1024, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        rm.drainEvents();
        alloc1Response = am1.schedule();
        Assert.assertEquals((long)0L, (long)alloc1Response.getAllocatedContainers().size());
    }

    @Test(timeout=300000L)
    public void testUpdateTrackingUrl() throws Exception {
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(2048L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        Assert.assertEquals((Object)"N/A", (Object)((RMApp)rm.getRMContext().getRMApps().get(app1.getApplicationId())).getOriginalTrackingUrl());
        AllocateRequestPBImpl allocateRequest = new AllocateRequestPBImpl();
        String newTrackingUrl = "hadoop.apache.org";
        allocateRequest.setTrackingUrl(newTrackingUrl);
        am1.allocate((AllocateRequest)allocateRequest);
        rm.drainEvents();
        Assert.assertEquals((Object)newTrackingUrl, (Object)((RMApp)rm.getRMContext().getRMApps().get(app1.getApplicationId())).getOriginalTrackingUrl());
        am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((Object)newTrackingUrl, (Object)((RMApp)rm.getRMContext().getRMApps().get(app1.getApplicationId())).getOriginalTrackingUrl());
        rm.stop();
    }

    @Test(timeout=300000L)
    public void testValidateRequestCapacityAgainstMinMaxAllocation() throws Exception {
        Map<String, ResourceInformation> riMap = this.initializeMandatoryResources();
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        YarnConfiguration yarnConf = this.createYarnConfig();
        yarnConf.setBoolean("yarn.test.reset-resource-types", false);
        yarnConf.setBoolean("yarn.resourcemanager.resource-profiles.enabled", false);
        MockRM rm = new MockRM((Configuration)yarnConf);
        rm.start();
        MockNM nm1 = rm.registerNode("199.99.99.1:1234", ResourceTypesTestHelper.newResource((long)8192L, (int)4, null));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue(this.getDefaultQueueName()).withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        boolean exception = false;
        try {
            am1.allocate(Collections.singletonList(ResourceRequest.newBuilder().capability(Resource.newInstance((int)9216, (int)1)).numContainers(1).resourceName("*").build()), null);
        }
        catch (InvalidResourceRequestException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        exception = false;
        try {
            am1.allocate(Collections.singletonList(ResourceRequest.newBuilder().capability(Resource.newInstance((int)8192, (int)18)).numContainers(1).resourceName("*").build()), null);
        }
        catch (InvalidResourceRequestException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        rm.close();
    }

    @Test(timeout=300000L)
    public void testRequestCapacityMinMaxAllocationForResourceTypes() throws Exception {
        Map<String, ResourceInformation> riMap = this.initializeMandatoryResources();
        ResourceInformation res1 = ResourceInformation.newInstance((String)CUSTOM_RES, (String)ResourceInformation.VCORES.getUnits(), (long)0L, (long)4L);
        riMap.put(CUSTOM_RES, res1);
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        YarnConfiguration yarnConf = this.createYarnConfig();
        yarnConf.setBoolean("yarn.test.reset-resource-types", false);
        yarnConf.setBoolean("yarn.resourcemanager.resource-profiles.enabled", false);
        MockRM rm = new MockRM((Configuration)yarnConf);
        rm.start();
        MockNM nm1 = rm.registerNode("199.99.99.1:1234", ResourceTypesTestHelper.newResource((long)8192L, (int)4, (Map)ImmutableMap.of((Object)CUSTOM_RES, (Object)"4")));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue(this.getDefaultQueueName()).withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)this.getResourceUsageForQueue(rm, this.getDefaultQueueName()));
        try {
            this.requestResources(am1, 9216L, 1, (Map<String, Integer>)ImmutableMap.of());
            Assert.fail((String)"Should throw InvalidResourceRequestException");
        }
        catch (InvalidResourceRequestException invalidResourceRequestException) {
            // empty catch block
        }
        try {
            this.requestResources(am1, 1024L, 18, (Map<String, Integer>)ImmutableMap.of());
            Assert.fail((String)"Should throw InvalidResourceRequestException");
        }
        catch (InvalidResourceRequestException invalidResourceRequestException) {
            // empty catch block
        }
        try {
            this.requestResources(am1, 1024L, 2, (Map<String, Integer>)ImmutableMap.of((Object)CUSTOM_RES, (Object)100));
            Assert.fail((String)"Should throw InvalidResourceRequestException");
        }
        catch (InvalidResourceRequestException invalidResourceRequestException) {
            // empty catch block
        }
        rm.close();
    }

    static class CountingDispatcher
    extends DrainDispatcher {
        private int eventreceived = 0;

        CountingDispatcher() {
        }

        protected void dispatch(Event event) {
            if (event.getType() == RMAppAttemptEventType.UNREGISTERED) {
                ++this.eventreceived;
            } else {
                super.dispatch(event);
            }
        }

        public int getEventCount() {
            return this.eventreceived;
        }
    }
}

