/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.DryRunResultHolder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.UnsupportedPropertyException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSConfigToCSConfigRuleHandler {
    private static final String ABORT = "abort";
    private static final String WARNING = "warning";
    private FSConfigToCSConfigRuleHandler ruleHandler;
    private DryRunResultHolder dryRunResultHolder;

    @Before
    public void setup() {
        this.dryRunResultHolder = new DryRunResultHolder();
    }

    private ConversionOptions createDryRunConversionOptions() {
        return new ConversionOptions(this.dryRunResultHolder, true);
    }

    private ConversionOptions createDefaultConversionOptions() {
        return new ConversionOptions(this.dryRunResultHolder, false);
    }

    @Test
    public void testInitPropertyActionsToWarning() throws IOException {
        this.ruleHandler = new FSConfigToCSConfigRuleHandler(new Properties(), this.createDefaultConversionOptions());
        this.ruleHandler.handleChildQueueCount("test", 1);
        this.ruleHandler.handleDynamicMaxAssign();
        this.ruleHandler.handleMaxCapacityPercentage("test");
        this.ruleHandler.handleMaxChildCapacity();
        this.ruleHandler.handleMinResources();
        this.ruleHandler.handleMaxResources();
        this.ruleHandler.handleQueueAutoCreate("test");
        this.ruleHandler.handleReservationSystem();
        this.ruleHandler.handleSpecifiedNotFirstRule();
    }

    @Test
    public void testAllRulesWarning() throws IOException {
        Properties rules = new Properties();
        rules.put("dynamicMaxAssign.action", WARNING);
        rules.put("maxCapacityPercentage.action", WARNING);
        rules.put("maxResources.action", WARNING);
        rules.put("minResources.action", WARNING);
        rules.put("maxChildCapacity.action", WARNING);
        rules.put("queueAutoCreate.action", WARNING);
        rules.put("reservationSystem.action", WARNING);
        rules.put("specifiedNotFirstRule.action", WARNING);
        rules.put("userMaxAppsDefault.action", WARNING);
        rules.put("userMaxRunningApps.action", WARNING);
        rules.put("fairAsDrf.action", WARNING);
        this.ruleHandler = new FSConfigToCSConfigRuleHandler(rules, this.createDefaultConversionOptions());
        this.ruleHandler.handleDynamicMaxAssign();
        this.ruleHandler.handleMaxCapacityPercentage("test");
        this.ruleHandler.handleMaxChildCapacity();
        this.ruleHandler.handleMinResources();
        this.ruleHandler.handleMaxResources();
        this.ruleHandler.handleQueueAutoCreate("test");
        this.ruleHandler.handleReservationSystem();
        this.ruleHandler.handleSpecifiedNotFirstRule();
    }

    @Test
    public void testAllRulesAbort() throws IOException {
        Properties rules = new Properties();
        rules.put("dynamicMaxAssign.action", ABORT);
        rules.put("maxCapacityPercentage.action", ABORT);
        rules.put("maxChildCapacity.action", ABORT);
        rules.put("maxResources.action", ABORT);
        rules.put("minResources.action", ABORT);
        rules.put("queueAutoCreate.action", ABORT);
        rules.put("reservationSystem.action", ABORT);
        rules.put("specifiedNotFirstRule.action", ABORT);
        rules.put("userMaxAppsDefault.action", ABORT);
        rules.put("userMaxRunningApps.action", ABORT);
        rules.put("userMaxRunningApps.action", ABORT);
        rules.put("fairAsDrf.action", ABORT);
        rules.put("maxChildQueue.limit", "1");
        this.ruleHandler = new FSConfigToCSConfigRuleHandler(rules, this.createDefaultConversionOptions());
        this.expectAbort(() -> this.ruleHandler.handleChildQueueCount("test", 2), ConversionException.class);
        this.expectAbort(() -> this.ruleHandler.handleDynamicMaxAssign());
        this.expectAbort(() -> this.ruleHandler.handleMaxCapacityPercentage("test"));
        this.expectAbort(() -> this.ruleHandler.handleMaxChildCapacity());
        this.expectAbort(() -> this.ruleHandler.handleMaxResources());
        this.expectAbort(() -> this.ruleHandler.handleMinResources());
        this.expectAbort(() -> this.ruleHandler.handleQueueAutoCreate("test"));
        this.expectAbort(() -> this.ruleHandler.handleReservationSystem());
        this.expectAbort(() -> this.ruleHandler.handleSpecifiedNotFirstRule());
        this.expectAbort(() -> this.ruleHandler.handleFairAsDrf("test"));
    }

    @Test(expected=ConversionException.class)
    public void testMaxChildQueueCountNotInteger() throws IOException {
        Properties rules = new Properties();
        rules.put("maxChildQueue.limit", "abc");
        this.ruleHandler = new FSConfigToCSConfigRuleHandler(rules, this.createDefaultConversionOptions());
        this.ruleHandler.handleChildQueueCount("test", 1);
    }

    @Test
    public void testDryRunWarning() {
        Properties rules = new Properties();
        this.ruleHandler = new FSConfigToCSConfigRuleHandler(rules, this.createDryRunConversionOptions());
        this.ruleHandler.handleDynamicMaxAssign();
        this.ruleHandler.handleMaxChildCapacity();
        Assert.assertEquals((String)"Number of warnings", (long)2L, (long)this.dryRunResultHolder.getWarnings().size());
        Assert.assertEquals((String)"Number of errors", (long)0L, (long)this.dryRunResultHolder.getErrors().size());
    }

    @Test
    public void testDryRunError() {
        Properties rules = new Properties();
        rules.put("dynamicMaxAssign.action", ABORT);
        rules.put("maxChildCapacity.action", ABORT);
        this.ruleHandler = new FSConfigToCSConfigRuleHandler(rules, this.createDryRunConversionOptions());
        this.ruleHandler.handleDynamicMaxAssign();
        this.ruleHandler.handleMaxChildCapacity();
        Assert.assertEquals((String)"Number of warnings", (long)0L, (long)this.dryRunResultHolder.getWarnings().size());
        Assert.assertEquals((String)"Number of errors", (long)2L, (long)this.dryRunResultHolder.getErrors().size());
    }

    private void expectAbort(VoidCall call) {
        this.expectAbort(call, UnsupportedPropertyException.class);
    }

    private void expectAbort(VoidCall call, Class<?> exceptionClass) {
        boolean exceptionThrown = false;
        Throwable thrown = null;
        try {
            call.apply();
        }
        catch (Throwable t) {
            thrown = t;
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Exception was not thrown", (boolean)exceptionThrown);
        Assert.assertEquals((String)"Unexpected exception", exceptionClass, thrown.getClass());
    }

    @FunctionalInterface
    private static interface VoidCall {
        public void apply();
    }
}

