/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.resourcetypes.ResourceTypesTestHelper;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;

public class MockNodes {
    private static int NODE_ID = 0;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public static void resetHostIds() {
        NODE_ID = 0;
    }

    public static List<RMNode> newNodes(int racks, int nodesPerRack, Resource perNode) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < racks; ++i) {
            for (int j = 0; j < nodesPerRack; ++j) {
                if (j == nodesPerRack - 1) {
                    list.add(MockNodes.nodeInfo(i, perNode, NodeState.UNHEALTHY));
                    continue;
                }
                if (j == 0) {
                    list.add(MockNodes.nodeInfo(i, perNode, NodeState.RUNNING, (Set<String>)ImmutableSet.of((Object)"x")));
                    continue;
                }
                list.add(MockNodes.newNodeInfo(i, perNode));
            }
        }
        return list;
    }

    public static List<RMNode> deactivatedNodes(int racks, int nodesPerRack, Resource perNode) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < racks; ++i) {
            for (int j = 0; j < nodesPerRack; ++j) {
                NodeState[] allStates = NodeState.values();
                list.add(MockNodes.nodeInfo(i, perNode, allStates[j % allStates.length]));
            }
        }
        return list;
    }

    public static Resource newResource(int mem) {
        Resource rs = (Resource)recordFactory.newRecordInstance(Resource.class);
        rs.setMemorySize((long)mem);
        return rs;
    }

    public static Resource newResource(long memory, int vCores, Map<String, String> customResources) {
        return ResourceTypesTestHelper.newResource((long)memory, (int)vCores, customResources);
    }

    public static Resource newUsedResource(Resource total) {
        Resource rs = (Resource)recordFactory.newRecordInstance(Resource.class);
        rs.setMemorySize((long)((int)(Math.random() * (double)total.getMemorySize())));
        return rs;
    }

    public static Resource newAvailResource(Resource total, Resource used) {
        Resource rs = (Resource)recordFactory.newRecordInstance(Resource.class);
        rs.setMemorySize(total.getMemorySize() - used.getMemorySize());
        return rs;
    }

    private static RMNode buildRMNode(int rack, Resource perNode, NodeState state, String httpAddr) {
        return MockNodes.buildRMNode(rack, perNode, state, httpAddr, null);
    }

    private static RMNode buildRMNode(int rack, Resource perNode, NodeState state, String httpAddr, Set<String> labels) {
        return MockNodes.buildRMNode(rack, perNode, state, httpAddr, NODE_ID++, null, 123, labels, null, null, null);
    }

    private static RMNode buildRMNode(int rack, Resource perNode, NodeState state, String httpAddr, int hostnum, String hostName, int port) {
        return MockNodes.buildRMNode(rack, perNode, state, httpAddr, hostnum, hostName, port, null, null, null, null);
    }

    private static RMNode buildRMNode(int rack, Resource perNode, NodeState state, String httpAddr, int hostnum, String hostName, int port, Set<String> labels, ResourceUtilization containersUtilization, ResourceUtilization nodeUtilization, Resource physicalResource) {
        String rackName = "rack" + rack;
        int nid = hostnum;
        String nodeAddr = hostName + ":" + nid;
        if (hostName == null) {
            hostName = "host" + nid;
        }
        NodeId nodeID = NodeId.newInstance((String)hostName, (int)port);
        String httpAddress = httpAddr;
        String healthReport = state == NodeState.UNHEALTHY ? null : "HealthyMe";
        return new MockRMNodeImpl(nodeID, nodeAddr, httpAddress, perNode, rackName, healthReport, 0L, nid, hostName, state, labels, containersUtilization, nodeUtilization, physicalResource);
    }

    private static RMNode buildRMNode(int rack, Resource perNode, NodeState state, String httpAddr, int hostnum, String hostName, int port, Set<String> labels, ResourceUtilization containersUtilization, ResourceUtilization nodeUtilization, Resource physicalResource, RMContext rmContext) {
        String rackName = "rack" + rack;
        int nid = hostnum;
        String nodeAddr = hostName + ":" + nid;
        if (hostName == null) {
            hostName = "host" + nid;
        }
        NodeId nodeID = NodeId.newInstance((String)hostName, (int)port);
        String httpAddress = httpAddr;
        String healthReport = state == NodeState.UNHEALTHY ? null : "HealthyMe";
        return new MockRMNodeImpl(nodeID, nodeAddr, httpAddress, perNode, rackName, healthReport, 0L, nid, hostName, state, labels, containersUtilization, nodeUtilization, physicalResource, rmContext);
    }

    public static RMNode nodeInfo(int rack, Resource perNode, NodeState state) {
        return MockNodes.buildRMNode(rack, perNode, state, "N/A");
    }

    public static RMNode nodeInfo(int rack, Resource perNode, NodeState state, Set<String> labels) {
        return MockNodes.buildRMNode(rack, perNode, state, "N/A", labels);
    }

    public static RMNode newNodeInfo(int rack, Resource perNode) {
        return MockNodes.buildRMNode(rack, perNode, NodeState.RUNNING, "localhost:0");
    }

    public static RMNode newNodeInfo(int rack, Resource perNode, int hostnum) {
        return MockNodes.buildRMNode(rack, perNode, NodeState.RUNNING, "localhost:0", hostnum, null, 123);
    }

    public static RMNode newNodeInfo(int rack, Resource perNode, int hostnum, String hostName) {
        return MockNodes.buildRMNode(rack, perNode, NodeState.RUNNING, "localhost:0", hostnum, hostName, 123);
    }

    public static RMNode newNodeInfo(int rack, Resource perNode, int hostnum, String hostName, int port) {
        return MockNodes.buildRMNode(rack, perNode, NodeState.RUNNING, "localhost:0", hostnum, hostName, port);
    }

    public static RMNode newNodeInfo(int rack, Resource perNode, int hostnum, String hostName, int port, RMContext rmContext) {
        return MockNodes.buildRMNode(rack, perNode, NodeState.RUNNING, "localhost:0", hostnum, hostName, port, null, null, null, null, rmContext);
    }

    private static class MockRMNodeImpl
    implements RMNode {
        private NodeId nodeId;
        private String hostName;
        private String nodeAddr;
        private String httpAddress;
        private int cmdPort;
        private Resource perNode;
        private String rackName;
        private String healthReport;
        private long lastHealthReportTime;
        private NodeState state;
        private Set<String> labels;
        private ResourceUtilization containersUtilization;
        private ResourceUtilization nodeUtilization;
        private Resource physicalResource;
        private RMContext rmContext;

        MockRMNodeImpl(NodeId nodeId, String nodeAddr, String httpAddress, Resource perNode, String rackName, String healthReport, long lastHealthReportTime, int cmdPort, String hostName, NodeState state, Set<String> labels, ResourceUtilization containersUtilization, ResourceUtilization nodeUtilization, Resource pPhysicalResource) {
            this.nodeId = nodeId;
            this.nodeAddr = nodeAddr;
            this.httpAddress = httpAddress;
            this.perNode = perNode;
            this.rackName = rackName;
            this.healthReport = healthReport;
            this.lastHealthReportTime = lastHealthReportTime;
            this.cmdPort = cmdPort;
            this.hostName = hostName;
            this.state = state;
            this.labels = labels;
            this.containersUtilization = containersUtilization;
            this.nodeUtilization = nodeUtilization;
            this.physicalResource = pPhysicalResource;
        }

        public MockRMNodeImpl(NodeId nodeId, String nodeAddr, String httpAddress, Resource perNode, String rackName, String healthReport, long lastHealthReportTime, int cmdPort, String hostName, NodeState state, Set<String> labels, ResourceUtilization containersUtilization, ResourceUtilization nodeUtilization, Resource pPhysicalResource, RMContext rmContext) {
            this(nodeId, nodeAddr, httpAddress, perNode, rackName, healthReport, lastHealthReportTime, cmdPort, hostName, state, labels, containersUtilization, nodeUtilization, pPhysicalResource);
            this.rmContext = rmContext;
        }

        public NodeId getNodeID() {
            return this.nodeId;
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getCommandPort() {
            return this.cmdPort;
        }

        public int getHttpPort() {
            return 0;
        }

        public String getNodeAddress() {
            return this.nodeAddr;
        }

        public String getHttpAddress() {
            return this.httpAddress;
        }

        public Resource getTotalCapability() {
            return this.perNode;
        }

        public boolean isUpdatedCapability() {
            return false;
        }

        public void resetUpdatedCapability() {
        }

        public String getRackName() {
            return this.rackName;
        }

        public Node getNode() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public NodeState getState() {
            return this.state;
        }

        public List<ContainerId> getContainersToCleanUp() {
            return null;
        }

        public List<ApplicationId> getAppsToCleanup() {
            return null;
        }

        public List<ApplicationId> getRunningApps() {
            return null;
        }

        public void setAndUpdateNodeHeartbeatResponse(NodeHeartbeatResponse response) {
        }

        public NodeHeartbeatResponse getLastNodeHeartBeatResponse() {
            return null;
        }

        public void resetLastNodeHeartBeatResponse() {
        }

        public String getNodeManagerVersion() {
            return null;
        }

        public List<UpdatedContainerInfo> pullContainerUpdates() {
            return new ArrayList<UpdatedContainerInfo>();
        }

        public String getHealthReport() {
            return this.healthReport;
        }

        public long getLastHealthReportTime() {
            return this.lastHealthReportTime;
        }

        public Set<String> getNodeLabels() {
            if (this.labels != null) {
                return this.labels;
            }
            return CommonNodeLabelsManager.EMPTY_STRING_SET;
        }

        public List<Container> pullNewlyIncreasedContainers() {
            return Collections.emptyList();
        }

        public ResourceUtilization getAggregatedContainersUtilization() {
            return this.containersUtilization;
        }

        public ResourceUtilization getNodeUtilization() {
            return this.nodeUtilization;
        }

        public OpportunisticContainersStatus getOpportunisticContainersStatus() {
            return OpportunisticContainersStatus.newInstance();
        }

        public long getUntrackedTimeStamp() {
            return 0L;
        }

        public void setUntrackedTimeStamp(long timeStamp) {
        }

        public Integer getDecommissioningTimeout() {
            return null;
        }

        public Map<String, Long> getAllocationTagsWithCount() {
            return null;
        }

        public void setNodeAttributes(String prefix, Set<NodeAttribute> nodeAttributes) {
        }

        public Set<NodeAttribute> getAllNodeAttributes() {
            return Collections.emptySet();
        }

        public RMContext getRMContext() {
            return this.rmContext;
        }

        public Resource getPhysicalResource() {
            return this.physicalResource;
        }

        public long calculateHeartBeatInterval(long defaultInterval, long minInterval, long maxInterval, float speedupFactor, float slowdownFactor) {
            return defaultInterval;
        }
    }
}

