/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.MaxRunningAppsEnforcer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMaxRunningAppsEnforcer {
    private QueueManager queueManager;
    private Map<String, Integer> userMaxApps;
    private MaxRunningAppsEnforcer maxAppsEnforcer;
    private int appNum;
    private ControlledClock clock;
    private RMContext rmContext;
    private FairScheduler scheduler;

    @Before
    public void setup() {
        FairSchedulerConfiguration conf = new FairSchedulerConfiguration();
        PlacementManager placementManager = new PlacementManager();
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.rmContext.getQueuePlacementManager()).thenReturn((Object)placementManager);
        Mockito.when((Object)this.rmContext.getEpoch()).thenReturn((Object)0L);
        Mockito.when((Object)this.rmContext.getYarnConfiguration()).thenReturn((Object)conf);
        this.clock = new ControlledClock();
        this.scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        Mockito.when((Object)this.scheduler.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)this.scheduler.getConfig()).thenReturn((Object)conf);
        Mockito.when((Object)this.scheduler.getClock()).thenReturn((Object)this.clock);
        Mockito.when((Object)this.scheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        Mockito.when((Object)this.scheduler.getRMContext()).thenReturn((Object)this.rmContext);
        AllocationConfiguration allocConf = new AllocationConfiguration(this.scheduler);
        Mockito.when((Object)this.scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        this.queueManager = new QueueManager(this.scheduler);
        this.queueManager.initialize();
        this.userMaxApps = allocConf.userMaxApps;
        this.maxAppsEnforcer = new MaxRunningAppsEnforcer(this.scheduler);
        this.appNum = 0;
    }

    private FSAppAttempt addApp(FSLeafQueue queue, String user) {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)this.appNum++);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        FSAppAttempt app = new FSAppAttempt(this.scheduler, attId, user, queue, null, this.rmContext);
        boolean runnable = this.maxAppsEnforcer.canAppBeRunnable((FSQueue)queue, app);
        queue.addApp(app, runnable);
        if (runnable) {
            this.maxAppsEnforcer.trackRunnableApp(app);
        } else {
            this.maxAppsEnforcer.trackNonRunnableApp(app);
        }
        return app;
    }

    private void removeApp(FSAppAttempt app) {
        app.getQueue().removeApp(app);
        this.maxAppsEnforcer.untrackRunnableApp(app);
        this.maxAppsEnforcer.updateRunnabilityOnAppRemoval(app, app.getQueue());
    }

    @Test
    public void testRemoveDoesNotEnableAnyApp() {
        FSParentQueue root = this.queueManager.getRootQueue();
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue2", true);
        root.setMaxRunningApps(2);
        leaf1.setMaxRunningApps(1);
        leaf2.setMaxRunningApps(1);
        FSAppAttempt app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testRemoveEnablesAppOnCousinQueue() {
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1.subqueue1.leaf1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue1.subqueue2.leaf2", true);
        FSParentQueue queue1 = this.queueManager.getParentQueue("root.queue1", true);
        queue1.setMaxRunningApps(2);
        FSAppAttempt app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testRemoveEnablesOneByQueueOneByUser() {
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1.leaf1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue1.leaf2", true);
        leaf1.setMaxRunningApps(2);
        this.userMaxApps.put("user1", 1);
        FSAppAttempt app1 = this.addApp(leaf1, "user1");
        this.addApp(leaf1, "user2");
        this.addApp(leaf1, "user3");
        this.addApp(leaf2, "user1");
        Assert.assertEquals((long)2L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf1.getNumNonRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)2L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf1.getNumNonRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testRemoveEnablingOrderedByStartTime() {
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1.subqueue1.leaf1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue1.subqueue2.leaf2", true);
        FSParentQueue queue1 = this.queueManager.getParentQueue("root.queue1", true);
        queue1.setMaxRunningApps(2);
        FSAppAttempt app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        this.clock.tickSec(20);
        this.addApp(leaf1, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf1.getNumNonRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testMultipleAppsWaitingOnCousinQueue() {
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1.subqueue1.leaf1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue1.subqueue2.leaf2", true);
        FSParentQueue queue1 = this.queueManager.getParentQueue("root.queue1", true);
        queue1.setMaxRunningApps(2);
        FSAppAttempt app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testMultiListStartTimeIteratorEmptyAppLists() {
        ArrayList<List<FSAppAttempt>> lists = new ArrayList<List<FSAppAttempt>>();
        lists.add(Arrays.asList(this.mockAppAttempt(1L)));
        lists.add(Arrays.asList(this.mockAppAttempt(2L)));
        MaxRunningAppsEnforcer.MultiListStartTimeIterator iter = new MaxRunningAppsEnforcer.MultiListStartTimeIterator(lists);
        Assert.assertEquals((long)1L, (long)((FSAppAttempt)iter.next()).getStartTime());
        Assert.assertEquals((long)2L, (long)((FSAppAttempt)iter.next()).getStartTime());
    }

    private FSAppAttempt mockAppAttempt(long startTime) {
        FSAppAttempt schedApp = (FSAppAttempt)Mockito.mock(FSAppAttempt.class);
        Mockito.when((Object)schedApp.getStartTime()).thenReturn((Object)startTime);
        return schedApp;
    }
}

