/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestReservations {
    private static final Logger LOG = LoggerFactory.getLogger(TestReservations.class);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    RMContext rmContext;
    RMContext spyRMContext;
    CapacityScheduler cs;
    CapacitySchedulerContext csContext;
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    CSQueue root;
    private CSQueueStore queues = new CSQueueStore();
    static final int GB = 1024;
    static final String DEFAULT_RACK = "/default";
    private static final String A = "a";

    @Before
    public void setUp() throws Exception {
        CapacityScheduler spyCs = new CapacityScheduler();
        this.cs = (CapacityScheduler)Mockito.spy((Object)spyCs);
        this.rmContext = TestUtils.getMockRMContext();
    }

    private void setup(CapacitySchedulerConfiguration csConf) throws Exception {
        this.setup(csConf, false);
    }

    private void setup(CapacitySchedulerConfiguration csConf, boolean addUserLimits) throws Exception {
        Mockito.when((Object)this.cs.getNumClusterNodes()).thenReturn((Object)3);
        csConf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        String newRoot = "root" + System.currentTimeMillis();
        this.setupQueueConfiguration(csConf, newRoot, addUserLimits);
        YarnConfiguration conf = new YarnConfiguration();
        this.cs.setConf((Configuration)conf);
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)12));
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)1200));
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Mockito.when((Object)this.csContext.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        Mockito.when((Object)this.csContext.getRMContext()).thenReturn((Object)this.rmContext);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)conf);
        containerTokenSecretManager.rollMasterKey();
        Mockito.when((Object)this.csContext.getContainerTokenSecretManager()).thenReturn((Object)containerTokenSecretManager);
        this.root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", (CSQueueStore)this.queues, (CSQueueStore)this.queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        ResourceUsage queueResUsage = this.root.getQueueResourceUsage();
        Mockito.when((Object)this.csContext.getClusterResourceUsage()).thenReturn((Object)queueResUsage);
        this.spyRMContext = (RMContext)Mockito.spy((Object)this.rmContext);
        Mockito.when((Object)this.spyRMContext.getScheduler()).thenReturn((Object)this.cs);
        Mockito.when((Object)this.spyRMContext.getYarnConfiguration()).thenReturn((Object)new YarnConfiguration());
        this.cs.setRMContext(this.spyRMContext);
        this.cs.init((Configuration)csConf);
        this.cs.start();
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf, String newRoot, boolean addUserLimits) {
        conf.setQueues("root", new String[]{newRoot});
        conf.setMaximumCapacity("root", 100.0f);
        conf.setAcl("root", QueueACL.SUBMIT_APPLICATIONS, " ");
        String Q_newRoot = "root." + newRoot;
        conf.setQueues(Q_newRoot, new String[]{A});
        conf.setCapacity(Q_newRoot, 100.0f);
        conf.setMaximumCapacity(Q_newRoot, 100.0f);
        conf.setAcl(Q_newRoot, QueueACL.SUBMIT_APPLICATIONS, " ");
        String Q_A = Q_newRoot + "." + A;
        conf.setCapacity(Q_A, 100.0f);
        conf.setMaximumCapacity(Q_A, 100.0f);
        conf.setAcl(Q_A, QueueACL.SUBMIT_APPLICATIONS, "*");
        if (addUserLimits) {
            conf.setUserLimit(Q_A, 25);
            conf.setUserLimitFactor(Q_A, 0.25f);
        }
    }

    static LeafQueue stubLeafQueue(LeafQueue queue) {
        ParentQueue parent = (ParentQueue)queue.getParent();
        if (parent != null) {
            ((ParentQueue)Mockito.doReturn((Object)true).when((Object)parent)).accept((Resource)ArgumentMatchers.any(Resource.class), (ResourceCommitRequest)ArgumentMatchers.any(ResourceCommitRequest.class));
            ((ParentQueue)Mockito.doNothing().when((Object)parent)).apply((Resource)ArgumentMatchers.any(Resource.class), (ResourceCommitRequest)ArgumentMatchers.any(ResourceCommitRequest.class));
        }
        return queue;
    }

    @Test
    public void testReservation() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setup(csConf);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_0 = (FiCaSchedulerApp)Mockito.spy((Object)app_0);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_0)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        this.rmContext.getRMApps().put(app_0.getApplicationId(), (RMApp)Mockito.mock(RMApp.class));
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_1 = (FiCaSchedulerApp)Mockito.spy((Object)app_1);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_1)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "host_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "host_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        String host_2 = "host_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode(host_2, DEFAULT_RACK, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1, (Object)node_2.getNodeID(), (Object)node_2);
        Mockito.when((Object)this.csContext.getNode(node_0.getNodeID())).thenReturn((Object)node_0);
        Mockito.when((Object)this.csContext.getNode(node_1.getNodeID())).thenReturn((Object)node_1);
        Mockito.when((Object)this.csContext.getNode(node_2.getNodeID())).thenReturn((Object)node_2);
        this.cs.getNodeTracker().addNode((SchedulerNode)node_0);
        this.cs.getNodeTracker().addNode((SchedulerNode)node_1);
        this.cs.getNodeTracker().addNode((SchedulerNode)node_2);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Priority priorityAM = TestUtils.createMockPriority(1);
        Priority priorityMap = TestUtils.createMockPriority(5);
        Priority priorityReduce = TestUtils.createMockPriority(10);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, priorityAM, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 5120, 2, true, priorityReduce, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 3072, 2, true, priorityMap, this.recordFactory)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)22528L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)5120L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)19456L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)16384L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)16384L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals(null, (Object)node_0.getReservedContainer());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)13312L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)11264L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)11264L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getReservedContainer().getReservedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)18432L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)13312L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)13312L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)6144L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getReservedContainer().getReservedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_2.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)18432L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)18432L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)18432L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)6144L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals(null, (Object)node_0.getReservedContainer());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)8192L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_2.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
    }

    @Test
    public void testReservationLimitOtherUsers() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setup(csConf, true);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_0 = (FiCaSchedulerApp)Mockito.spy((Object)app_0);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_0)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        this.rmContext.getRMApps().put(app_0.getApplicationId(), (RMApp)Mockito.mock(RMApp.class));
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_1", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_1 = (FiCaSchedulerApp)Mockito.spy((Object)app_1);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_1)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        this.rmContext.getRMApps().put(app_1.getApplicationId(), (RMApp)Mockito.mock(RMApp.class));
        a.submitApplicationAttempt(app_1, "user_1");
        String host_0 = "host_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "host_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        String host_2 = "host_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode(host_2, DEFAULT_RACK, 0, 8192);
        Mockito.when((Object)this.csContext.getNode(node_0.getNodeID())).thenReturn((Object)node_0);
        Mockito.when((Object)this.csContext.getNode(node_1.getNodeID())).thenReturn((Object)node_1);
        Mockito.when((Object)this.csContext.getNode(node_2.getNodeID())).thenReturn((Object)node_2);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1, (Object)node_2.getNodeID(), (Object)node_2);
        this.cs.getNodeTracker().addNode((SchedulerNode)node_0);
        this.cs.getNodeTracker().addNode((SchedulerNode)node_1);
        this.cs.getNodeTracker().addNode((SchedulerNode)node_2);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Priority priorityAM = TestUtils.createMockPriority(1);
        Priority priorityMap = TestUtils.createMockPriority(5);
        Priority priorityReduce = TestUtils.createMockPriority(10);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, priorityAM, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, priorityAM, this.recordFactory)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)22528L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)20480L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2048L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 8192, 2, true, priorityMap, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 2, true, priorityMap, this.recordFactory)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)12288L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)12288L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2048L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)14336L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)6144L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)10240L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
    }

    @Test
    public void testReservationNoContinueLook() throws Exception {
        this.queues = new CSQueueStore();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setBoolean("yarn.scheduler.capacity.reservations-continue-look-all-nodes", false);
        this.setup(csConf);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_0 = (FiCaSchedulerApp)Mockito.spy((Object)app_0);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_0)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        this.rmContext.getRMApps().put(app_0.getApplicationId(), (RMApp)Mockito.mock(RMApp.class));
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_1 = (FiCaSchedulerApp)Mockito.spy((Object)app_1);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_1)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "host_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "host_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        String host_2 = "host_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode(host_2, DEFAULT_RACK, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1, (Object)node_2.getNodeID(), (Object)node_2);
        Mockito.when((Object)this.csContext.getNode(node_0.getNodeID())).thenReturn((Object)node_0);
        Mockito.when((Object)this.csContext.getNode(node_1.getNodeID())).thenReturn((Object)node_1);
        Mockito.when((Object)this.csContext.getNode(node_2.getNodeID())).thenReturn((Object)node_2);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Priority priorityAM = TestUtils.createMockPriority(1);
        Priority priorityMap = TestUtils.createMockPriority(5);
        Priority priorityReduce = TestUtils.createMockPriority(10);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, priorityAM, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 5120, 2, true, priorityReduce, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 3072, 2, true, priorityMap, this.recordFactory)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)22528L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)5120L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)19456L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)16384L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)16384L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals(null, (Object)node_0.getReservedContainer());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)13312L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)11264L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)11264L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getReservedContainer().getReservedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)18432L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)13312L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)13312L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)6144L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getReservedContainer().getReservedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_2.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)18432L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)13312L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)13312L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)6144L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getReservedContainer().getReservedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_2.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
    }

    @Test
    public void testAssignContainersNeedToUnreserve() throws Exception {
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setup(csConf);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_0 = (FiCaSchedulerApp)Mockito.spy((Object)app_0);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_0)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        this.rmContext.getRMApps().put(app_0.getApplicationId(), (RMApp)Mockito.mock(RMApp.class));
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_1 = (FiCaSchedulerApp)Mockito.spy((Object)app_1);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_1)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "host_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "host_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1);
        this.cs.getNodeTracker().addNode((SchedulerNode)node_0);
        this.cs.getNodeTracker().addNode((SchedulerNode)node_1);
        Mockito.when((Object)this.csContext.getNode(node_0.getNodeID())).thenReturn((Object)node_0);
        Mockito.when((Object)this.csContext.getNode(node_1.getNodeID())).thenReturn((Object)node_1);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)16384);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Priority priorityAM = TestUtils.createMockPriority(1);
        Priority priorityMap = TestUtils.createMockPriority(5);
        Priority priorityReduce = TestUtils.createMockPriority(10);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, priorityAM, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 5120, 2, true, priorityReduce, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 3072, 2, true, priorityMap, this.recordFactory)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)14336L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)5120L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)11264L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)8192L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals(null, (Object)node_0.getReservedContainer());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)13312L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)3072L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)3072L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getReservedContainer().getReservedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)13312L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)13312L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)13312L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)3072L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)3072L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals(null, (Object)node_0.getReservedContainer());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)8192L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(TestUtils.toSchedulerKey(priorityReduce)));
    }

    @Test
    public void testGetAppToUnreserve() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setup(csConf);
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        String host_0 = "host_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "host_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        Resource clusterResource = Resources.createResource((int)16384);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Priority p = TestUtils.createMockPriority(5);
        SchedulerRequestKey priorityMap = TestUtils.toSchedulerKey(p);
        Resource capability = Resources.createResource((int)2048, (int)0);
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ContainerAllocationExpirer expirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        DrainDispatcher drainDispatcher = new DrainDispatcher();
        Mockito.when((Object)rmContext.getContainerAllocationExpirer()).thenReturn((Object)expirer);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)drainDispatcher);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)new YarnConfiguration());
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)app_0.getApplicationId(), (int)1);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        Container container = TestUtils.getMockContainer(containerId, node_1.getNodeID(), Resources.createResource((int)2048), priorityMap.getPriority());
        RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttemptId, node_1.getNodeID(), "user", rmContext);
        Container container_1 = TestUtils.getMockContainer(containerId, node_0.getNodeID(), Resources.createResource((int)1024), priorityMap.getPriority());
        RMContainerImpl rmContainer_1 = new RMContainerImpl(container_1, SchedulerRequestKey.extractFrom((Container)container_1), appAttemptId, node_0.getNodeID(), "user", rmContext);
        NodeId unreserveId = app_0.getNodeIdToUnreserve(priorityMap, capability, this.cs.getResourceCalculator());
        Assert.assertEquals(null, (Object)unreserveId);
        app_0.reserve((SchedulerNode)node_0, priorityMap, (RMContainer)rmContainer_1, container_1);
        app_0.unreserve(priorityMap, node_0, (RMContainer)rmContainer_1);
        unreserveId = app_0.getNodeIdToUnreserve(priorityMap, capability, this.cs.getResourceCalculator());
        Assert.assertEquals(null, (Object)unreserveId);
        app_0.reserve((SchedulerNode)node_0, priorityMap, (RMContainer)rmContainer_1, container_1);
        unreserveId = app_0.getNodeIdToUnreserve(priorityMap, capability, this.cs.getResourceCalculator());
        Assert.assertEquals(null, (Object)unreserveId);
        app_0.reserve((SchedulerNode)node_1, priorityMap, (RMContainer)rmContainer, container);
        unreserveId = app_0.getNodeIdToUnreserve(priorityMap, capability, this.cs.getResourceCalculator());
        Assert.assertEquals((Object)node_1.getNodeID(), (Object)unreserveId);
    }

    @Test
    public void testFindNodeToUnreserve() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setup(csConf);
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        String host_1 = "host_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        Priority p = TestUtils.createMockPriority(5);
        SchedulerRequestKey priorityMap = TestUtils.toSchedulerKey(p);
        Resource capability = Resources.createResource((int)2048, (int)0);
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ContainerAllocationExpirer expirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        DrainDispatcher drainDispatcher = new DrainDispatcher();
        Mockito.when((Object)rmContext.getContainerAllocationExpirer()).thenReturn((Object)expirer);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)drainDispatcher);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)new YarnConfiguration());
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)app_0.getApplicationId(), (int)1);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        Container container = TestUtils.getMockContainer(containerId, node_1.getNodeID(), Resources.createResource((int)2048), priorityMap.getPriority());
        RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttemptId, node_1.getNodeID(), "user", rmContext);
        RMContainer toUnreserveContainer = app_0.findNodeToUnreserve(node_1, priorityMap, capability);
        Assert.assertTrue((toUnreserveContainer == null ? 1 : 0) != 0);
        app_0.reserve((SchedulerNode)node_1, priorityMap, (RMContainer)rmContainer, container);
        node_1.reserveResource((SchedulerApplicationAttempt)app_0, priorityMap, (RMContainer)rmContainer);
        toUnreserveContainer = app_0.findNodeToUnreserve(node_1, priorityMap, capability);
        Assert.assertTrue((toUnreserveContainer == null ? 1 : 0) != 0);
    }

    @Test
    public void testAssignToQueue() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setup(csConf);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_0 = (FiCaSchedulerApp)Mockito.spy((Object)app_0);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_0)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        this.rmContext.getRMApps().put(app_0.getApplicationId(), (RMApp)Mockito.mock(RMApp.class));
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_1 = (FiCaSchedulerApp)Mockito.spy((Object)app_1);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_1)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "host_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "host_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        String host_2 = "host_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode(host_2, DEFAULT_RACK, 0, 8192);
        Mockito.when((Object)this.csContext.getNode(node_0.getNodeID())).thenReturn((Object)node_0);
        Mockito.when((Object)this.csContext.getNode(node_1.getNodeID())).thenReturn((Object)node_1);
        Mockito.when((Object)this.csContext.getNode(node_2.getNodeID())).thenReturn((Object)node_2);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1, (Object)node_2.getNodeID(), (Object)node_2);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)16384);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Priority priorityAM = TestUtils.createMockPriority(1);
        Priority priorityMap = TestUtils.createMockPriority(5);
        Priority priorityReduce = TestUtils.createMockPriority(10);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, priorityAM, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 5120, 2, true, priorityReduce, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 3072, 2, true, priorityMap, this.recordFactory)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)14336L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)5120L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)11264L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals(null, (Object)node_0.getReservedContainer());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)13312L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)3072L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)3072L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        ResourceLimits limits = new ResourceLimits(Resources.createResource((int)13312));
        boolean res = a.canAssignToThisQueue(Resources.createResource((int)13312), "", limits, Resources.createResource((int)3072), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        Assert.assertTrue((boolean)res);
        Assert.assertEquals((long)0L, (long)limits.getHeadroom().getMemorySize());
        this.refreshQueuesTurnOffReservationsContLook(a, csConf);
        limits = new ResourceLimits(Resources.createResource((int)13312));
        res = a.canAssignToThisQueue(Resources.createResource((int)13312), "", limits, Resources.createResource((int)3072), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        Assert.assertFalse((boolean)res);
    }

    public void refreshQueuesTurnOffReservationsContLook(LeafQueue a, CapacitySchedulerConfiguration csConf) throws Exception {
        Assert.assertEquals((Object)true, (Object)a.getReservationContinueLooking());
        Assert.assertEquals((Object)true, (Object)((ParentQueue)a.getParent()).getReservationContinueLooking());
        csConf.setBoolean("yarn.scheduler.capacity.reservations-continue-look-all-nodes", false);
        CSQueueStore newQueues = new CSQueueStore();
        CSQueue newRoot = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)csConf, null, (String)"root", (CSQueueStore)newQueues, (CSQueueStore)this.queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        this.queues = newQueues;
        this.root.reinitialize(newRoot, this.cs.getClusterResource());
        Assert.assertEquals((Object)false, (Object)a.getReservationContinueLooking());
        Assert.assertEquals((Object)false, (Object)((ParentQueue)a.getParent()).getReservationContinueLooking());
    }

    @Test
    public void testContinueLookingReservationsAfterQueueRefresh() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setup(csConf);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        this.refreshQueuesTurnOffReservationsContLook(a, csConf);
    }

    @Test
    public void testAssignToUser() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setup(csConf);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_0 = (FiCaSchedulerApp)Mockito.spy((Object)app_0);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_0)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        this.rmContext.getRMApps().put(app_0.getApplicationId(), (RMApp)Mockito.mock(RMApp.class));
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_1 = (FiCaSchedulerApp)Mockito.spy((Object)app_1);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_1)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "host_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "host_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        String host_2 = "host_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode(host_2, DEFAULT_RACK, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1, (Object)node_2.getNodeID(), (Object)node_2);
        Mockito.when((Object)this.csContext.getNode(node_0.getNodeID())).thenReturn((Object)node_0);
        Mockito.when((Object)this.csContext.getNode(node_1.getNodeID())).thenReturn((Object)node_1);
        Mockito.when((Object)this.csContext.getNode(node_2.getNodeID())).thenReturn((Object)node_2);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)16384);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Priority priorityAM = TestUtils.createMockPriority(1);
        Priority priorityMap = TestUtils.createMockPriority(5);
        Priority priorityReduce = TestUtils.createMockPriority(10);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, priorityAM, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 3072, 2, true, priorityMap, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 5120, 2, true, priorityReduce, this.recordFactory)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)14336L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)5120L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)11264L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals(null, (Object)node_0.getReservedContainer());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)13312L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)5120L, (long)app_0.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)3072L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)3072L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Resource limit = Resources.createResource((int)14336, (int)0);
        ResourceLimits userResourceLimits = new ResourceLimits(clusterResource);
        boolean res = a.canAssignToUser(clusterResource, "user_0", limit, app_0, "", userResourceLimits);
        Assert.assertTrue((boolean)res);
        Assert.assertEquals((Object)Resources.none(), (Object)userResourceLimits.getAmountNeededUnreserve());
        limit = Resources.createResource((int)12288, (int)0);
        userResourceLimits = new ResourceLimits(clusterResource);
        res = a.canAssignToUser(clusterResource, "user_0", limit, app_0, "", userResourceLimits);
        Assert.assertTrue((boolean)res);
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)4), (Object)userResourceLimits.getAmountNeededUnreserve());
        this.refreshQueuesTurnOffReservationsContLook(a, csConf);
        userResourceLimits = new ResourceLimits(clusterResource);
        res = a.canAssignToUser(clusterResource, "user_0", limit, app_0, "", userResourceLimits);
        Assert.assertFalse((boolean)res);
        Assert.assertEquals((Object)Resources.none(), (Object)userResourceLimits.getAmountNeededUnreserve());
    }

    @Test
    public void testReservationsNoneAvailable() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setup(csConf);
        LeafQueue a = TestReservations.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_0 = (FiCaSchedulerApp)Mockito.spy((Object)app_0);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_0)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        this.rmContext.getRMApps().put(app_0.getApplicationId(), (RMApp)Mockito.mock(RMApp.class));
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        app_1 = (FiCaSchedulerApp)Mockito.spy((Object)app_1);
        ((FiCaSchedulerApp)Mockito.doNothing().when((Object)app_1)).updateAMContainerDiagnostics((SchedulerApplicationAttempt.AMState)ArgumentMatchers.any(SchedulerApplicationAttempt.AMState.class), (String)ArgumentMatchers.any(String.class));
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "host_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "host_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        String host_2 = "host_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode(host_2, DEFAULT_RACK, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1, (Object)node_2.getNodeID(), (Object)node_2);
        Mockito.when((Object)this.csContext.getNode(node_0.getNodeID())).thenReturn((Object)node_0);
        Mockito.when((Object)this.csContext.getNode(node_1.getNodeID())).thenReturn((Object)node_1);
        Mockito.when((Object)this.csContext.getNode(node_2.getNodeID())).thenReturn((Object)node_2);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Priority priorityAM = TestUtils.createMockPriority(1);
        Priority priorityMap = TestUtils.createMockPriority(5);
        Priority priorityReduce = TestUtils.createMockPriority(10);
        Priority priorityLast = TestUtils.createMockPriority(12);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, priorityAM, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 3072, 2, true, priorityMap, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 5120, 1, true, priorityReduce, this.recordFactory)));
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 8192, 2, true, priorityLast, this.recordFactory)));
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)22528L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)5120L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)5120L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)19456L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)16384L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)16384L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(Resources.createResource((int)10240)), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)16384L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_2, new ResourceLimits(Resources.createResource((int)10240)), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)16384L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)13312L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)13312L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)13312L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)11264L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)11264L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)21504L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)13312L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)13312L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)3072L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)3072L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_2.getAllocatedResource().getMemorySize());
        TestUtils.applyResourceCommitRequest(clusterResource, a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)21504L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)13312L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)13312L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)3072L, (long)a.getMetrics().getAvailableMB());
        Assert.assertEquals((long)3072L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)3072L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)node_2.getAllocatedResource().getMemorySize());
    }
}

