/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmcontainer;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTags;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRMContainerImpl {
    @Test
    public void testReleaseWhileRunning() {
        DrainDispatcher drainDispatcher = new DrainDispatcher();
        EventHandler appAttemptEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        EventHandler generic = (EventHandler)Mockito.mock(EventHandler.class);
        drainDispatcher.register(RMAppAttemptEventType.class, appAttemptEventHandler);
        drainDispatcher.register(RMNodeEventType.class, generic);
        drainDispatcher.init((Configuration)new YarnConfiguration());
        drainDispatcher.start();
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)3425);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerAllocationExpirer expirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        Resource resource = BuilderUtils.newResource((long)512L, (int)1);
        Priority priority2 = BuilderUtils.newPriority((int)5);
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)"host:3465", (Resource)resource, (Priority)priority2, null);
        ConcurrentMap rmApps = (ConcurrentMap)Mockito.spy(new ConcurrentHashMap());
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)rmApp.getRMAppAttempt((ApplicationAttemptId)ArgumentMatchers.any())).thenReturn(null);
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)rmApps)).get(ArgumentMatchers.any());
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)drainDispatcher);
        Mockito.when((Object)rmContext.getContainerAllocationExpirer()).thenReturn((Object)expirer);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn((Object)rmApps);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        AllocationTagsManager ptm = (AllocationTagsManager)Mockito.mock(AllocationTagsManager.class);
        Mockito.when((Object)rmContext.getAllocationTagsManager()).thenReturn((Object)ptm);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.generic-application-history.save-non-am-container-meta-info", true);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)conf);
        RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttemptId, nodeId, "user", rmContext);
        Assert.assertEquals((Object)RMContainerState.NEW, (Object)rmContainer.getState());
        Assert.assertEquals((Object)resource, (Object)rmContainer.getAllocatedResource());
        Assert.assertEquals((Object)nodeId, (Object)rmContainer.getAllocatedNode());
        Assert.assertEquals((Object)priority2, (Object)rmContainer.getAllocatedSchedulerKey().getPriority());
        ((RMApplicationHistoryWriter)Mockito.verify((Object)writer)).containerStarted((RMContainer)ArgumentMatchers.any(RMContainer.class));
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.START));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.ALLOCATED, (Object)rmContainer.getState());
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.ACQUIRED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.ACQUIRED, (Object)rmContainer.getState());
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.RUNNING, (Object)rmContainer.getState());
        ((SystemMetricsPublisher)Mockito.verify((Object)publisher, (VerificationMode)Mockito.times((int)1))).containerCreated((RMContainer)ArgumentMatchers.any(RMContainer.class), ArgumentMatchers.anyLong());
        Assert.assertEquals((Object)"http://host:3465/node/containerlogs/container_1_0001_01_000001/user", (Object)rmContainer.getLogURL());
        Mockito.reset((Object[])new EventHandler[]{appAttemptEventHandler});
        ContainerStatus containerStatus = SchedulerUtils.createAbnormalContainerStatus((ContainerId)containerId, (String)"Container released by application");
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, RMContainerEventType.RELEASED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.RELEASED, (Object)rmContainer.getState());
        Assert.assertEquals((Object)"Container released by application", (Object)rmContainer.getDiagnosticsInfo());
        Assert.assertEquals((long)-100L, (long)rmContainer.getContainerExitStatus());
        Assert.assertEquals((Object)ContainerState.COMPLETE, (Object)rmContainer.getContainerState());
        ((RMApplicationHistoryWriter)Mockito.verify((Object)writer)).containerFinished((RMContainer)ArgumentMatchers.any(RMContainer.class));
        ((SystemMetricsPublisher)Mockito.verify((Object)publisher)).containerFinished((RMContainer)ArgumentMatchers.any(RMContainer.class), ArgumentMatchers.anyLong());
        ArgumentCaptor captor = ArgumentCaptor.forClass(RMAppAttemptContainerFinishedEvent.class);
        ((EventHandler)Mockito.verify((Object)appAttemptEventHandler)).handle((Event)((RMAppAttemptEvent)captor.capture()));
        RMAppAttemptContainerFinishedEvent cfEvent = (RMAppAttemptContainerFinishedEvent)captor.getValue();
        Assert.assertEquals((Object)appAttemptId, (Object)cfEvent.getApplicationAttemptId());
        Assert.assertEquals((Object)containerStatus, (Object)cfEvent.getContainerStatus());
        Assert.assertEquals((Object)RMAppAttemptEventType.CONTAINER_FINISHED, (Object)cfEvent.getType());
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, SchedulerUtils.createAbnormalContainerStatus((ContainerId)containerId, (String)"FinishedContainer"), RMContainerEventType.FINISHED));
        Assert.assertEquals((Object)RMContainerState.RELEASED, (Object)rmContainer.getState());
    }

    @Test
    public void testExpireWhileRunning() {
        DrainDispatcher drainDispatcher = new DrainDispatcher();
        EventHandler appAttemptEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        EventHandler generic = (EventHandler)Mockito.mock(EventHandler.class);
        drainDispatcher.register(RMAppAttemptEventType.class, appAttemptEventHandler);
        drainDispatcher.register(RMNodeEventType.class, generic);
        drainDispatcher.init((Configuration)new YarnConfiguration());
        drainDispatcher.start();
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)3425);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerAllocationExpirer expirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        Resource resource = BuilderUtils.newResource((long)512L, (int)1);
        Priority priority2 = BuilderUtils.newPriority((int)5);
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)"host:3465", (Resource)resource, (Priority)priority2, null);
        ConcurrentHashMap<ApplicationId, RMApp> appMap = new ConcurrentHashMap<ApplicationId, RMApp>();
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        appMap.putIfAbsent(appId, rmApp);
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)drainDispatcher);
        Mockito.when((Object)rmContext.getContainerAllocationExpirer()).thenReturn((Object)expirer);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        AllocationTagsManager ptm = (AllocationTagsManager)Mockito.mock(AllocationTagsManager.class);
        Mockito.when((Object)rmContext.getAllocationTagsManager()).thenReturn((Object)ptm);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.generic-application-history.save-non-am-container-meta-info", true);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(appMap);
        RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttemptId, nodeId, "user", rmContext);
        Assert.assertEquals((Object)RMContainerState.NEW, (Object)rmContainer.getState());
        Assert.assertEquals((Object)resource, (Object)rmContainer.getAllocatedResource());
        Assert.assertEquals((Object)nodeId, (Object)rmContainer.getAllocatedNode());
        Assert.assertEquals((Object)priority2, (Object)rmContainer.getAllocatedSchedulerKey().getPriority());
        ((RMApplicationHistoryWriter)Mockito.verify((Object)writer)).containerStarted((RMContainer)ArgumentMatchers.any(RMContainer.class));
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.START));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.ALLOCATED, (Object)rmContainer.getState());
        ((SystemMetricsPublisher)Mockito.verify((Object)publisher)).containerCreated((RMContainer)ArgumentMatchers.any(RMContainer.class), ArgumentMatchers.anyLong());
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.ACQUIRED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.ACQUIRED, (Object)rmContainer.getState());
        ((SystemMetricsPublisher)Mockito.verify((Object)publisher, (VerificationMode)Mockito.times((int)1))).containerCreated((RMContainer)ArgumentMatchers.any(RMContainer.class), ArgumentMatchers.anyLong());
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.RUNNING, (Object)rmContainer.getState());
        Assert.assertEquals((Object)"http://host:3465/node/containerlogs/container_1_0001_01_000001/user", (Object)rmContainer.getLogURL());
        Mockito.reset((Object[])new EventHandler[]{appAttemptEventHandler});
        ContainerStatus containerStatus = SchedulerUtils.createAbnormalContainerStatus((ContainerId)containerId, (String)"Container expired since it was unused");
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, RMContainerEventType.EXPIRE));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.RUNNING, (Object)rmContainer.getState());
        ((RMApplicationHistoryWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.never())).containerFinished((RMContainer)ArgumentMatchers.any(RMContainer.class));
        ((SystemMetricsPublisher)Mockito.verify((Object)publisher, (VerificationMode)Mockito.never())).containerFinished((RMContainer)ArgumentMatchers.any(RMContainer.class), ArgumentMatchers.anyLong());
    }

    @Test
    public void testExistenceOfResourceRequestInRMContainer() throws Exception {
        Configuration conf = new Configuration();
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        ResourceScheduler scheduler = rm1.getResourceScheduler();
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        Assert.assertNotNull((Object)scheduler.getRMContainer(containerId2).getContainerRequest());
        am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        rm1.waitForState(nm1, containerId2, RMContainerState.ACQUIRED);
        Assert.assertNull((Object)scheduler.getRMContainer(containerId2).getContainerRequest());
    }

    @Test(timeout=180000L)
    public void testStoreAllContainerMetrics() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        conf.setBoolean("yarn.timeline-service.generic-application-history.save-non-am-container-meta-info", true);
        MockRM rm1 = new MockRM(conf);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        rm1.getRMContext().setSystemMetricsPublisher(publisher);
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.RUNNING);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        rm1.waitForState(nm1, containerId2, RMContainerState.ACQUIRED);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.COMPLETE);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(nm1, containerId2, RMContainerState.COMPLETED);
        rm1.stop();
        ((SystemMetricsPublisher)Mockito.verify((Object)publisher, (VerificationMode)Mockito.times((int)2))).containerCreated((RMContainer)ArgumentMatchers.any(RMContainer.class), ArgumentMatchers.anyLong());
        ((SystemMetricsPublisher)Mockito.verify((Object)publisher, (VerificationMode)Mockito.times((int)2))).containerFinished((RMContainer)ArgumentMatchers.any(RMContainer.class), ArgumentMatchers.anyLong());
    }

    @Test(timeout=180000L)
    public void testStoreOnlyAMContainerMetrics() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        conf.setBoolean("yarn.timeline-service.generic-application-history.save-non-am-container-meta-info", false);
        MockRM rm1 = new MockRM(conf);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        rm1.getRMContext().setSystemMetricsPublisher(publisher);
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.RUNNING);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        rm1.waitForState(nm1, containerId2, RMContainerState.ACQUIRED);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.COMPLETE);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm1.waitForState(nm1, containerId2, RMContainerState.COMPLETED);
        rm1.stop();
        ((SystemMetricsPublisher)Mockito.verify((Object)publisher, (VerificationMode)Mockito.times((int)1))).containerCreated((RMContainer)ArgumentMatchers.any(RMContainer.class), ArgumentMatchers.anyLong());
        ((SystemMetricsPublisher)Mockito.verify((Object)publisher, (VerificationMode)Mockito.times((int)1))).containerFinished((RMContainer)ArgumentMatchers.any(RMContainer.class), ArgumentMatchers.anyLong());
    }

    @Test
    public void testContainerTransitionNotifyAllocationTagsManager() throws Exception {
        DrainDispatcher drainDispatcher = new DrainDispatcher();
        EventHandler appAttemptEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        EventHandler generic = (EventHandler)Mockito.mock(EventHandler.class);
        drainDispatcher.register(RMAppAttemptEventType.class, appAttemptEventHandler);
        drainDispatcher.register(RMNodeEventType.class, generic);
        drainDispatcher.init((Configuration)new YarnConfiguration());
        drainDispatcher.start();
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)3425);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerAllocationExpirer expirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        Resource resource = BuilderUtils.newResource((long)512L, (int)1);
        Priority priority2 = BuilderUtils.newPriority((int)5);
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)"host:3465", (Resource)resource, (Priority)priority2, null);
        container.setAllocationTags((Set)ImmutableSet.of((Object)"mapper"));
        ConcurrentMap rmApps = (ConcurrentMap)Mockito.spy(new ConcurrentHashMap());
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)rmApp.getRMAppAttempt((ApplicationAttemptId)ArgumentMatchers.any())).thenReturn(null);
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)rmApps)).get(ArgumentMatchers.any());
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        AllocationTagsManager tagsManager = new AllocationTagsManager(rmContext);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)drainDispatcher);
        Mockito.when((Object)rmContext.getContainerAllocationExpirer()).thenReturn((Object)expirer);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn((Object)rmApps);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        Mockito.when((Object)rmContext.getAllocationTagsManager()).thenReturn((Object)tagsManager);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.generic-application-history.save-non-am-container-meta-info", true);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)conf);
        RMNodeImpl rmNode = new RMNodeImpl(nodeId, rmContext, "localhost", 0, 0, null, Resource.newInstance((int)10240, (int)10), null);
        FiCaSchedulerNode schedulerNode = new FiCaSchedulerNode((RMNode)rmNode, false);
        RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttemptId, nodeId, "user", rmContext);
        Assert.assertEquals((long)0L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)TestUtils.getMockApplicationId(1), null), Long::max));
        rmContainer.handle(new RMContainerEvent(containerId, RMContainerEventType.START));
        schedulerNode.allocateContainer((RMContainer)rmContainer);
        Assert.assertEquals((long)1L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
        rmContainer.handle((RMContainerEvent)new RMContainerFinishedEvent(containerId, ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0), RMContainerEventType.KILL));
        schedulerNode.releaseContainer(container.getId(), true);
        Assert.assertEquals((long)0L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
        rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttemptId, nodeId, "user", rmContext);
        Assert.assertEquals((long)0L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
        rmContainer.setAllocationTags((Set)ImmutableSet.of((Object)"mapper"));
        rmContainer.handle(new RMContainerEvent(containerId, RMContainerEventType.START));
        schedulerNode.allocateContainer((RMContainer)rmContainer);
        Assert.assertEquals((long)1L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
        rmContainer.handle(new RMContainerEvent(containerId, RMContainerEventType.ACQUIRED));
        rmContainer.handle((RMContainerEvent)new RMContainerFinishedEvent(containerId, ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0), RMContainerEventType.FINISHED));
        schedulerNode.releaseContainer(container.getId(), true);
        Assert.assertEquals((long)0L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
        rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttemptId, nodeId, "user", rmContext);
        rmContainer.setAllocationTags((Set)ImmutableSet.of((Object)"mapper"));
        Assert.assertEquals((long)0L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
        rmContainer.handle(new RMContainerEvent(containerId, RMContainerEventType.START));
        schedulerNode.allocateContainer((RMContainer)rmContainer);
        Assert.assertEquals((long)1L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
        rmContainer.handle(new RMContainerEvent(containerId, RMContainerEventType.ACQUIRED));
        rmContainer.handle(new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        rmContainer.handle((RMContainerEvent)new RMContainerFinishedEvent(containerId, ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0), RMContainerEventType.FINISHED));
        schedulerNode.releaseContainer(container.getId(), true);
        Assert.assertEquals((long)0L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
        rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttemptId, nodeId, "user", rmContext);
        rmContainer.setAllocationTags((Set)ImmutableSet.of((Object)"mapper"));
        Assert.assertEquals((long)0L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
        NMContainerStatus containerStatus = NMContainerStatus.newInstance((ContainerId)containerId, (int)0, (ContainerState)ContainerState.NEW, (Resource)Resource.newInstance((int)1024, (int)1), (String)"recover container", (int)0, (Priority)Priority.newInstance((int)0), (long)0L);
        containerStatus.setAllocationTags((Set)ImmutableSet.of((Object)"mapper"));
        rmContainer.handle((RMContainerEvent)new RMContainerRecoverEvent(containerId, containerStatus));
        Assert.assertEquals((long)1L, (long)tagsManager.getNodeCardinalityByOp(nodeId, AllocationTags.createSingleAppAllocationTags((ApplicationId)appId, null), Long::max));
    }

    @Test(timeout=30000L)
    public void testContainerAcquiredAtKilled() {
        DrainDispatcher drainDispatcher = new DrainDispatcher();
        EventHandler appAttemptEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        EventHandler generic = (EventHandler)Mockito.mock(EventHandler.class);
        drainDispatcher.register(RMAppAttemptEventType.class, appAttemptEventHandler);
        drainDispatcher.register(RMNodeEventType.class, generic);
        drainDispatcher.init((Configuration)new YarnConfiguration());
        drainDispatcher.start();
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)3425);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerAllocationExpirer expirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        Resource resource = BuilderUtils.newResource((long)512L, (int)1);
        Priority priority2 = BuilderUtils.newPriority((int)5);
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)"host:3465", (Resource)resource, (Priority)priority2, null);
        ConcurrentHashMap<ApplicationId, RMApp> appMap = new ConcurrentHashMap<ApplicationId, RMApp>();
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        appMap.putIfAbsent(appId, rmApp);
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)drainDispatcher);
        Mockito.when((Object)rmContext.getContainerAllocationExpirer()).thenReturn((Object)expirer);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        AllocationTagsManager ptm = (AllocationTagsManager)Mockito.mock(AllocationTagsManager.class);
        Mockito.when((Object)rmContext.getAllocationTagsManager()).thenReturn((Object)ptm);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.generic-application-history.save-non-am-container-meta-info", true);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(appMap);
        RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttemptId, nodeId, "user", rmContext){

            protected void onInvalidStateTransition(RMContainerEventType rmContainerEventType, RMContainerState state) {
                Assert.fail((String)("RMContainerImpl: can't handle " + rmContainerEventType + " at state " + state));
            }
        };
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.KILL));
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.ACQUIRED));
    }
}

