/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.TimelineServiceV2Publisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSystemMetricsPublisherForV2 {
    private static File testRootDir = new File("target", TestSystemMetricsPublisherForV2.class.getName() + "-localDir").getAbsoluteFile();
    private static TimelineServiceV2Publisher metricsPublisher;
    private static DrainDispatcher dispatcher;
    private static ConcurrentMap<ApplicationId, RMApp> rmAppsMapInContext;
    private static RMTimelineCollectorManager rmTimelineCollectorManager;

    @BeforeClass
    public static void setup() throws Exception {
        if (testRootDir.exists()) {
            FileContext.getLocalFSFileContext().delete(new Path(testRootDir.getAbsolutePath()), true);
        }
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        rmAppsMapInContext = new ConcurrentHashMap<ApplicationId, RMApp>();
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(rmAppsMapInContext);
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        rmTimelineCollectorManager = new RMTimelineCollectorManager(rm);
        Mockito.when((Object)rmContext.getRMTimelineCollectorManager()).thenReturn((Object)rmTimelineCollectorManager);
        Configuration conf = TestSystemMetricsPublisherForV2.getTimelineV2Conf();
        conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        rmTimelineCollectorManager.init(conf);
        rmTimelineCollectorManager.start();
        dispatcher.init(conf);
        dispatcher.start();
        metricsPublisher = new TimelineServiceV2Publisher(rmTimelineCollectorManager){

            protected Dispatcher getDispatcher() {
                return dispatcher;
            }
        };
        metricsPublisher.init(conf);
        metricsPublisher.start();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (testRootDir.exists()) {
            FileContext.getLocalFSFileContext().delete(new Path(testRootDir.getAbsolutePath()), true);
        }
        if (rmTimelineCollectorManager != null) {
            rmTimelineCollectorManager.stop();
        }
        if (metricsPublisher != null) {
            metricsPublisher.stop();
        }
    }

    private static Configuration getTimelineV2Conf() {
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 2.0f);
        conf.setBoolean("yarn.system-metrics-publisher.enabled", true);
        conf.setInt("yarn.resourcemanager.system-metrics-publisher.dispatcher.pool-size", 2);
        conf.setBoolean("yarn.rm.system-metrics-publisher.emit-container-events", true);
        try {
            conf.set("yarn.timeline-service.fs-writer.root-dir", testRootDir.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Exception while setting the TIMELINE_SERVICE_STORAGE_DIR_ROOT ");
        }
        return conf;
    }

    @Test
    public void testSystemMetricPublisherInitialization() {
        TimelineServiceV2Publisher publisher = new TimelineServiceV2Publisher((RMTimelineCollectorManager)Mockito.mock(RMTimelineCollectorManager.class));
        try {
            Configuration conf = TestSystemMetricsPublisherForV2.getTimelineV2Conf();
            conf.setBoolean("yarn.rm.system-metrics-publisher.emit-container-events", false);
            publisher.init(conf);
            Assert.assertFalse((String)"Default configuration should not publish container events from RM", (boolean)publisher.isPublishContainerEvents());
            publisher.stop();
            publisher = new TimelineServiceV2Publisher((RMTimelineCollectorManager)Mockito.mock(RMTimelineCollectorManager.class));
            conf = TestSystemMetricsPublisherForV2.getTimelineV2Conf();
            publisher.init(conf);
            Assert.assertTrue((String)"Expected to have registered event handlers and set ready to publish events after init", (boolean)publisher.isPublishContainerEvents());
            publisher.start();
            Assert.assertTrue((String)"Expected to publish container events from RM", (boolean)publisher.isPublishContainerEvents());
        }
        finally {
            publisher.stop();
        }
    }

    @Test(timeout=10000L)
    public void testPublishApplicationMetrics() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        RMApp app = this.createAppAndRegister(appId);
        metricsPublisher.appCreated(app, app.getStartTime());
        metricsPublisher.appLaunched(app, app.getLaunchTime());
        metricsPublisher.appACLsUpdated(app, "user1,user2", 4L);
        metricsPublisher.appFinished(app, RMAppState.FINISHED, app.getFinishTime());
        dispatcher.await();
        String outputDirApp = this.getTimelineEntityDir(app) + "/" + TimelineEntityType.YARN_APPLICATION + "/";
        File entityFolder = new File(outputDirApp);
        Assert.assertTrue((boolean)entityFolder.isDirectory());
        String timelineServiceFileName = appId.toString() + ".thist";
        File appFile = new File(outputDirApp, timelineServiceFileName);
        Assert.assertTrue((boolean)appFile.exists());
        TestSystemMetricsPublisherForV2.verifyEntity(appFile, 4L, "YARN_APPLICATION_CREATED", 8L, 0L);
    }

    @Test(timeout=10000L)
    public void testPublishAppAttemptMetrics() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        RMApp app = (RMApp)rmAppsMapInContext.get(appId);
        if (app == null) {
            app = this.createAppAndRegister(appId);
        }
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        RMAppAttempt appAttempt = TestSystemMetricsPublisherForV2.createRMAppAttempt(appAttemptId);
        metricsPublisher.appAttemptRegistered(appAttempt, 0x80000000L);
        Mockito.when((Object)app.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.UNDEFINED);
        metricsPublisher.appAttemptFinished(appAttempt, RMAppAttemptState.FINISHED, app, 0x80000001L);
        dispatcher.await();
        String outputDirApp = this.getTimelineEntityDir(app) + "/" + TimelineEntityType.YARN_APPLICATION_ATTEMPT + "/";
        File entityFolder = new File(outputDirApp);
        Assert.assertTrue((boolean)entityFolder.isDirectory());
        String timelineServiceFileName = appAttemptId.toString() + ".thist";
        File appFile = new File(outputDirApp, timelineServiceFileName);
        Assert.assertTrue((boolean)appFile.exists());
        TestSystemMetricsPublisherForV2.verifyEntity(appFile, 2L, "YARN_APPLICATION_ATTEMPT_REGISTERED", 0L, TimelineServiceHelper.invertLong((long)appAttemptId.getAttemptId()));
    }

    @Test(timeout=10000L)
    public void testPublishContainerMetrics() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        RMApp app = (RMApp)rmAppsMapInContext.get(appId);
        if (app == null) {
            app = this.createAppAndRegister(appId);
        }
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), (long)1L);
        RMContainer container = TestSystemMetricsPublisherForV2.createRMContainer(containerId);
        metricsPublisher.containerCreated(container, container.getCreationTime());
        metricsPublisher.containerFinished(container, container.getFinishTime());
        dispatcher.await();
        String outputDirApp = this.getTimelineEntityDir(app) + "/" + TimelineEntityType.YARN_CONTAINER + "/";
        File entityFolder = new File(outputDirApp);
        Assert.assertTrue((boolean)entityFolder.isDirectory());
        String timelineServiceFileName = containerId.toString() + ".thist";
        File appFile = new File(outputDirApp, timelineServiceFileName);
        Assert.assertTrue((boolean)appFile.exists());
        TestSystemMetricsPublisherForV2.verifyEntity(appFile, 2L, "YARN_RM_CONTAINER_CREATED", 0L, TimelineServiceHelper.invertLong((long)containerId.getContainerId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testPutEntityWhenNoCollector() throws Exception {
        class TestAppender
        extends AppenderSkeleton {
            private final List<LoggingEvent> log = new ArrayList<LoggingEvent>();

            TestAppender() {
            }

            public boolean requiresLayout() {
                return false;
            }

            protected void append(LoggingEvent loggingEvent) {
                this.log.add(loggingEvent);
            }

            public void close() {
            }

            public List<LoggingEvent> getLog() {
                return new ArrayList<LoggingEvent>(this.log);
            }
        }
        TestAppender appender = new TestAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        try {
            RMApp app = TestSystemMetricsPublisherForV2.createRMApp(ApplicationId.newInstance((long)0L, (int)1));
            metricsPublisher.appCreated(app, app.getStartTime());
            dispatcher.await();
            for (LoggingEvent event : appender.getLog()) {
                Assert.assertFalse((String)"Dispatcher Crashed", (boolean)event.getRenderedMessage().contains("Error in dispatcher thread"));
            }
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
    }

    private RMApp createAppAndRegister(ApplicationId appId) {
        RMApp app = TestSystemMetricsPublisherForV2.createRMApp(appId);
        rmAppsMapInContext.putIfAbsent(appId, app);
        AppLevelTimelineCollector collector = new AppLevelTimelineCollector(appId);
        rmTimelineCollectorManager.putIfAbsent(appId, (TimelineCollector)collector);
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyEntity(File entityFile, long expectedEvents, String eventForCreatedTime, long expectedMetrics, long idPrefix) throws IOException {
        BufferedReader reader = null;
        long count = 0L;
        long metricsCount = 0L;
        try {
            String strLine;
            reader = new BufferedReader(new FileReader(entityFile));
            while ((strLine = reader.readLine()) != null) {
                if (strLine.trim().length() <= 0) continue;
                TimelineEntity entity = (TimelineEntity)FileSystemTimelineReaderImpl.getTimelineRecordFromJSON((String)strLine.trim(), TimelineEntity.class);
                metricsCount = entity.getMetrics().size();
                Assert.assertEquals((long)idPrefix, (long)entity.getIdPrefix());
                for (TimelineEvent event : entity.getEvents()) {
                    if (!event.getId().equals(eventForCreatedTime)) continue;
                    Assert.assertTrue((entity.getCreatedTime() > 0L ? 1 : 0) != 0);
                    break;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        Assert.assertEquals((String)("Expected " + expectedEvents + " events to be published"), (long)expectedEvents, (long)count);
        Assert.assertEquals((String)("Expected " + expectedMetrics + " metrics is incorrect"), (long)expectedMetrics, (long)metricsCount);
    }

    private String getTimelineEntityDir(RMApp app) {
        String outputDirApp = testRootDir.getAbsolutePath() + "/" + "entities" + "/" + "yarn_cluster" + "/" + app.getUser() + "/" + app.getName() + "/" + "1" + "/" + app.getStartTime() + "/" + app.getApplicationId();
        return outputDirApp;
    }

    private static RMApp createRMApp(ApplicationId appId) {
        RMApp app = (RMApp)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)app.getName()).thenReturn((Object)"test app");
        Mockito.when((Object)app.getApplicationType()).thenReturn((Object)"test app type");
        Mockito.when((Object)app.getUser()).thenReturn((Object)"testUser");
        Mockito.when((Object)app.getQueue()).thenReturn((Object)"test queue");
        Mockito.when((Object)app.getSubmitTime()).thenReturn((Object)0x80000000L);
        Mockito.when((Object)app.getStartTime()).thenReturn((Object)0x80000001L);
        Mockito.when((Object)app.getLaunchTime()).thenReturn((Object)0x80000001L);
        Mockito.when((Object)app.getFinishTime()).thenReturn((Object)0x80000002L);
        Mockito.when((Object)app.getDiagnostics()).thenReturn((Object)new StringBuilder("test diagnostics info"));
        RMAppAttempt appAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)appAttempt.getAppAttemptId()).thenReturn((Object)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1));
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)appAttempt);
        Mockito.when((Object)app.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.UNDEFINED);
        HashMap<String, Long> resourceSecondsMap = new HashMap<String, Long>();
        resourceSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), (Long)Integer.MAX_VALUE);
        resourceSecondsMap.put(ResourceInformation.VCORES.getName(), Long.MAX_VALUE);
        Mockito.when((Object)app.getRMAppMetrics()).thenReturn((Object)new RMAppMetrics(Resource.newInstance((int)0, (int)0), 0, 0, resourceSecondsMap, new HashMap(), 0));
        Mockito.when((Object)app.getApplicationTags()).thenReturn(Collections.emptySet());
        ApplicationSubmissionContext appSubmissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)appSubmissionContext.getPriority()).thenReturn((Object)Priority.newInstance((int)0));
        Mockito.when((Object)app.getApplicationPriority()).thenReturn((Object)Priority.newInstance((int)10));
        ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
        Mockito.when((Object)containerLaunchContext.getCommands()).thenReturn(Collections.singletonList("java -Xmx1024m"));
        Mockito.when((Object)appSubmissionContext.getAMContainerSpec()).thenReturn((Object)containerLaunchContext);
        Mockito.when((Object)app.getApplicationSubmissionContext()).thenReturn((Object)appSubmissionContext);
        Mockito.when((Object)app.getState()).thenReturn((Object)RMAppState.SUBMITTED);
        return app;
    }

    private static RMAppAttempt createRMAppAttempt(ApplicationAttemptId appAttemptId) {
        RMAppAttempt appAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)appAttempt.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)appAttempt.getHost()).thenReturn((Object)"test host");
        Mockito.when((Object)appAttempt.getRpcPort()).thenReturn((Object)-100);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L));
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)NodeId.newInstance((String)"testhost", (int)8042));
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"testhost:25050");
        Mockito.when((Object)appAttempt.getMasterContainer()).thenReturn((Object)container);
        Mockito.when((Object)appAttempt.getDiagnostics()).thenReturn((Object)"test diagnostics info");
        Mockito.when((Object)appAttempt.getTrackingUrl()).thenReturn((Object)"test tracking url");
        Mockito.when((Object)appAttempt.getOriginalTrackingUrl()).thenReturn((Object)"test original tracking url");
        Mockito.when((Object)appAttempt.getStartTime()).thenReturn((Object)200L);
        return appAttempt;
    }

    private static RMContainer createRMContainer(ContainerId containerId) {
        RMContainer container = (RMContainer)Mockito.mock(RMContainer.class);
        Mockito.when((Object)container.getContainerId()).thenReturn((Object)containerId);
        Mockito.when((Object)container.getAllocatedNode()).thenReturn((Object)NodeId.newInstance((String)"test host", (int)-100));
        Mockito.when((Object)container.getAllocatedResource()).thenReturn((Object)Resource.newInstance((int)-1, (int)-1));
        Mockito.when((Object)container.getAllocatedPriority()).thenReturn((Object)Priority.UNDEFINED);
        Mockito.when((Object)container.getCreationTime()).thenReturn((Object)0x80000000L);
        Mockito.when((Object)container.getFinishTime()).thenReturn((Object)0x80000001L);
        Mockito.when((Object)container.getDiagnosticsInfo()).thenReturn((Object)"test diagnostics info");
        Mockito.when((Object)container.getContainerExitStatus()).thenReturn((Object)-1);
        Mockito.when((Object)container.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
        Container mockContainer = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getContainer()).thenReturn((Object)mockContainer);
        Mockito.when((Object)mockContainer.getNodeHttpAddress()).thenReturn((Object)"http://localhost:1234");
        return container;
    }

    static {
        dispatcher = new DrainDispatcher();
    }
}

