/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCapacitySchedulerMaxParallelApps {
    private CapacitySchedulerConfiguration conf;
    private MockRM rm;
    private MockNM nm1;
    private RMApp app1;
    private MockAM am1;
    private RMApp app2;
    private MockAM am2;
    private RMApp app3;
    private RMAppAttempt attempt3;
    private RMApp app4;
    private RMAppAttempt attempt4;
    private ParentQueue rootQueue;
    private LeafQueue defaultQueue;

    @Before
    public void setUp() {
        CapacitySchedulerConfiguration config = new CapacitySchedulerConfiguration();
        config.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        this.conf = new CapacitySchedulerConfiguration((Configuration)config);
    }

    @After
    public void after() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test(timeout=30000L)
    public void testMaxParallelAppsExceedsQueueSetting() throws Exception {
        this.conf.setInt("yarn.scheduler.capacity.root.default.max-parallel-apps", 2);
        this.executeCommonStepsAndChecks();
        this.testWhenSettingsExceeded();
    }

    @Test(timeout=30000L)
    public void testMaxParallelAppsExceedsDefaultQueueSetting() throws Exception {
        this.conf.setInt("yarn.scheduler.capacity.max-parallel-apps", 2);
        this.executeCommonStepsAndChecks();
        this.testWhenSettingsExceeded();
    }

    @Test(timeout=30000L)
    public void testMaxParallelAppsExceedsUserSetting() throws Exception {
        this.conf.setInt("yarn.scheduler.capacity.user.testuser.max-parallel-apps", 2);
        this.executeCommonStepsAndChecks();
        this.testWhenSettingsExceeded();
    }

    @Test(timeout=30000L)
    public void testMaxParallelAppsExceedsDefaultUserSetting() throws Exception {
        this.conf.setInt("yarn.scheduler.capacity.user.max-parallel-apps", 2);
        this.executeCommonStepsAndChecks();
        this.testWhenSettingsExceeded();
    }

    @Test(timeout=30000L)
    public void testMaxParallelAppsWhenReloadingConfig() throws Exception {
        this.conf.setInt("yarn.scheduler.capacity.root.default.max-parallel-apps", 2);
        this.executeCommonStepsAndChecks();
        RMContext rmContext = this.rm.getRMContext();
        this.conf.unset("yarn.scheduler.capacity.root.default.max-parallel-apps");
        this.conf.setFloat("yarn.scheduler.capacity.maximum-am-resource-percent", 1.0f);
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        cs.reinitialize((Configuration)this.conf, rmContext);
        this.launchAMandWaitForRunning(this.app3, this.attempt3, this.nm1);
        this.launchAMandWaitForRunning(this.app4, this.attempt4, this.nm1);
        this.verifyRunningAndAcceptedApps(4, 0);
    }

    @Test(timeout=30000L)
    public void testMaxAppsReachedWithNonRunnableApps() throws Exception {
        this.conf.setInt("yarn.scheduler.capacity.root.default.max-parallel-apps", 2);
        this.conf.setInt("yarn.scheduler.capacity.root.default.maximum-applications", 4);
        this.executeCommonStepsAndChecks();
        RMApp app5 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app5").withUser("testuser").withQueue("default").withWaitForAppAcceptedState(false).build());
        this.rm.waitForState(app5.getApplicationId(), RMAppState.FAILED);
    }

    private void executeCommonStepsAndChecks() throws Exception {
        this.rm = new MockRM((Configuration)this.conf);
        this.rm.start();
        this.nm1 = this.rm.registerNode("h1:1234", 4096, 8);
        this.rm.registerNode("h2:1234", 4096, 8);
        this.rm.registerNode("h3:1234", 4096, 8);
        this.rm.drainEvents();
        this.app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app1").withUser("testuser").withQueue("default").build());
        this.am1 = MockRM.launchAndRegisterAM(this.app1, this.rm, this.nm1);
        this.app2 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app2").withUser("testuser").withQueue("default").build());
        this.am2 = MockRM.launchAndRegisterAM(this.app2, this.rm, this.nm1);
        this.app3 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app3").withUser("testuser").withQueue("default").build());
        this.attempt3 = MockRM.waitForAttemptScheduled(this.app3, this.rm);
        this.app4 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app4").withUser("testuser").withQueue("default").build());
        this.attempt4 = MockRM.waitForAttemptScheduled(this.app4, this.rm);
        this.rootQueue = this.getRootQueue();
        this.defaultQueue = this.getDefaultQueue();
        HashSet nonRunnables = Sets.newHashSet((Object[])new ApplicationAttemptId[]{this.attempt3.getAppAttemptId(), this.attempt4.getAppAttemptId()});
        this.verifyRunnableAppsInParent(this.rootQueue, 2);
        this.verifyRunnableAppsInLeaf(this.defaultQueue, 2, nonRunnables);
        this.verifyRunningAndAcceptedApps(2, 2);
    }

    private void testWhenSettingsExceeded() throws Exception {
        this.unregisterAMandWaitForFinish(this.app1, this.am1, this.nm1);
        this.launchAMandWaitForRunning(this.app3, this.attempt3, this.nm1);
        this.verifyRunnableAppsInParent(this.rootQueue, 2);
        this.verifyRunnableAppsInLeaf(this.defaultQueue, 2, Collections.singleton(this.attempt4.getAppAttemptId()));
        this.verifyRunningAndAcceptedApps(2, 1);
        this.unregisterAMandWaitForFinish(this.app2, this.am2, this.nm1);
        this.launchAMandWaitForRunning(this.app4, this.attempt4, this.nm1);
        this.verifyRunnableAppsInParent(this.rootQueue, 2);
        this.verifyRunnableAppsInLeaf(this.defaultQueue, 2, Collections.emptySet());
        this.verifyRunningAndAcceptedApps(2, 0);
    }

    private LeafQueue getDefaultQueue() {
        CSQueue defaultQueue = ((CapacityScheduler)this.rm.getResourceScheduler()).getQueue("default");
        return (LeafQueue)defaultQueue;
    }

    private ParentQueue getRootQueue() {
        CSQueue root = ((CapacityScheduler)this.rm.getResourceScheduler()).getQueue("root");
        return (ParentQueue)root;
    }

    private void verifyRunnableAppsInParent(ParentQueue queue, int expectedRunnable) {
        Assert.assertEquals((String)"Num of runnable apps", (long)expectedRunnable, (long)queue.getNumRunnableApps());
    }

    private void verifyRunnableAppsInLeaf(LeafQueue queue, int expectedRunnable, Set<ApplicationAttemptId> nonRunnableIds) {
        Assert.assertEquals((String)"Num of runnable apps", (long)expectedRunnable, (long)queue.getNumRunnableApps());
        queue.getCopyOfNonRunnableAppSchedulables().stream().map(fca -> fca.getApplicationAttemptId()).forEach(id -> Assert.assertTrue((String)(id + " not found as non-runnable"), (boolean)nonRunnableIds.contains(id)));
    }

    private void verifyRunningAndAcceptedApps(int expectedRunning, int expectedAccepted) throws YarnException {
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        GetApplicationsResponse resp = this.rm.getClientRMService().getApplications(request);
        List apps = resp.getApplicationList();
        long runningCount = apps.stream().filter(report -> report.getYarnApplicationState() == YarnApplicationState.RUNNING).count();
        long acceptedCount = apps.stream().filter(report -> report.getYarnApplicationState() == YarnApplicationState.ACCEPTED).count();
        Assert.assertEquals((String)"Running apps count", (long)expectedRunning, (long)runningCount);
        Assert.assertEquals((String)"Accepted apps count", (long)expectedAccepted, (long)acceptedCount);
    }

    private void unregisterAMandWaitForFinish(RMApp app, MockAM am, MockNM nm) throws Exception {
        am.unregisterAppAttempt();
        nm.nodeHeartbeat(app.getCurrentAppAttempt().getAppAttemptId(), 1L, ContainerState.COMPLETE);
        this.rm.waitForState(app.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptState.FINISHED);
    }

    private MockAM launchAMandWaitForRunning(RMApp app, RMAppAttempt attempt, MockNM nm) throws Exception {
        nm.nodeHeartbeat(true);
        ((AbstractYarnScheduler)this.rm.getResourceScheduler()).update();
        this.rm.drainEvents();
        nm.nodeHeartbeat(true);
        MockAM am = this.rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        this.rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        return am;
    }
}

