/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerMetrics;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestCapacitySchedulerMetrics {
    private MockRM rm;

    @Test
    public void testCSMetrics() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", true);
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)conf);
        this.rm = new MockRM((Configuration)conf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        this.rm.getRMContext().setNodeLabelManager((RMNodeLabelsManager)mgr);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 2048);
        MockNM nm2 = this.rm.registerNode("host2:1234", 2048);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        CapacitySchedulerMetrics csMetrics = CapacitySchedulerMetrics.getMetrics();
        Assert.assertNotNull((Object)csMetrics);
        try {
            GenericTestUtils.waitFor(() -> csMetrics.getNumOfNodeUpdate() == 2L, (long)100L, (long)3000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"CS metrics not updated on node-update events.");
        }
        Assert.assertEquals((long)0L, (long)csMetrics.getNumOfAllocates());
        Assert.assertEquals((long)0L, (long)csMetrics.getNumOfCommitSuccess());
        RMApp rmApp = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app").withUser("user").withAcls(null).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(1).withCredentials(null).withAppType(null).withWaitForAppAcceptedState(false).build());
        MockAM am = MockRM.launchAMWhenAsyncSchedulingEnabled(rmApp, this.rm);
        am.registerAppAttempt();
        am.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        try {
            GenericTestUtils.waitFor(() -> csMetrics.getNumOfNodeUpdate() == 4L, (long)100L, (long)3000L);
            Assert.assertTrue((csMetrics.getNumOfAllocates() > 0L ? 1 : 0) != 0);
            GenericTestUtils.waitFor(() -> csMetrics.getNumOfCommitSuccess() == 2L, (long)100L, (long)3000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"CS metrics not updated on node-update events.");
        }
    }

    @After
    public void tearDown() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }
}

